/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.text;

import java.io.OutputStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.format.text.EscapeOutputStream;
import net.thevpc.nuts.runtime.core.format.text.ExtendedFormatAware;
import net.thevpc.nuts.runtime.core.format.text.FilterFormatOutputStream;
import net.thevpc.nuts.runtime.core.format.text.FormatOutputStream;
import net.thevpc.nuts.runtime.core.format.text.UnescapeOutputStream;
import net.thevpc.nuts.runtime.core.io.BaseTransparentFilterOutputStream;
import net.thevpc.nuts.runtime.core.terminals.NutsTerminalModeOp;

public class RawOutputStream
extends BaseTransparentFilterOutputStream
implements ExtendedFormatAware {
    private NutsSession session;
    private NutsWorkspace ws;

    public RawOutputStream(OutputStream out, NutsSession session) {
        super(out);
        this.session = session;
        this.ws = session.getWorkspace();
    }

    @Override
    public NutsTerminalModeOp getModeOp() {
        return NutsTerminalModeOp.NOP;
    }

    @Override
    public ExtendedFormatAware convert(NutsTerminalModeOp other) {
        if (other == null || other == this.getModeOp()) {
            return this;
        }
        switch (other) {
            case NOP: {
                return this;
            }
            case FORMAT: {
                return new FormatOutputStream(this.out, this.session);
            }
            case FILTER: {
                return new FilterFormatOutputStream(this.out, this.session);
            }
            case ESCAPE: {
                return new EscapeOutputStream(this, this.session);
            }
            case UNESCAPE: {
                return new UnescapeOutputStream(this, this.session);
            }
        }
        throw new IllegalArgumentException("Unsupported");
    }
}

