/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.text;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextList;
import net.thevpc.nuts.NutsTextNumbering;
import net.thevpc.nuts.NutsTextPlain;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyles;
import net.thevpc.nuts.NutsTextType;
import net.thevpc.nuts.NutsTextWriteConfiguration;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.format.text.AbstractNutsTextNodeWriter;
import net.thevpc.nuts.runtime.core.format.text.parser.DefaultNutsTextAnchor;
import net.thevpc.nuts.runtime.core.format.text.parser.DefaultNutsTextCode;
import net.thevpc.nuts.runtime.core.format.text.parser.DefaultNutsTextCommand;
import net.thevpc.nuts.runtime.core.format.text.parser.DefaultNutsTextLink;
import net.thevpc.nuts.runtime.core.format.text.parser.DefaultNutsTextStyled;
import net.thevpc.nuts.runtime.core.format.text.parser.DefaultNutsTextTitle;

public class NutsTextNodeWriterStringer
extends AbstractNutsTextNodeWriter {
    private OutputStream out;
    private NutsWorkspace ws;

    public NutsTextNodeWriterStringer(OutputStream out, NutsWorkspace ws) {
        this.out = out;
        this.ws = ws;
    }

    public static String toString(NutsText n, NutsWorkspace ws) {
        if (n == null) {
            return "";
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        new NutsTextNodeWriterStringer(bos, ws).writeNode(n, new NutsTextWriteConfiguration());
        return bos.toString();
    }

    @Override
    public void writeNode(NutsText node) {
        this.writeNode(node, this.getWriteConfiguration());
    }

    @Override
    public void writeRaw(byte[] buf, int off, int len) {
        this.writeRaw(new String(buf, off, len));
    }

    @Override
    public void writeRaw(char[] buf, int off, int len) {
        this.writeRaw(new String(buf, off, len));
    }

    @Override
    public boolean flush() {
        try {
            this.out.flush();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return true;
    }

    public void writeNode(NutsText node, NutsTextWriteConfiguration ctx) {
        if (node == null) {
            return;
        }
        if (ctx == null) {
            ctx = new NutsTextWriteConfiguration();
        }
        switch (node.getType()) {
            case PLAIN: {
                NutsTextPlain p = (NutsTextPlain)node;
                if (ctx.isFiltered()) {
                    this.writeRaw(p.getText());
                    break;
                }
                this.writeEscaped(p.getText());
                break;
            }
            case LIST: {
                NutsTextList s = (NutsTextList)node;
                for (NutsText n : s) {
                    this.writeNode(n, ctx);
                }
                break;
            }
            case STYLED: {
                DefaultNutsTextStyled s = (DefaultNutsTextStyled)node;
                if (ctx.isFiltered()) {
                    this.writeNode(s.getChild(), ctx);
                    break;
                }
                if (s.getChild().getType() == NutsTextType.PLAIN) {
                    NutsTextStyles styles = s.getStyles();
                    this.writeStyledStart(s.getStyles().get(0), false);
                    if (styles.size() <= 1) {
                        this.writeNode(s.getChild(), ctx);
                    } else {
                        this.writeNode((NutsText)this.ws.text().forStyled(s.getChild(), s.getStyles().removeFirst()), ctx);
                    }
                    this.writeRaw(s.getEnd());
                    this.writeRaw('\u001e');
                    break;
                }
                NutsTextStyles styles = s.getStyles();
                this.writeStyledStart(s.getStyles().get(0), true);
                if (styles.size() <= 1) {
                    this.writeNode(s.getChild(), ctx);
                } else {
                    this.writeNode((NutsText)this.ws.text().forStyled(s.getChild(), s.getStyles().removeFirst()), ctx);
                }
                this.writeRaw("}##");
                this.writeRaw('\u001e');
                break;
            }
            case TITLE: {
                DefaultNutsTextTitle s = (DefaultNutsTextTitle)node;
                if (!ctx.isFiltered()) {
                    this.writeRaw(s.getStart());
                }
                if (ctx.isTitleNumberEnabled()) {
                    NutsTextNumbering seq = ctx.getTitleNumberSequence();
                    if (seq == null) {
                        seq = this.ws.text().forNumbering();
                        ctx.setTitleNumberSequence(seq);
                    }
                    NutsTextNumbering a = seq.newLevel(s.getTextStyleCode().length());
                    String ts = a.toString() + " ";
                    this.writeRaw(ts);
                }
                this.writeNode(s.getChild(), ctx);
                break;
            }
            case COMMAND: {
                DefaultNutsTextCommand s = (DefaultNutsTextCommand)node;
                if (ctx.isFiltered()) break;
                this.writeRaw(s.getStart());
                this.writeEscapedSpecial(s.getCommand().getName());
                if (!NutsUtilStrings.isBlank((CharSequence)s.getCommand().getArgs())) {
                    this.writeEscapedSpecial(" ");
                    this.writeEscapedSpecial(s.getCommand().getArgs());
                }
                this.writeRaw(s.getEnd());
                this.writeRaw('\u001e');
                break;
            }
            case ANCHOR: {
                DefaultNutsTextAnchor s = (DefaultNutsTextAnchor)node;
                if (ctx.isFiltered()) break;
                this.writeRaw(s.getStart());
                this.writeRaw(s.getKind());
                this.writeRaw(s.getSeparator());
                this.writeEscapedSpecial(s.getValue());
                this.writeRaw(s.getEnd());
                this.writeRaw('\u001e');
                break;
            }
            case LINK: {
                DefaultNutsTextLink s = (DefaultNutsTextLink)node;
                if (!ctx.isFiltered()) {
                    this.writeRaw(s.getStart());
                    this.writeRaw(s.getKind());
                    this.writeRaw(s.getSeparator());
                    this.writeNode(s.getChild());
                    this.writeRaw(s.getEnd());
                    this.writeRaw('\u001e');
                    break;
                }
                this.writeNode(s.getChild());
                break;
            }
            case CODE: {
                DefaultNutsTextCode s = (DefaultNutsTextCode)node;
                if (!ctx.isFiltered()) {
                    this.writeRaw(s.getStart());
                    this.writeRaw(s.getKind());
                    this.writeRaw(s.getSeparator());
                    this.writeEscapedSpecial(s.getText());
                    this.writeRaw(s.getEnd());
                    this.writeRaw('\u001e');
                    break;
                }
                this.writeRaw(s.getText());
                break;
            }
            default: {
                throw new UnsupportedOperationException("invalid node type : " + node.getClass().getSimpleName());
            }
        }
    }

    public final void writeEscapedSpecial(String rawString) {
        char[] cc = rawString.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cc.length; ++i) {
            if (cc[i] == '\\' || i < cc.length - 3 && cc[i] == '`' && cc[i + 1] == '`' && cc[i + 2] == '`') {
                sb.append('\\');
            }
            sb.append(cc[i]);
        }
        this.writeRaw(sb.toString());
    }

    public final void writeEscaped(String rawString) {
        char[] cc = rawString.toCharArray();
        StringBuilder sb = new StringBuilder();
        block5: for (int i = 0; i < cc.length; ++i) {
            switch (cc[i]) {
                case '\u001e': 
                case '\\': {
                    sb.append('\\');
                    sb.append(cc[i]);
                    continue block5;
                }
                case '`': {
                    if (i < cc.length - 3) {
                        if (cc[i] == '`' && cc[i + 1] == '`' && cc[i + 2] == '`') {
                            sb.append('\\');
                            sb.append(cc[i]);
                            continue block5;
                        }
                        sb.append(cc[i]);
                        continue block5;
                    }
                    if (i < cc.length - 1) {
                        if (cc[i] == '`' && cc[i + 1] == '`') {
                            sb.append('\\');
                            sb.append(cc[i]);
                            continue block5;
                        }
                        sb.append(cc[i]);
                        continue block5;
                    }
                    sb.append('\\');
                    sb.append(cc[i]);
                    continue block5;
                }
                case '#': {
                    if (i < cc.length - 1 && cc[i + 1] != cc[i]) {
                        sb.append(cc[i]);
                        continue block5;
                    }
                    sb.append('\\');
                    sb.append(cc[i]);
                    continue block5;
                }
                default: {
                    sb.append(cc[i]);
                }
            }
        }
        this.writeRaw(sb.toString());
    }

    public final void writeRaw(char rawChar) {
        this.writeRaw(String.valueOf(rawChar));
    }

    public final void writeRaw(String rawString) {
        try {
            this.out.write(rawString.getBytes());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private void writeStyledStart(NutsTextStyle style, boolean complex) {
        String h = complex ? "##{" : "##:";
        switch (style.getType()) {
            case FORE_COLOR: {
                this.writeRaw(h + "f" + style.getVariant() + ":");
                break;
            }
            case BACK_COLOR: {
                this.writeRaw(h + "b" + style.getVariant() + ":");
                break;
            }
            case FORE_TRUE_COLOR: {
                String s = Integer.toString(0, style.getVariant());
                while (s.length() < 8) {
                    s = "0" + s;
                }
                this.writeRaw(h + "fx" + s + ":");
                break;
            }
            case BACK_TRUE_COLOR: {
                String s = Integer.toString(0, style.getVariant());
                while (s.length() < 8) {
                    s = "0" + s;
                }
                this.writeRaw(h + "bx" + style.getVariant() + ":");
                break;
            }
            case UNDERLINED: {
                this.writeRaw(h + "_:");
                break;
            }
            case ITALIC: {
                this.writeRaw(h + "/:");
                break;
            }
            case STRIKED: {
                this.writeRaw(h + "-:");
                break;
            }
            case REVERSED: {
                this.writeRaw(h + "!:");
                break;
            }
            case BOLD: {
                this.writeRaw(h + "+:");
                break;
            }
            case BLINK: {
                this.writeRaw(h + "%:");
                break;
            }
            case PRIMARY: {
                this.writeRaw(h + "p" + style.getVariant() + ":");
                break;
            }
            case SECONDARY: {
                this.writeRaw(h + "s" + style.getVariant() + ":");
                break;
            }
            default: {
                if (style.getVariant() == 0) {
                    this.writeRaw(h + style.getType().toString().toLowerCase() + ":");
                    break;
                }
                this.writeRaw(h + style.getType().toString().toLowerCase() + style.getVariant() + ":");
            }
        }
    }
}

