/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.text;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextCode;
import net.thevpc.nuts.NutsTextLink;
import net.thevpc.nuts.NutsTextList;
import net.thevpc.nuts.NutsTextNumbering;
import net.thevpc.nuts.NutsTextPlain;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyles;
import net.thevpc.nuts.NutsTextWriteConfiguration;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.format.text.AbstractNutsTextNodeWriter;
import net.thevpc.nuts.runtime.core.format.text.AnsiEscapeCommand;
import net.thevpc.nuts.runtime.core.format.text.AnsiEscapeCommandFromNodeStyle;
import net.thevpc.nuts.runtime.core.format.text.AnsiEscapeCommandList;
import net.thevpc.nuts.runtime.core.format.text.AnsiEscapeCommands;
import net.thevpc.nuts.runtime.core.format.text.DefaultNutsTextManager;
import net.thevpc.nuts.runtime.core.format.text.FormattedPrintStreamRenderer;
import net.thevpc.nuts.runtime.core.format.text.RenderedRawStream;
import net.thevpc.nuts.runtime.core.format.text.parser.DefaultNutsTextCommand;
import net.thevpc.nuts.runtime.core.format.text.parser.DefaultNutsTextStyled;
import net.thevpc.nuts.runtime.core.format.text.parser.DefaultNutsTextTitle;
import net.thevpc.nuts.runtime.core.format.text.renderer.AnsiUnixTermPrintRenderer;
import net.thevpc.nuts.runtime.core.format.text.renderer.StyleRenderer;
import net.thevpc.nuts.runtime.standalone.io.NutsPrintStreamHelper;
import net.thevpc.nuts.runtime.standalone.io.OutputHelper;
import net.thevpc.nuts.runtime.standalone.io.OutputStreamHelper;

public class NutsTextNodeWriterRenderer
extends AbstractNutsTextNodeWriter {
    private byte[] buffer = new byte[1024];
    private int bufferSize = 0;
    private boolean enableBuffering = false;
    private byte[] later = null;
    private FormattedPrintStreamRenderer renderer;
    private OutputHelper rawOutput;
    private RenderedRawStream renderedRawStream = new RenderedRawStream(){

        @Override
        public OutputHelper baseOutput() {
            return NutsTextNodeWriterRenderer.this.rawOutput;
        }

        @Override
        public void writeRaw(byte[] buf, int off, int len) {
            NutsTextNodeWriterRenderer.this.writeRaw(new String(buf, off, len));
        }

        @Override
        public void writeLater(byte[] buf) {
            NutsTextNodeWriterRenderer.this.writeLater(buf);
        }
    };
    private NutsSession session;
    private NutsWorkspace ws;

    public NutsTextNodeWriterRenderer(NutsPrintStream rawOutput, FormattedPrintStreamRenderer renderer, NutsSession session) {
        this(new NutsPrintStreamHelper(rawOutput), renderer, session);
    }

    public NutsTextNodeWriterRenderer(OutputStream rawOutput, FormattedPrintStreamRenderer renderer, NutsSession session) {
        this(new OutputStreamHelper(rawOutput, session), renderer, session);
    }

    public NutsTextNodeWriterRenderer(OutputHelper rawOutput, FormattedPrintStreamRenderer renderer, NutsSession session) {
        this.renderer = renderer == null ? AnsiUnixTermPrintRenderer.ANSI_RENDERER : renderer;
        this.rawOutput = rawOutput;
        this.session = session;
        this.ws = session.getWorkspace();
    }

    @Override
    public void writeNode(NutsText node) {
        this.writeNode(node, this.getWriteConfiguration());
    }

    @Override
    public final void writeRaw(byte[] buf, int off, int len) {
        this.rawOutput.write(buf, off, len);
    }

    @Override
    public void writeRaw(char[] buf, int off, int len) {
        this.writeRaw(new String(this.buffer, off, len));
    }

    @Override
    public final boolean flush() {
        if (this.bufferSize > 0) {
            this.rawOutput.write(this.buffer, 0, this.bufferSize);
            this.bufferSize = 0;
            return true;
        }
        this.rawOutput.flush();
        return false;
    }

    public void writeNode(NutsText node, NutsTextWriteConfiguration ctx) {
        this.writeNode(new AnsiEscapeCommand[0], node, ctx);
    }

    private void writeNode(AnsiEscapeCommand[] formats, NutsText node, NutsTextWriteConfiguration ctx) {
        if (formats == null) {
            formats = new AnsiEscapeCommand[]{};
        }
        switch (node.getType()) {
            case PLAIN: {
                NutsTextPlain p = (NutsTextPlain)node;
                this.writeRaw(AnsiEscapeCommands.list(formats), p.getText(), ctx.isFiltered());
                break;
            }
            case LIST: {
                NutsTextList s = (NutsTextList)node;
                for (NutsText n : s) {
                    this.writeNode(formats, n, ctx);
                }
                break;
            }
            case STYLED: {
                DefaultNutsTextStyled s = (DefaultNutsTextStyled)node;
                NutsTextStyles styles = s.getStyles();
                NutsTextStyles format = this.ws.text().getTheme().toBasicStyles(styles, this.session);
                AnsiEscapeCommand[] s2 = this._appendFormats(formats, format);
                this.writeNode(s2, s.getChild(), ctx);
                break;
            }
            case TITLE: {
                DefaultNutsTextTitle s = (DefaultNutsTextTitle)node;
                DefaultNutsTextManager factory0 = (DefaultNutsTextManager)this.ws.text();
                AnsiEscapeCommand[] s2 = this._appendFormats(formats, this.ws.text().getTheme().toBasicStyles(NutsTextStyles.of((NutsTextStyle)NutsTextStyle.title((int)s.getLevel())), this.session));
                if (ctx.isTitleNumberEnabled()) {
                    NutsTextNumbering seq = ctx.getTitleNumberSequence();
                    if (seq == null) {
                        seq = this.ws.text().forNumbering();
                        ctx.setTitleNumberSequence(seq);
                    }
                    NutsTextNumbering a = seq.newLevel(s.getLevel());
                    NutsTextList sWithTitle = factory0.forList(new NutsText[]{this.ws.text().forPlain(a.toString() + " "), s.getChild()});
                    this.writeNode(s2, (NutsText)sWithTitle, ctx);
                    break;
                }
                this.writeNode(s2, s.getChild(), ctx);
                break;
            }
            case COMMAND: {
                DefaultNutsTextCommand s = (DefaultNutsTextCommand)node;
                AnsiEscapeCommand yy = DefaultNutsTextCommand.parseAnsiEscapeCommand(s.getCommand(), this.ws);
                AnsiEscapeCommand[] s2 = this._appendFormats(formats, yy);
                this.writeRaw(AnsiEscapeCommands.list(s2), "", ctx.isFiltered());
                break;
            }
            case ANCHOR: {
                break;
            }
            case LINK: {
                DefaultNutsTextManager factory0 = (DefaultNutsTextManager)this.ws.text();
                this.writeNode(formats, (NutsText)factory0.createStyled(((NutsTextLink)node).getChild(), NutsTextStyles.of((NutsTextStyle)NutsTextStyle.underlined()), true), ctx);
                this.writeRaw(AnsiEscapeCommands.list(formats), "see: " + ((NutsTextLink)node).getChild(), ctx.isFiltered());
                break;
            }
            case CODE: {
                NutsTextCode node1 = (NutsTextCode)node;
                NutsText cn = node1.parse(this.session);
                this.writeNode(formats, cn, ctx);
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported NutsTextNode type " + node.getClass().getSimpleName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeRaw(AnsiEscapeCommand format, String rawString, boolean filterFormat) {
        if (!filterFormat && format != null) {
            StyleRenderer f = null;
            f = this.renderer.createStyleRenderer(this.simplifyFormat(format), this.renderedRawStream, this.session);
            try {
                f.startFormat(this.renderedRawStream);
                if (rawString.length() <= 0) return;
                this.writeRaw(rawString);
                return;
            }
            finally {
                f.endFormat(this.renderedRawStream);
            }
        } else {
            if (rawString.length() <= 0) return;
            this.writeRaw(rawString);
        }
    }

    public final void writeRaw(String rawString) {
        this.flushLater();
        byte[] b = rawString.getBytes();
        if (this.enableBuffering) {
            if (b.length + this.bufferSize < this.buffer.length) {
                System.arraycopy(b, 0, this.buffer, this.bufferSize, b.length);
                this.bufferSize += b.length;
            } else {
                this.flush();
                if (b.length >= this.buffer.length) {
                    this.rawOutput.write(b, 0, b.length);
                } else {
                    System.arraycopy(b, 0, this.buffer, this.bufferSize, b.length);
                    this.bufferSize += b.length;
                }
            }
        } else {
            this.rawOutput.write(b, 0, b.length);
        }
    }

    protected AnsiEscapeCommand simplifyFormat(AnsiEscapeCommand f) {
        if (f instanceof AnsiEscapeCommandList) {
            AnsiEscapeCommand[] o = ((AnsiEscapeCommandList)f).getChildren();
            ArrayList<AnsiEscapeCommand> ok = new ArrayList<AnsiEscapeCommand>();
            if (o != null) {
                for (AnsiEscapeCommand v : o) {
                    if (v == null || (v = this.simplifyFormat(v)) == null) continue;
                    ok.add(v);
                }
            }
            if (ok.isEmpty()) {
                return null;
            }
            if (ok.size() == 1) {
                return this.simplifyFormat((AnsiEscapeCommand)ok.get(0));
            }
            return AnsiEscapeCommands.list(ok.toArray(new AnsiEscapeCommand[0]));
        }
        return f;
    }

    private AnsiEscapeCommand[] _appendFormats(AnsiEscapeCommand[] old, AnsiEscapeCommand v) {
        ArrayList<AnsiEscapeCommand> list = new ArrayList<AnsiEscapeCommand>((old == null ? 0 : old.length) + 1);
        if (old != null) {
            list.addAll(Arrays.asList(old));
        }
        list.add(v);
        return list.toArray(new AnsiEscapeCommand[0]);
    }

    private AnsiEscapeCommand[] _appendFormats(AnsiEscapeCommand[] old, AnsiEscapeCommand ... v) {
        ArrayList<AnsiEscapeCommand> list = new ArrayList<AnsiEscapeCommand>((old == null ? 0 : old.length) + 1);
        if (old != null) {
            list.addAll(Arrays.asList(old));
        }
        for (AnsiEscapeCommand ansiEscapeCommand : v) {
            if (ansiEscapeCommand == null) continue;
            list.add(ansiEscapeCommand);
        }
        return list.toArray(new AnsiEscapeCommand[0]);
    }

    private AnsiEscapeCommand[] _appendFormats(AnsiEscapeCommand[] old, NutsTextStyles v) {
        ArrayList<AnsiEscapeCommand> list = new ArrayList<AnsiEscapeCommand>((old == null ? 0 : old.length) + 1);
        if (old != null) {
            list.addAll(Arrays.asList(old));
        }
        for (NutsTextStyle textFormat : v) {
            if (textFormat == null) continue;
            list.add(AnsiEscapeCommandFromNodeStyle.of(textFormat));
        }
        return list.toArray(new AnsiEscapeCommand[0]);
    }

    public final void writeLater(byte[] later) {
        this.later = later;
        this.rawOutput.flush();
    }

    public final void flushLater() {
        byte[] b = this.later;
        if (b != null) {
            this.later = null;
            if (this.enableBuffering) {
                if (b.length + this.bufferSize < this.buffer.length) {
                    System.arraycopy(b, 0, this.buffer, this.bufferSize, b.length);
                    this.bufferSize += b.length;
                } else {
                    this.flush();
                    if (b.length >= this.buffer.length) {
                        this.rawOutput.write(b, 0, b.length);
                    } else {
                        System.arraycopy(b, 0, this.buffer, this.bufferSize, b.length);
                        this.bufferSize += b.length;
                    }
                }
            } else {
                this.rawOutput.write(b, 0, b.length);
                this.rawOutput.flush();
            }
        }
    }

    public String toString() {
        return "Printer(" + this.rawOutput + (this.later != null ? ";withLater" : "") + ")";
    }
}

