/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.text;

import java.io.Reader;
import java.io.StringReader;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsWorkspace;

public class NutsImmutableString
implements NutsString {
    private final String value;
    private final NutsWorkspace ws;

    public NutsImmutableString(NutsWorkspace ws, String value) {
        this.ws = ws;
        this.value = value == null ? "" : value;
    }

    public int textLength() {
        return this.filteredText().length();
    }

    public String filteredText() {
        return this.ws.text().parser().filterText(this.value);
    }

    public NutsText toText() {
        return this.ws.text().parser().parse((Reader)new StringReader(this.value));
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NutsImmutableString that = (NutsImmutableString)o;
        return this.value.equals(that.value);
    }

    public String toString() {
        return this.value;
    }

    public NutsImmutableString immutable() {
        return this;
    }

    public boolean isEmpty() {
        return this.textLength() == 0;
    }
}

