/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.text;

import java.io.OutputStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.core.format.text.EscapeOutputStream;
import net.thevpc.nuts.runtime.core.format.text.ExtendedFormatAware;
import net.thevpc.nuts.runtime.core.format.text.FPrint;
import net.thevpc.nuts.runtime.core.format.text.FilterFormatOutputStream;
import net.thevpc.nuts.runtime.core.format.text.RawOutputStream;
import net.thevpc.nuts.runtime.core.format.text.RenderedOutputStream;
import net.thevpc.nuts.runtime.core.format.text.UnescapeOutputStream;
import net.thevpc.nuts.runtime.core.terminals.NutsTerminalModeOp;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;

public class FormatOutputStream
extends RenderedOutputStream
implements ExtendedFormatAware {
    public FormatOutputStream(OutputStream out, NutsSession session) {
        super(out, FPrint.RENDERER_ANSI, session);
        NutsTerminalModeOp op = CoreIOUtils.resolveNutsTerminalModeOp(out);
        if (op != NutsTerminalModeOp.NOP) {
            throw new IllegalArgumentException("Expected Raw");
        }
    }

    @Override
    public NutsTerminalModeOp getModeOp() {
        return NutsTerminalModeOp.FORMAT;
    }

    @Override
    public ExtendedFormatAware convert(NutsTerminalModeOp other) {
        if (other == null || other == this.getModeOp()) {
            return this;
        }
        switch (other) {
            case NOP: {
                if (this.out instanceof ExtendedFormatAware) {
                    return (ExtendedFormatAware)((Object)this.out);
                }
                return new RawOutputStream(this.out, this.session);
            }
            case FORMAT: {
                return this;
            }
            case FILTER: {
                return new FilterFormatOutputStream(this.out, this.session);
            }
            case ESCAPE: {
                return new EscapeOutputStream(this, this.session);
            }
            case UNESCAPE: {
                return new UnescapeOutputStream(this, this.session);
            }
        }
        throw new IllegalArgumentException("Unsupported");
    }
}

