/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.text;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSessionAware;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.format.text.EscapeOutputStream;
import net.thevpc.nuts.runtime.core.format.text.ExtendedFormatAware;
import net.thevpc.nuts.runtime.core.format.text.FilterFormatOutputStream;
import net.thevpc.nuts.runtime.core.format.text.FormatOutputStream;
import net.thevpc.nuts.runtime.core.format.text.SimpleWriterOutputStream;
import net.thevpc.nuts.runtime.core.terminals.NutsTerminalModeOp;

public class ExtendedFormatAwarePrintWriter
extends PrintWriter
implements ExtendedFormatAware,
NutsSessionAware {
    private NutsWorkspace ws;
    private NutsSession session;
    private Object base = null;

    public ExtendedFormatAwarePrintWriter(Writer out) {
        super(out);
        this.base = out;
    }

    public ExtendedFormatAwarePrintWriter(Writer out, boolean autoFlush) {
        super(out, autoFlush);
        this.base = out;
    }

    public ExtendedFormatAwarePrintWriter(OutputStream out) {
        super(out);
        this.base = out;
    }

    public ExtendedFormatAwarePrintWriter(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
        this.base = out;
    }

    public void setSession(NutsSession session) {
        this.session = session;
        this.ws = session == null ? null : session.getWorkspace();
    }

    @Override
    public NutsTerminalModeOp getModeOp() {
        if (this.base instanceof ExtendedFormatAware) {
            return ((ExtendedFormatAware)this.base).getModeOp();
        }
        return NutsTerminalModeOp.NOP;
    }

    @Override
    public ExtendedFormatAware convert(NutsTerminalModeOp other) {
        if (other == null || other == this.getModeOp()) {
            return this;
        }
        if (this.base instanceof ExtendedFormatAware) {
            return ((ExtendedFormatAware)this.base).convert(other);
        }
        switch (other) {
            case NOP: {
                return this;
            }
            case FORMAT: {
                return new FormatOutputStream(new SimpleWriterOutputStream(this, this.session), this.session);
            }
            case FILTER: {
                return new FilterFormatOutputStream(new SimpleWriterOutputStream(this, this.session), this.session);
            }
            case ESCAPE: {
                return new EscapeOutputStream(new SimpleWriterOutputStream(this, this.session), this.session);
            }
            case UNESCAPE: {
                return new EscapeOutputStream(new SimpleWriterOutputStream(this, this.session), this.session);
            }
        }
        throw new IllegalArgumentException("Unsupported");
    }

    @Override
    public void flush() {
        super.flush();
    }

    @Override
    public PrintWriter format(String format, Object ... args) {
        return this.format(null, format, args);
    }

    @Override
    public ExtendedFormatAwarePrintWriter format(Locale l, String format, Object ... args) {
        if (l == null) {
            this.print(this.session.getWorkspace().text().setSession(this.session).toText((Object)NutsMessage.cstyle((String)format, (Object[])args)));
        } else {
            NutsSession s2 = this.session.copy().setLocale(l.toString());
            this.print(s2.getWorkspace().text().setSession(s2).toText((Object)NutsMessage.cstyle((String)format, (Object[])args)));
        }
        return this;
    }
}

