/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.text;

import java.io.IOException;
import java.io.OutputStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.format.text.ExtendedFormatAware;
import net.thevpc.nuts.runtime.core.format.text.FormatOutputStream;
import net.thevpc.nuts.runtime.core.format.text.RawOutputStream;
import net.thevpc.nuts.runtime.core.format.text.parser.DefaultNutsTextNodeParser;
import net.thevpc.nuts.runtime.core.io.BaseTransparentFilterOutputStream;
import net.thevpc.nuts.runtime.core.terminals.NutsTerminalModeOp;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;

public class EscapeOutputStream
extends BaseTransparentFilterOutputStream
implements ExtendedFormatAware {
    NutsWorkspace ws;
    NutsSession session;

    public EscapeOutputStream(OutputStream out, NutsSession session) {
        super(out);
        this.session = session;
        this.ws = session.getWorkspace();
        NutsTerminalModeOp t = CoreIOUtils.resolveNutsTerminalModeOp(out);
        if (t.in() != NutsTerminalMode.FORMATTED && t.in() != NutsTerminalMode.FILTERED) {
            throw new IllegalArgumentException("Illegal Formatted");
        }
    }

    public OutputStream getOut() {
        return this.out;
    }

    @Override
    public NutsTerminalModeOp getModeOp() {
        return NutsTerminalModeOp.ESCAPE;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(DefaultNutsTextNodeParser.escapeText0(Character.toString((char)b)).getBytes());
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        byte[] bytes = DefaultNutsTextNodeParser.escapeText0(new String(b, off, len)).getBytes();
        this.out.write(bytes, 0, bytes.length);
    }

    @Override
    public ExtendedFormatAware convert(NutsTerminalModeOp other) {
        if (other == null || other == this.getModeOp()) {
            return this;
        }
        switch (other) {
            case NOP: {
                if (this.out instanceof ExtendedFormatAware) {
                    return ((ExtendedFormatAware)((Object)this.out)).convert(NutsTerminalModeOp.NOP);
                }
                return new RawOutputStream(this.out, this.session);
            }
            case FORMAT: {
                if (this.out instanceof ExtendedFormatAware) {
                    return ((ExtendedFormatAware)((Object)this.out)).convert(NutsTerminalModeOp.FORMAT);
                }
                return new FormatOutputStream(this.out, this.session);
            }
            case FILTER: {
                if (this.out instanceof ExtendedFormatAware) {
                    return ((ExtendedFormatAware)((Object)this.out)).convert(NutsTerminalModeOp.FILTER);
                }
                return this;
            }
            case ESCAPE: {
                return this;
            }
            case UNESCAPE: {
                return (ExtendedFormatAware)((Object)this.out);
            }
        }
        throw new IllegalArgumentException("Unsupported");
    }
}

