/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.text;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTerminalCommand;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsTextParser;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyleGenerator;
import net.thevpc.nuts.NutsTextStyles;
import net.thevpc.nuts.NutsTextWriteConfiguration;
import net.thevpc.nuts.runtime.core.format.text.NutsImmutableString;
import net.thevpc.nuts.runtime.core.format.text.NutsTextNodeWriterStringer;
import net.thevpc.nuts.runtime.core.format.text.parser.DefaultNutsTextNodeParser;
import net.thevpc.nuts.runtime.standalone.DefaultNutsTextStyleGenerator;

public class DefaultNutsTextNodeBuilder
implements NutsTextBuilder {
    NutsTextManager text1;
    private List<NutsText> all = new ArrayList<NutsText>();
    private NutsSession session;
    private NutsTextWriteConfiguration writeConfiguration;
    private NutsTextStyleGenerator styleGenerator;

    public DefaultNutsTextNodeBuilder(NutsSession session) {
        this.session = session;
        this.text1 = session.getWorkspace().text();
    }

    public NutsTextStyleGenerator getStyleGenerator() {
        if (this.styleGenerator == null) {
            this.styleGenerator = new DefaultNutsTextStyleGenerator();
        }
        return this.styleGenerator;
    }

    public DefaultNutsTextNodeBuilder setStyleGenerator(NutsTextStyleGenerator styleGenerator) {
        this.styleGenerator = styleGenerator;
        return this;
    }

    public NutsTextWriteConfiguration getConfiguration() {
        return this.writeConfiguration;
    }

    public NutsTextBuilder setConfiguration(NutsTextWriteConfiguration writeConfiguration) {
        this.writeConfiguration = writeConfiguration;
        return this;
    }

    public NutsTextBuilder appendCommand(NutsTerminalCommand command) {
        this.all.add((NutsText)this.text1.forCommand(command));
        return this;
    }

    public NutsTextBuilder appendCode(String lang, String text) {
        this.all.add((NutsText)this.text1.forCode(lang, text));
        return this;
    }

    public NutsTextBuilder appendHash(Object text) {
        return this.appendHash(text, text);
    }

    public NutsTextBuilder appendHash(Object text, Object hash) {
        if (text == null) {
            return this;
        }
        if (hash == null) {
            hash = text;
        }
        return this.append(text, this.getStyleGenerator().hash(hash));
    }

    public NutsTextBuilder appendRandom(Object text) {
        if (text == null) {
            return this;
        }
        return this.append(text, this.getStyleGenerator().random());
    }

    public NutsTextBuilder append(Object text, NutsTextStyle style) {
        return this.append(text, NutsTextStyles.of((NutsTextStyle)style));
    }

    public NutsTextBuilder append(Object text, NutsTextStyles styles) {
        if (text != null) {
            if (styles.size() == 0) {
                this.all.add(this.session.getWorkspace().text().toText(text));
            } else {
                this.all.add((NutsText)this.text1.forStyled(this.session.getWorkspace().text().toText(text), styles));
            }
        }
        return this;
    }

    public NutsTextBuilder append(Object node) {
        if (node != null) {
            return this.append(this.session.getWorkspace().text().toText(node));
        }
        return this;
    }

    public NutsTextBuilder append(NutsText node) {
        if (node != null) {
            this.all.add(node);
        }
        return this;
    }

    public NutsTextBuilder appendAll(Collection<?> others) {
        if (others != null) {
            for (Object node : others) {
                if (node == null) continue;
                this.append(node);
            }
        }
        return this;
    }

    public NutsTextBuilder appendJoined(Object separator, Collection<?> others) {
        if (others != null) {
            boolean first = true;
            for (Object other : others) {
                if (other == null) continue;
                if (first) {
                    first = false;
                } else if (separator != null) {
                    this.append(separator);
                }
                this.append(other);
            }
        }
        return this;
    }

    public NutsText build() {
        if (this.all.size() == 0) {
            return this.text1.forPlain("");
        }
        if (this.all.size() == 1) {
            return this.all.get(0);
        }
        return this.text1.forList(this.all).simplify();
    }

    public int size() {
        return this.all.size();
    }

    public NutsTextParser parser() {
        return new DefaultNutsTextNodeParser(this.session);
    }

    public NutsString immutable() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        NutsTextNodeWriterStringer ss = new NutsTextNodeWriterStringer(out, this.session.getWorkspace());
        ss.writeNode(this.build(), this.getConfiguration());
        return new NutsImmutableString(this.session.getWorkspace(), out.toString());
    }

    public String toString() {
        return this.immutable().toString();
    }

    public String filteredText() {
        return this.immutable().filteredText();
    }

    public int textLength() {
        return this.immutable().textLength();
    }

    public NutsText toText() {
        return this.build();
    }

    public boolean isEmpty() {
        return this.immutable().isEmpty();
    }
}

