/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.text;

import java.util.Objects;
import java.util.function.Supplier;
import net.thevpc.nuts.NutsExecutionType;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTerminalCommand;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.format.text.AnsiEscapeCommand;
import net.thevpc.nuts.runtime.core.format.text.RenderedRawStream;
import net.thevpc.nuts.runtime.core.format.text.renderer.AnsiStyleStyleApplierResolver;
import net.thevpc.nuts.runtime.core.format.text.renderer.ansi.AnsiStyle;
import net.thevpc.nuts.runtime.core.format.text.renderer.ansi.AnsiStyleStyleApplier;
import net.thevpc.nuts.runtime.core.util.CachedValue;
import net.thevpc.nuts.runtime.core.util.CoreNumberUtils;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.io.NutsPrintStreamHelper;

public class DefaultAnsiEscapeCommand
extends AnsiEscapeCommand
implements AnsiStyleStyleApplier {
    private final NutsTerminalCommand command;

    public DefaultAnsiEscapeCommand(NutsTerminalCommand command) {
        this.command = command;
    }

    public String getName() {
        return this.command.getName();
    }

    public String toString() {
        return this.getName() + "(" + this.command.getArgs() + ')';
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + Objects.hashCode(this.command);
        return hash;
    }

    @Override
    public AnsiStyle apply(AnsiStyle old, RenderedRawStream out, NutsSession session, AnsiStyleStyleApplierResolver applierResolver) {
        switch (this.command.getName()) {
            case "move-line-start": {
                return old.addCommand("\r");
            }
            case "move-to": {
                String[] split;
                String a = this.command.getArgs();
                if (a != null && (split = a.split("[;v, x]")).length >= 2) {
                    Integer count1 = CoreNumberUtils.convertToInteger(split[0], null);
                    Integer count2 = CoreNumberUtils.convertToInteger(split[1], null);
                    if (count1 != null && count2 != null) {
                        return old.addCommand("\u001b[" + count1 + ";" + count2 + "H");
                    }
                }
                return old;
            }
            case "move-up": {
                Integer count1 = CoreNumberUtils.convertToInteger(this.command.getArgs(), null);
                if (count1 != null) {
                    return old.addCommand("\u001b[" + count1 + "A");
                }
                return old;
            }
            case "move-down": {
                Integer count1 = CoreNumberUtils.convertToInteger(this.command.getArgs(), null);
                if (count1 != null) {
                    return old.addCommand("\u001b[" + count1 + "B");
                }
                return old;
            }
            case "move-right": {
                Integer count1 = CoreNumberUtils.convertToInteger(this.command.getArgs(), null);
                if (count1 != null) {
                    return old.addCommand("\u001b[" + count1 + "C");
                }
                return old;
            }
            case "move-left": {
                Integer count1 = CoreNumberUtils.convertToInteger(this.command.getArgs(), null);
                if (count1 != null) {
                    return old.addCommand("\u001b[" + count1 + "D");
                }
                return old;
            }
            case "clear-screen": {
                return old.addCommand("\u001b[2J");
            }
            case "clear-screen-from-cursor": {
                return old.addCommand("\u001b[0J");
            }
            case "clear-screen-to-cursor": {
                return old.addCommand("\u001b[1J");
            }
            case "clear-line": {
                return old.addCommand("\u001b[2K");
            }
            case "clear-line-from-cursor": {
                return old.addCommand("\u001b[0K");
            }
            case "clear-line-to-cursor": {
                return old.addCommand("\u001b[1K");
            }
            case "later-reset-line": {
                NutsWorkspace ws = session.getWorkspace();
                int tputCallTimeout = ws.env().getOptionAsInt("nuts.term.tput.call.timeout", Integer.valueOf(60));
                Integer w = ws.env().getOptionAsInt("nuts.term.width", null);
                if (w == null) {
                    CachedValue<Integer> tput_cols = (CachedValue<Integer>)ws.env().getProperty("nuts.term.tput.call.instance");
                    if (tput_cols == null) {
                        tput_cols = new CachedValue<Integer>(new TputEvaluator(session), tputCallTimeout);
                        ws.env().setProperty("nuts.term.tput.call.instance", tput_cols);
                    }
                    if (out.baseOutput() instanceof NutsPrintStreamHelper) {
                        w = ((NutsPrintStreamHelper)out.baseOutput()).out().getColumns();
                        w = tput_cols.getValue();
                    }
                }
                if (w == null) {
                    w = 120;
                }
                if (w > 0) {
                    return old.addLaterCommand("\r" + CoreStringUtils.fillString(' ', (int)w) + "\r");
                }
                return old;
            }
        }
        return old;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultAnsiEscapeCommand other = (DefaultAnsiEscapeCommand)obj;
        return Objects.equals(this.command, other.command);
    }

    public static class TputEvaluator
    implements Supplier<Integer> {
        private final NutsSession session;
        boolean wasError = false;

        public TputEvaluator(NutsSession session) {
            this.session = session;
        }

        @Override
        public Integer get() {
            NutsWorkspace ws = this.session.getWorkspace();
            switch (ws.env().getOsFamily()) {
                case LINUX: 
                case UNIX: 
                case MACOS: {
                    try {
                        String d = ws.exec().setExecutionType(NutsExecutionType.SYSTEM).grabOutputString().setSession(this.session).addCommand(new String[]{"tput", "cols"}).getOutputString();
                        String s = d.trim();
                        if (d.isEmpty()) {
                            return null;
                        }
                        return Integer.parseInt(d.trim());
                    }
                    catch (Exception ex) {
                        this.wasError = true;
                        return null;
                    }
                }
            }
            return null;
        }
    }
}

