/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.text;

import java.util.Objects;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.runtime.core.format.text.AnsiEscapeCommand;
import net.thevpc.nuts.runtime.core.format.text.RenderedRawStream;
import net.thevpc.nuts.runtime.core.format.text.renderer.AnsiStyleStyleApplierResolver;
import net.thevpc.nuts.runtime.core.format.text.renderer.ansi.AnsiStyle;
import net.thevpc.nuts.runtime.core.format.text.renderer.ansi.AnsiStyleStyleApplier;

public class AnsiEscapeCommandFromNodeStyle
extends AnsiEscapeCommand
implements AnsiStyleStyleApplier {
    private NutsTextStyle style;

    public static AnsiEscapeCommandFromNodeStyle of(NutsTextStyle s) {
        if (s.getType().basic()) {
            return new AnsiEscapeCommandFromNodeStyle(s);
        }
        throw new IllegalArgumentException("Unsupported");
    }

    public AnsiEscapeCommandFromNodeStyle(NutsTextStyle style) {
        this.style = style;
    }

    public String toString() {
        return this.style.toString();
    }

    public NutsTextStyle getStyle() {
        return this.style;
    }

    public int hashCode() {
        int hash = 3;
        hash = 41 * hash + this.style.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnsiEscapeCommandFromNodeStyle other = (AnsiEscapeCommandFromNodeStyle)obj;
        return Objects.equals(this.style, other.style);
    }

    @Override
    public AnsiStyle apply(AnsiStyle old, RenderedRawStream out, NutsSession ws, AnsiStyleStyleApplierResolver applierResolver) {
        switch (this.style.getType()) {
            case PRIMARY: {
                int variant = this.style.getVariant();
                if (variant <= 1) {
                    variant = 1;
                } else if (variant > 255) {
                    variant = 255;
                }
                return old.setForeground("" + variant).setIntensity(0);
            }
            case SECONDARY: {
                int variant = this.style.getVariant();
                if (variant <= 1) {
                    variant = 1;
                } else if (variant > 255) {
                    variant = 255;
                }
                return old.setBackground("" + variant);
            }
            case ITALIC: {
                return old.setItalic(true);
            }
            case BOLD: {
                return old.setBold(true);
            }
            case BLINK: {
                return old.setBlink(true);
            }
            case STRIKED: {
                return old.setStriked(true);
            }
            case REVERSED: {
                return old.setReversed(true);
            }
            case UNDERLINED: {
                return old.setUnderlined(true);
            }
            case FORE_COLOR: {
                return old.setForeground8(this.style.getVariant());
            }
            case BACK_COLOR: {
                return old.setBackground8(this.style.getVariant());
            }
            case FORE_TRUE_COLOR: {
                return old.setForeground24(this.style.getVariant());
            }
            case BACK_TRUE_COLOR: {
                return old.setBackground24(this.style.getVariant());
            }
        }
        return old;
    }
}

