/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.table;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementEntry;
import net.thevpc.nuts.NutsElementFormat;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsMutableTableModel;
import net.thevpc.nuts.NutsPositionType;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTableBordersFormat;
import net.thevpc.nuts.NutsTableCell;
import net.thevpc.nuts.NutsTableCellFormat;
import net.thevpc.nuts.NutsTableFormat;
import net.thevpc.nuts.NutsTableModel;
import net.thevpc.nuts.NutsTableSeparator;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsUnsupportedArgumentException;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.common.CorePlatformUtils;
import net.thevpc.nuts.runtime.bundles.string.StringBuilder2;
import net.thevpc.nuts.runtime.core.format.DefaultFormatBase;
import net.thevpc.nuts.runtime.core.format.table.DefaultNutsMutableTableModel;
import net.thevpc.nuts.runtime.core.format.table.DefaultTableCellFormat;
import net.thevpc.nuts.runtime.core.format.table.DefaultTableFormatBorders;
import net.thevpc.nuts.runtime.core.format.table.DefaultTableHeaderFormat;
import net.thevpc.nuts.runtime.core.format.tree.DefaultNutsFormatDestructTypePredicate;
import net.thevpc.nuts.runtime.core.util.CoreCommonUtils;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;

public class DefaultTableFormat
extends DefaultFormatBase<NutsTableFormat>
implements NutsTableFormat {
    public static NutsTableBordersFormat NO_BORDER = new DefaultTableFormatBorders("", "", "", "", "", "", "", "", "", "", "", "", "", "", "");
    public static NutsTableBordersFormat UNICODE_BORDER = new DefaultTableFormatBorders("\u256d", "\u2500", "\u252c", "\u256e", "\u2502", "\u2502", "\u2502", "\u251c", "\u2500", "\u253c", "\u2524", "\u2570", "\u2500", "\u2534", "\u256f");
    public static NutsTableBordersFormat SIMPLE_BORDER = new DefaultTableFormatBorders("-", "-", "-", "-", "|", " | ", "|", "|", "-", "+", "|", "-", "-", "-", "-");
    public static NutsTableBordersFormat FANCY_ROWS_BORDER = new DefaultTableFormatBorders("", "", "", "", "", " ", "", "", "\u2500", "\u2500", "", "", "", "", "");
    public static NutsTableBordersFormat SPACE_BORDER = new DefaultTableFormatBorders("", "", "", "", "", " ", "", "", "", "", "", "", "", "", "");
    public static NutsTableBordersFormat FANCY_COLUMNS_BORDER = new DefaultTableFormatBorders("", "", "", "", "", " \u2502 ", "", "", "", "", "", "", "", "", "");
    private NutsTableCellFormat defaultCellFormatter = DefaultTableCellFormat.INSTANCE;
    private NutsTableCellFormat defaultHeaderFormatter = DefaultTableHeaderFormat.INSTANCE;
    private NutsTableBordersFormat border = CorePlatformUtils.SUPPORTS_UTF_ENCODING ? UNICODE_BORDER : SIMPLE_BORDER;
    private Object model;
    private List<Boolean> visibleColumns = new ArrayList<Boolean>();
    private boolean visibleHeader = true;

    public DefaultTableFormat(NutsWorkspace ws) {
        super(ws, "table-format");
    }

    public static Set<String> getAvailableTableBorders() {
        return new HashSet<String>(Arrays.asList("default", "spaces", "simple", "columns", "rows", "none"));
    }

    public static NutsTableBordersFormat parseTableBorders(String borderName) {
        switch (borderName) {
            case "spaces": {
                return SPACE_BORDER;
            }
            case "default": {
                return CorePlatformUtils.SUPPORTS_UTF_ENCODING ? UNICODE_BORDER : SIMPLE_BORDER;
            }
            case "unicode": {
                return UNICODE_BORDER;
            }
            case "simple": {
                return SIMPLE_BORDER;
            }
            case "rows": {
                return FANCY_ROWS_BORDER;
            }
            case "columns": {
                return FANCY_COLUMNS_BORDER;
            }
            case "none": {
                return NO_BORDER;
            }
        }
        return null;
    }

    public static void formatAndHorizontalAlign(StringBuilder sb, NutsPositionType a, int columns, NutsTextManager tf, NutsSession session) {
        switch (a) {
            case FIRST: {
                int length;
                for (length = tf.setSession(session).parse(sb.toString()).textLength(); length < columns; ++length) {
                    sb.append(' ');
                }
                break;
            }
            case LAST: {
                int length;
                while (length < columns) {
                    sb.insert(0, ' ');
                    ++length;
                }
                break;
            }
            case CENTER: {
                int length;
                boolean after = true;
                while (length < columns) {
                    if (after) {
                        sb.append(' ');
                    } else {
                        sb.insert(0, ' ');
                    }
                    after = !after;
                    ++length;
                }
                break;
            }
            case HEADER: {
                int length;
                boolean after = true;
                int maxBefore = 10;
                while (length < columns) {
                    if (after || maxBefore <= 0) {
                        sb.append(' ');
                    } else {
                        sb.insert(0, ' ');
                        --maxBefore;
                    }
                    after = !after;
                    ++length;
                }
                break;
            }
            default: {
                throw new NutsUnsupportedArgumentException(session, NutsMessage.cstyle((String)"unsupported position type %s", (Object[])new Object[]{a}));
            }
        }
    }

    public boolean isVisibleHeader() {
        return this.visibleHeader;
    }

    public DefaultTableFormat setVisibleHeader(boolean visibleHeader) {
        this.visibleHeader = visibleHeader;
        return this;
    }

    public NutsTableBordersFormat getBorder() {
        return this.border;
    }

    public DefaultTableFormat setBorder(NutsTableBordersFormat border) {
        this.border = border;
        return this;
    }

    public DefaultTableFormat setVisibleColumn(int col, Boolean visible) {
        if (visible == null) {
            if (col >= 0 && col < this.visibleColumns.size()) {
                this.visibleColumns.set(col, null);
            }
        } else if (col >= 0) {
            while (col < this.visibleColumns.size()) {
                this.visibleColumns.add(null);
            }
            this.visibleColumns.set(col, visible);
        }
        return this;
    }

    public Boolean getVisibleColumn(int col) {
        if (col >= 0 && col < this.visibleColumns.size()) {
            return this.visibleColumns.get(col);
        }
        return null;
    }

    public NutsTableFormat setBorder(String borderName) {
        NutsTableBordersFormat n = DefaultTableFormat.parseTableBorders(borderName);
        if (n == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"unsupported border. use one of : %s", (Object[])new Object[]{DefaultTableFormat.getAvailableTableBorders()}));
        }
        this.setBorder(n);
        return this;
    }

    public NutsTableFormat setCellFormat(NutsTableCellFormat formatter) {
        this.defaultCellFormatter = formatter == null ? DefaultTableCellFormat.INSTANCE : formatter;
        return this;
    }

    public NutsTableModel getModel() {
        return this.createTableModel(this.model);
    }

    public NutsMutableTableModel createModel() {
        return new DefaultNutsMutableTableModel();
    }

    private String getSeparator(NutsTableSeparator id) {
        String s = this.border.format(id);
        if (s == null) {
            return "";
        }
        return s;
    }

    @Override
    public void print(NutsPrintStream w) {
        NutsPrintStream out = this.getValidPrintStream(w);
        StringBuilder2 line = new StringBuilder2();
        List<Row> rows = this.rebuild(this.getSession());
        if (rows.size() > 0) {
            String s;
            DefaultCell cell;
            int i;
            List<DefaultCell> cells = rows.get((int)0).cells;
            NutsWorkspace ws = this.getSession().getWorkspace();
            if ((this.getSeparator(NutsTableSeparator.FIRST_ROW_START) + this.getSeparator(NutsTableSeparator.FIRST_ROW_SEP) + this.getSeparator(NutsTableSeparator.FIRST_ROW_LINE) + this.getSeparator(NutsTableSeparator.FIRST_ROW_END)).length() > 0) {
                line.write(this.getSeparator(NutsTableSeparator.FIRST_ROW_START));
                for (i = 0; i < cells.size(); ++i) {
                    if (i > 0) {
                        line.write(this.getSeparator(NutsTableSeparator.FIRST_ROW_SEP));
                    }
                    cell = cells.get(i);
                    String B = this.getSeparator(NutsTableSeparator.FIRST_ROW_LINE);
                    s = cell.rendered.toString();
                    line.write(CoreStringUtils.fillString(B, ws.text().setSession(this.getSession()).parse(s).textLength()));
                }
                line.write(this.getSeparator(NutsTableSeparator.FIRST_ROW_END));
                out.print(line.trim().newLine().toString());
                out.flush();
                line.clear();
            }
            for (int i1 = 0; i1 < rows.size(); ++i1) {
                String s2;
                if (i1 > 0 && (this.getSeparator(NutsTableSeparator.MIDDLE_ROW_START) + this.getSeparator(NutsTableSeparator.MIDDLE_ROW_SEP) + this.getSeparator(NutsTableSeparator.MIDDLE_ROW_LINE) + this.getSeparator(NutsTableSeparator.MIDDLE_ROW_END)).length() > 0) {
                    line.write(this.getSeparator(NutsTableSeparator.MIDDLE_ROW_START));
                    for (int i2 = 0; i2 < cells.size(); ++i2) {
                        if (i2 > 0) {
                            line.write(this.getSeparator(NutsTableSeparator.MIDDLE_ROW_SEP));
                        }
                        DefaultCell cell2 = cells.get(i2);
                        String B = this.getSeparator(NutsTableSeparator.MIDDLE_ROW_LINE);
                        s2 = cell2.rendered.toString();
                        line.write(CoreStringUtils.fillString(B, ws.text().setSession(this.getSession()).parse(s2).textLength()));
                    }
                    line.write(this.getSeparator(NutsTableSeparator.MIDDLE_ROW_END));
                    out.print(line.trim().newLine().toString());
                    out.flush();
                    line.clear();
                }
                Row row = rows.get(i1);
                cells = row.cells;
                line.write(this.getSeparator(NutsTableSeparator.ROW_START));
                for (int i3 = 0; i3 < cells.size(); ++i3) {
                    if (i3 > 0) {
                        line.write(this.getSeparator(NutsTableSeparator.ROW_SEP));
                    }
                    DefaultCell cell3 = cells.get(i3);
                    s2 = cell3.rendered.toString();
                    line.write(s2);
                }
                line.write(this.getSeparator(NutsTableSeparator.ROW_END));
                out.print(line.trim().newLine().toString());
                out.flush();
                line.clear();
            }
            if ((this.getSeparator(NutsTableSeparator.LAST_ROW_START) + this.getSeparator(NutsTableSeparator.LAST_ROW_SEP) + this.getSeparator(NutsTableSeparator.LAST_ROW_LINE) + this.getSeparator(NutsTableSeparator.LAST_ROW_END)).length() > 0) {
                line.write(this.getSeparator(NutsTableSeparator.LAST_ROW_START));
                cells = rows.get((int)0).cells;
                for (i = 0; i < cells.size(); ++i) {
                    if (i > 0) {
                        line.write(this.getSeparator(NutsTableSeparator.LAST_ROW_SEP));
                    }
                    cell = cells.get(i);
                    String B = this.getSeparator(NutsTableSeparator.LAST_ROW_LINE);
                    s = cell.rendered.toString();
                    line.write(CoreStringUtils.fillString(B, ws.text().setSession(this.getSession()).parse(s).textLength()));
                }
                line.write(this.getSeparator(NutsTableSeparator.LAST_ROW_END));
            }
        }
        out.print(line.trim().toString());
        out.flush();
        line.clear();
    }

    @Override
    public String toString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter w = new OutputStreamWriter(out);
        this.print(w);
        try {
            w.flush();
        }
        catch (IOException ex) {
            throw new NutsIOException(this.getSession(), (Throwable)ex);
        }
        return new String(out.toByteArray());
    }

    private NutsTableCellFormat getTableCellFormat(DefaultCell dc) {
        return dc.isHeader() ? this.defaultHeaderFormatter : this.defaultCellFormatter;
    }

    private List<Row> rebuild(NutsSession session) {
        DefaultCell c;
        int columnIndex;
        ArrayList<Row> rows1 = new ArrayList<Row>();
        NutsTableModel model = this.getModel();
        int columnsCount = model.getColumnsCount();
        int rowsCount = model.getRowsCount();
        for (int rowIndex = 0; rowIndex < rowsCount; ++rowIndex) {
            Row r = new Row();
            rows1.add(r);
            for (columnIndex = 0; columnIndex < columnsCount; ++columnIndex) {
                c = new DefaultCell(false);
                try {
                    c.value = model.getCellValue(rowIndex, columnIndex);
                    c.colspan = model.getCellColSpan(rowIndex, columnIndex);
                    c.rowspan = model.getCellRowSpan(rowIndex, columnIndex);
                    r.cells.add(c);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        ArrayList<Row> effectiveRows = new ArrayList<Row>();
        Row header = new Row();
        try {
            for (columnIndex = 0; columnIndex < columnsCount; ++columnIndex) {
                c = new DefaultCell(true);
                try {
                    c.value = model.getHeaderValue(columnIndex);
                    header.cells.add(c);
                    c.colspan = model.getHeaderColSpan(columnIndex);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (NoSuchElementException columnIndex2) {
            // empty catch block
        }
        if (header.cells.size() > 0 && this.isVisibleHeader()) {
            effectiveRows.add(header);
        }
        boolean p = this.isVisibleColumnPositive();
        boolean n = this.isVisibleColumnNegative();
        for (int i = 0; i < rows1.size(); ++i) {
            Row row = (Row)rows1.get(i);
            Row r2 = new Row();
            List<DefaultCell> cells = row.cells;
            for (int i1 = 0; i1 < cells.size(); ++i1) {
                DefaultCell cell = cells.get(i1);
                if (!this.isVisibleColumn(i1, p, n)) continue;
                r2.cells.add(cell);
            }
            if (r2.cells.size() <= 0) continue;
            effectiveRows.add(r2);
        }
        Bounds b = new Bounds();
        Bounds cb = new Bounds();
        int r = 0;
        int cr = 0;
        for (Row row : effectiveRows) {
            int c2 = 0;
            int cc = 0;
            for (DefaultCell cell : row.cells) {
                int r0 = r;
                int c0 = c2;
                int cr0 = cr;
                int cc0 = cc;
                while (b.isReserved(c0, r0)) {
                    ++c0;
                }
                while (cb.isReserved(cc0, cr0)) {
                    ++cc0;
                }
                cell.cx = cc0;
                cell.cy = cr0;
                cell.x = c0;
                cell.y = r0;
                NutsTableCellFormat formatter = this.getTableCellFormat(cell);
                Object cvalue = cell.getValue();
                cell.setRendered(new RenderedCell(c0, r0, cvalue, formatter.format(r0, c0, cvalue, session), formatter, formatter.getVerticalAlign(r0, c0, cvalue, session), formatter.getHorizontalAlign(r0, c0, cvalue, session), session));
                cell.cw = cell.getRendered().columns;
                cell.ch = cell.getRendered().rows;
                b.setColumnIntervalMinSize(cell.x, cell.x + cell.colspan, cell.cw);
                b.setRowIntervalMinSize(cell.y, cell.y + cell.rowspan, cell.ch);
                for (int i = 0; i < cell.rowspan; ++i) {
                    for (int j = 0; j < cell.colspan; ++j) {
                        b.addReservation(c0 + j, r0 + i);
                    }
                }
                ++c2;
            }
            b.discardRow(r);
            ++r;
        }
        for (Row row : effectiveRows) {
            for (DefaultCell cell : row.cells) {
                int rows = b.evalRowSize(cell.y, cell.rowspan);
                int columns = b.evalColumnSize(cell.x, cell.rowspan);
                cell.rendered = cell.rendered.resize(rows, columns);
                cell.cw = cell.getRendered().columns;
                cell.ch = cell.getRendered().rows;
            }
        }
        return effectiveRows;
    }

    public NutsTableFormat setHeaderFormat(NutsTableCellFormat formatter) {
        this.defaultHeaderFormatter = formatter == null ? DefaultTableHeaderFormat.INSTANCE : formatter;
        return this;
    }

    private boolean isVisibleColumnPositive() {
        for (Boolean visibleColumn : this.visibleColumns) {
            if (visibleColumn == null || !visibleColumn.booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean isVisibleColumnNegative() {
        for (Boolean visibleColumn : this.visibleColumns) {
            if (visibleColumn == null || visibleColumn.booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean isVisibleColumn(int col, boolean p, boolean n) {
        Boolean b = null;
        if (col >= 0 && col < this.visibleColumns.size()) {
            b = this.visibleColumns.get(col);
        }
        if (b == null) {
            if (!p && !n) {
                return true;
            }
            if (p && !n) {
                return false;
            }
            if (!p && n) {
                return true;
            }
            if (p && n) {
                return false;
            }
        }
        return true;
    }

    private NutsTableModel createTableModel(Object o) {
        if (o == null) {
            return new DefaultNutsMutableTableModel();
        }
        if (o instanceof NutsTableModel) {
            return (NutsTableModel)o;
        }
        if (o instanceof String || o instanceof Number || o instanceof Date || o instanceof Temporal || o instanceof Path || o instanceof File) {
            ArrayList<NutsElement> a = new ArrayList<NutsElement>();
            a.add(this._elems().toElement(o));
            return this.createTableModel(this._elems().toElement(a));
        }
        o = this._elems().setDestructTypeFilter(DefaultNutsFormatDestructTypePredicate.INSTANCE).destruct(o);
        if (o instanceof Collection) {
            NutsMutableTableModel model = this.createModel();
            LinkedHashSet<String> columns = new LinkedHashSet<String>();
            this.resolveColumns(o, columns);
            for (String string : columns) {
                model.addHeaderCell((Object)string);
            }
            block12: for (Object e : (Collection)o) {
                Object vv;
                String k;
                model.newRow();
                if (e instanceof NutsElement) {
                    NutsElement elem2 = (NutsElement)e;
                    switch (elem2.type()) {
                        case OBJECT: {
                            HashMap m = new HashMap();
                            for (NutsElementEntry nutsElementEntry : elem2.asObject().children()) {
                                k = nutsElementEntry.getKey();
                                if (!k.isString()) {
                                    k = this._elems().forString(k.toString());
                                }
                                m.put(k.asPrimitive().getString(), nutsElementEntry.getValue());
                            }
                            for (String string : columns) {
                                vv = (NutsElement)m.get(string);
                                if (vv != null) {
                                    model.addCell((Object)this.formatObject(vv));
                                    continue;
                                }
                                model.addCell((Object)"");
                            }
                            continue block12;
                        }
                        default: {
                            for (String string : columns) {
                                if (string.equals("value")) {
                                    model.addCell((Object)this.formatObject(elem2));
                                    continue;
                                }
                                model.addCell((Object)"");
                            }
                            continue block12;
                        }
                    }
                }
                if (e instanceof Map) {
                    HashMap m = new HashMap();
                    Map omap = (Map)e;
                    for (Map.Entry entry : omap.entrySet()) {
                        k = String.valueOf(entry.getKey());
                        m.put(k, entry.getValue());
                    }
                    for (String string : columns) {
                        vv = m.get(string);
                        if (vv != null) {
                            model.addCell((Object)this.formatObject(vv));
                            continue;
                        }
                        model.addCell((Object)"");
                    }
                    continue;
                }
                for (String column : columns) {
                    if (column.equals("value")) {
                        model.addCell((Object)this.formatObject(e));
                        continue;
                    }
                    model.addCell((Object)"");
                }
            }
            return model;
        }
        if (o instanceof Map) {
            NutsMutableTableModel model = this.createModel();
            LinkedHashSet<String> columns = new LinkedHashSet<String>();
            columns.add("Name");
            columns.add("Value");
            for (String string : columns) {
                model.addHeaderCell((Object)string);
            }
            for (Map.Entry entry : ((Map)o).entrySet()) {
                model.newRow();
                model.addCell((Object)this.formatObject(entry.getKey()));
                model.addCell((Object)this.formatObject(entry.getValue()));
            }
            return model;
        }
        if (!(o instanceof NutsElement)) {
            return this.createTableModel(this._elems().toElement(o));
        }
        NutsElement elem = (NutsElement)o;
        switch (elem.type()) {
            case BOOLEAN: 
            case INSTANT: 
            case STRING: 
            case INTEGER: 
            case FLOAT: 
            case NULL: {
                ArrayList<NutsElement> a = new ArrayList<NutsElement>();
                a.add(elem);
                return this.createTableModel(this._elems().toElement(a));
            }
            case OBJECT: {
                return this.createTableModel(this._elems().toElement((Object)elem.asObject().children()));
            }
            case ARRAY: {
                NutsMutableTableModel model = this.createModel();
                LinkedHashSet<String> columns = new LinkedHashSet<String>();
                this.resolveColumns(elem, columns);
                for (String column : columns) {
                    model.addHeaderCell((Object)column);
                }
                block22: for (NutsElement elem2 : elem.asArray().children()) {
                    model.newRow();
                    switch (elem2.type()) {
                        case OBJECT: {
                            HashMap<String, NutsElement> m = new HashMap<String, NutsElement>();
                            for (NutsElementEntry nutsElementEntry : elem2.asObject().children()) {
                                NutsElement k = nutsElementEntry.getKey();
                                if (!k.isString()) {
                                    k = this._elems().forString(k.toString());
                                }
                                m.put(k.asPrimitive().getString(), nutsElementEntry.getValue());
                            }
                            for (String string : columns) {
                                NutsElement vv = (NutsElement)m.get(string);
                                if (vv != null) {
                                    model.addCell((Object)this.formatObject(vv));
                                    continue;
                                }
                                model.addCell((Object)"");
                            }
                            continue block22;
                        }
                        default: {
                            for (String string : columns) {
                                if (string.equals("value")) {
                                    model.addCell((Object)this.formatObject(elem2));
                                    continue;
                                }
                                model.addCell((Object)"");
                            }
                            continue block22;
                        }
                    }
                }
                return model;
            }
        }
        throw new NutsUnsupportedArgumentException(this.getSession(), NutsMessage.cstyle((String)"unsupported %s", (Object[])new Object[]{elem.type()}));
    }

    public void resolveColumns(Object obj, LinkedHashSet<String> columns) {
        block14: {
            block13: {
                if (!(obj instanceof NutsElement)) break block13;
                NutsElement value = (NutsElement)obj;
                switch (value.type()) {
                    case OBJECT: {
                        for (NutsElementEntry nutsNamedValue : value.asObject().children()) {
                            NutsElement k = nutsNamedValue.getKey();
                            if (!k.isString()) {
                                k = this._elems().forString(k.toString());
                            }
                            columns.add(k.asPrimitive().getString());
                        }
                        break block14;
                    }
                    case ARRAY: {
                        for (NutsElement value2 : value.asArray().children()) {
                            this.resolveColumns(value2, columns);
                        }
                        break block14;
                    }
                    default: {
                        columns.add("value");
                    }
                }
                break block14;
            }
            if (obj instanceof List) {
                for (Object value2 : (List)obj) {
                    this.resolveColumns(value2, columns);
                }
            } else if (obj instanceof Map) {
                Map map = (Map)obj;
                for (Map.Entry nutsNamedValue : map.entrySet()) {
                    Object k = nutsNamedValue.getKey();
                    String ks = String.valueOf(k);
                    columns.add(ks);
                }
            } else {
                columns.add("value");
            }
        }
    }

    private NutsElementFormat _elems() {
        return this.getSession().getWorkspace().elem().setSession(this.getSession());
    }

    public Object getValue() {
        return this.model;
    }

    public NutsTableFormat setValue(Object value) {
        this.model = value;
        return this;
    }

    public boolean configureFirst(NutsCommandLine cmdLine) {
        NutsArgument a = cmdLine.nextBoolean(new String[]{"--no-header"});
        if (a != null) {
            boolean val = a.getBooleanValue();
            if (a.isEnabled()) {
                this.setVisibleHeader(!val);
            }
            return true;
        }
        a = cmdLine.nextBoolean(new String[]{"--header"});
        if (a != null) {
            boolean val = a.getBooleanValue();
            if (a.isEnabled()) {
                this.setVisibleHeader(val);
            }
            return true;
        }
        a = cmdLine.nextString(new String[]{"--border"});
        if (a != null) {
            if (a.isEnabled()) {
                this.setBorder(a.getArgumentValue().getStringKey());
            }
            return true;
        }
        if (cmdLine.hasNext() && cmdLine.peek().isOption()) {
            int cc = this.getModel().getColumnsCount();
            HashMap<String, Integer> columns = new HashMap<String, Integer>();
            for (int i = 0; i < cc; ++i) {
                Object v = this.getModel().getHeaderValue(cc);
                if (!(v instanceof String)) continue;
                columns.put(v.toString().toLowerCase(), i);
            }
            NutsArgument a2 = null;
            for (Map.Entry e : columns.entrySet()) {
                a2 = cmdLine.next(new String[]{"--" + (String)e.getKey()});
                if (a2 != null) {
                    if (a2.isEnabled()) {
                        this.setVisibleColumn((Integer)e.getValue(), true);
                    }
                    return true;
                }
                a2 = cmdLine.next(new String[]{"--no-" + (String)e.getKey()});
                if (a2 == null) continue;
                if (a2.isEnabled()) {
                    this.setVisibleColumn((Integer)e.getValue(), false);
                }
                return true;
            }
        }
        return false;
    }

    private NutsString formatObject(Object any) {
        this.checkSession();
        return CoreCommonUtils.stringValueFormatted(any, false, this.getSession());
    }

    public static class Bounds {
        List<Integer> columnSize = new ArrayList<Integer>();
        List<Integer> rowSize = new ArrayList<Integer>();
        Map<Interval, Integer> columnIntervalSize = new HashMap<Interval, Integer>();
        Map<Interval, Integer> rowIntervalSize = new HashMap<Interval, Integer>();
        Set<Pos> reserved = new HashSet<Pos>();

        public void discardRow(int row) {
            Iterator<Pos> iterator = this.reserved.iterator();
            while (iterator.hasNext()) {
                Pos pos = iterator.next();
                if (pos.row != row) continue;
                iterator.remove();
            }
        }

        public boolean isReserved(int col, int row) {
            return this.reserved.contains(new Pos(col, row));
        }

        public void addReservation(int col, int row) {
            this.reserved.add(new Pos(col, row));
        }

        public void setColumnMinSize(int index, int size) {
            while (this.columnSize.size() < index + 1) {
                this.columnSize.add(0);
            }
            this.columnSize.set(index, Math.max(size, this.columnSize.get(index)));
        }

        public void setRowMinSize(int index, int size) {
            while (this.rowSize.size() < index + 1) {
                this.rowSize.add(0);
            }
            this.rowSize.set(index, Math.max(size, this.rowSize.get(index)));
        }

        public void setColumnSize(int index, int size) {
            while (this.columnSize.size() < index + 1) {
                this.columnSize.add(0);
            }
            this.columnSize.set(index, size);
        }

        public void setRowSize(int index, int size) {
            while (this.rowSize.size() < index + 1) {
                this.rowSize.add(0);
            }
            this.columnSize.set(index, size);
        }

        public void setColumnIntervalSize(int from, int to, int size) {
            if (from + 1 == to) {
                this.setColumnSize(from, size);
                return;
            }
            this.columnIntervalSize.put(new Interval(from, to), size);
        }

        public void setRowIntervalSize(int from, int to, int size) {
            if (from + 1 == to) {
                this.setRowSize(from, size);
                return;
            }
            this.rowIntervalSize.put(new Interval(from, to), size);
        }

        public void setColumnIntervalMinSize(int from, int to, int size) {
            Interval key;
            if (from + 1 == to) {
                this.setColumnMinSize(from, size);
                return;
            }
            this.columnIntervalSize.put(key, Math.max(this.columnIntervalSize.containsKey(key = new Interval(from, to)) ? this.columnIntervalSize.get(key) : 0, size));
        }

        public void setRowIntervalMinSize(int from, int to, int size) {
            Interval key;
            if (from + 1 == to) {
                this.setRowMinSize(from, size);
                return;
            }
            this.rowIntervalSize.put(key, Math.max(this.rowIntervalSize.containsKey(key = new Interval(from, to)) ? this.rowIntervalSize.get(key) : 0, size));
        }

        public int evalColumnSize(int col, int colspan) {
            if (colspan <= 0) {
                return 0;
            }
            if (colspan == 1) {
                return this.columnSize.get(col);
            }
            int best = 0;
            for (Map.Entry<Interval, Integer> e : this.columnIntervalSize.entrySet()) {
                int v;
                Interval interval = e.getKey();
                if (interval.from < col || interval.to > col + colspan || (v = this.evalColumnSize(col, interval.from - col) + e.getValue() + this.evalColumnSize(interval.to, col + colspan - interval.to)) <= best) continue;
                best = v;
            }
            int v = this.evalColumnSize(col, 1) + this.evalColumnSize(col + 1, colspan - 1);
            if (v > best) {
                best = v;
            }
            return best;
        }

        public int evalRowSize(int row, int rowspan) {
            if (rowspan <= 0) {
                return 0;
            }
            if (rowspan == 1) {
                return this.rowSize.get(row);
            }
            int best = 0;
            for (Map.Entry<Interval, Integer> e : this.rowIntervalSize.entrySet()) {
                int v;
                Interval interval = e.getKey();
                if (interval.from < row || interval.to > row + rowspan || (v = this.evalRowSize(row, interval.from - row) + e.getValue() + this.evalRowSize(interval.to, row + rowspan - interval.to)) <= best) continue;
                best = v;
            }
            int v = this.evalRowSize(row, 1) + this.evalRowSize(row + 1, rowspan - 1);
            if (v > best) {
                best = v;
            }
            return best;
        }
    }

    public static class Interval {
        int from;
        int to;

        public Interval(int from, int to) {
            this.from = from;
            this.to = to;
        }

        public int hashCode() {
            int result = this.from;
            result = 31 * result + this.to;
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Interval interval = (Interval)o;
            if (this.from != interval.from) {
                return false;
            }
            return this.to == interval.to;
        }

        public String toString() {
            return "Interval{from=" + this.from + ", to=" + this.to + '}';
        }
    }

    public static class Widths {
        Map<Integer, Integer> colWidth = new HashMap<Integer, Integer>();
        Map<Integer, Integer> rowHeight = new HashMap<Integer, Integer>();

        public void updateCellSize(int row, int col, int width, int height) {
            Integer v = this.colWidth.get(col);
            v = v == null ? Integer.valueOf(width) : Integer.valueOf(Math.max(width, v));
            this.colWidth.put(col, v);
            v = this.rowHeight.get(row);
            v = v == null ? Integer.valueOf(height) : Integer.valueOf(Math.max(height, v));
            this.rowHeight.put(row, v);
        }

        private RenderedCell resize(int row, int col, RenderedCell r) {
            return r.resize(this.rowHeight.get(row), this.colWidth.get(col));
        }
    }

    public static class Pos {
        int column;
        int row;

        public Pos(int column, int row) {
            this.column = column;
            this.row = row;
        }

        public int hashCode() {
            return Objects.hash(this.column, this.row);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pos pos = (Pos)o;
            return this.column == pos.column && this.row == pos.row;
        }

        public String toString() {
            return "(" + this.column + "," + this.row + ')';
        }
    }

    public static class DefaultCell
    implements NutsTableCell {
        int colspan = 1;
        int rowspan = 1;
        int x;
        int y;
        int cx;
        int cy;
        int cw;
        int ch;
        Object value;
        RenderedCell rendered;
        boolean header;

        public DefaultCell(boolean header) {
            this.header = header;
        }

        public boolean isHeader() {
            return this.header;
        }

        public void setHeader(boolean header) {
            this.header = header;
        }

        public RenderedCell getRendered() {
            return this.rendered;
        }

        public void setRendered(RenderedCell rendered) {
            this.rendered = rendered;
        }

        public int getColspan() {
            return this.colspan;
        }

        public DefaultCell setColspan(int colspan) {
            this.colspan = colspan <= 0 ? 1 : colspan;
            return this;
        }

        public int getRowspan() {
            return this.rowspan;
        }

        public DefaultCell setRowspan(int rowspan) {
            this.rowspan = rowspan <= 0 ? 1 : rowspan;
            return this;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public Object getValue() {
            return this.value;
        }

        public DefaultCell setValue(Object value) {
            this.value = value;
            return this;
        }

        public String toString() {
            return "Cell{" + this.x + "->" + (this.x + this.colspan) + ", " + this.y + "->" + (this.y + this.rowspan) + ", " + this.value + '}';
        }
    }

    public static class RenderedCell {
        char[][] rendered;
        int rows;
        int columns;
        NutsTableCellFormat formatter;
        NutsTextManager metrics;
        NutsPositionType valign;
        NutsPositionType halign;
        NutsWorkspace ws;
        NutsSession session;

        private RenderedCell(NutsSession session) {
            this.session = session;
            this.ws = session.getWorkspace();
        }

        public RenderedCell(int c, int r, Object o, String str, NutsTableCellFormat formatter, NutsPositionType valign, NutsPositionType halign, NutsSession session) {
            this.session = session;
            this.ws = session.getWorkspace();
            this.formatter = formatter;
            this.metrics = session.getWorkspace().text().setSession(session);
            this.valign = valign;
            this.halign = halign;
            if (str == null) {
                str = "";
            }
            ArrayList<StringBuilder> strings = new ArrayList<StringBuilder>();
            StringTokenizer st = new StringTokenizer(str, "\n", true);
            this.columns = 0;
            while (st.hasMoreElements()) {
                String e = st.nextToken();
                if (e.equals("\n")) {
                    strings.add(new StringBuilder());
                    continue;
                }
                if (strings.isEmpty()) {
                    strings.add(new StringBuilder());
                }
                StringBuilder last = (StringBuilder)strings.get(strings.size() - 1);
                last.append(e);
                this.columns = Math.max(this.columns, this.len(last.toString()));
            }
            this.rows = strings.size();
            this.rendered = new char[this.rows][];
            int stringsSize = strings.size();
            for (int i = 0; i < stringsSize; ++i) {
                StringBuilder s = (StringBuilder)strings.get(i);
                this.rendered[i] = s.toString().toCharArray();
            }
        }

        public int len(String other) {
            return this.metrics.setSession(this.session).parse(other).textLength();
        }

        public RenderedCell appendHorizontally(RenderedCell other) {
            char[][] rendered0 = new char[Math.max(this.rows, other.rows)][];
            for (int i = 0; i < rendered0.length; ++i) {
                char[] a;
                StringBuilder sb = new StringBuilder();
                if (i < this.rendered.length) {
                    sb.append(this.rendered[i]);
                } else {
                    a = new char[this.columns];
                    Arrays.fill(a, 0, this.columns, ' ');
                    sb.append(a);
                }
                if (i < other.rendered.length) {
                    sb.append(other.rendered[i]);
                } else {
                    a = new char[other.columns];
                    Arrays.fill(a, 0, other.columns, ' ');
                    sb.append(a);
                }
                rendered0[i] = sb.toString().toCharArray();
            }
            RenderedCell c = new RenderedCell(this.session);
            c.rendered = rendered0;
            c.columns = this.columns + other.columns;
            c.rows = rendered0.length;
            return c;
        }

        public RenderedCell appendVertically(RenderedCell other) {
            char[] a;
            int remaining;
            StringBuilder sb;
            int i;
            char[][] rendered0 = new char[this.rows + other.rows][];
            int cols = Math.max(this.columns, other.columns);
            for (i = 0; i < this.rendered.length; ++i) {
                sb = new StringBuilder();
                sb.append(this.rendered[i]);
                remaining = cols - this.columns;
                if (remaining > 0) {
                    a = new char[remaining];
                    Arrays.fill(a, 0, remaining, ' ');
                    sb.append(a);
                }
                rendered0[i] = sb.toString().toCharArray();
            }
            for (i = 0; i < other.rendered.length; ++i) {
                sb = new StringBuilder();
                sb.append(other.rendered[i]);
                remaining = cols - other.columns;
                if (remaining > 0) {
                    a = new char[remaining];
                    Arrays.fill(a, 0, remaining, ' ');
                    sb.append(a);
                }
                rendered0[i + this.rendered.length] = sb.toString().toCharArray();
            }
            RenderedCell c = new RenderedCell(this.session);
            c.rendered = rendered0;
            c.columns = this.columns + other.columns;
            c.rows = rendered0.length;
            return c;
        }

        public RenderedCell replaceContent(RenderedCell other, int row, int col) {
            char[][] rendered0 = this.resize((int)Math.max((int)this.rows, (int)(row + other.rows)), (int)Math.max((int)this.columns, (int)(col + other.columns))).rendered;
            for (int r = 0; r < other.rows; ++r) {
                for (int c = 0; c < other.columns; ++c) {
                    rendered0[row + r][col + c] = other.rendered[r][c];
                }
            }
            RenderedCell c = new RenderedCell(this.session);
            c.rendered = rendered0;
            c.columns = this.columns;
            c.rows = this.rows;
            return c;
        }

        public RenderedCell subCell(int row, int col, int toRow, int toCol) {
            char[][] rendered0 = new char[toRow - row][toCol - col];
            for (int i = 0; i < rendered0.length; ++i) {
                System.arraycopy(this.rendered[i + row], col, rendered0[i], 0, toCol - col);
            }
            RenderedCell c = new RenderedCell(this.session);
            c.rendered = rendered0;
            c.columns = this.columns;
            c.rows = this.rows;
            return c;
        }

        public RenderedCell resize(int rows, int columns) {
            char[][] rendered0 = new char[rows][];
            switch (this.valign) {
                case FIRST: {
                    int i;
                    for (i = 0; i < rows; ++i) {
                        if (i < this.rendered.length) {
                            char[] chars = this.rendered[i];
                            int ll = this.len(new String(chars));
                            int min = Math.min(columns, ll);
                            if (min < columns) {
                                int x = columns - min;
                                StringBuilder s = new StringBuilder();
                                s.append(chars);
                                DefaultTableFormat.formatAndHorizontalAlign(s, this.halign, columns, this.metrics, this.session);
                                rendered0[i] = s.toString().toCharArray();
                                continue;
                            }
                            rendered0[i] = this.rendered[i];
                            continue;
                        }
                        rendered0[i] = CoreStringUtils.fillString(' ', columns).toCharArray();
                    }
                    break;
                }
                case LAST: {
                    int i;
                    for (i = 0; i < rows; ++i) {
                        if (i < rows - this.rendered.length) {
                            rendered0[i] = CoreStringUtils.fillString(' ', columns).toCharArray();
                            continue;
                        }
                        char[] chars = this.rendered[i];
                        int ll = this.len(new String(chars));
                        int min = Math.min(columns, ll);
                        if (min < columns) {
                            int x = columns - min;
                            StringBuilder s = new StringBuilder();
                            s.append(chars);
                            DefaultTableFormat.formatAndHorizontalAlign(s, this.halign, columns, this.metrics, this.session);
                            rendered0[i] = s.toString().toCharArray();
                            continue;
                        }
                        rendered0[i] = this.rendered[i];
                    }
                    break;
                }
                case CENTER: {
                    int i;
                    for (i = 0; i < rows; ++i) {
                        if (i < this.rendered.length) {
                            char[] chars = this.rendered[i];
                            int ll = this.len(new String(chars));
                            int min = Math.min(columns, ll);
                            if (min < columns) {
                                int x = columns - min;
                                StringBuilder s = new StringBuilder();
                                s.append(chars);
                                DefaultTableFormat.formatAndHorizontalAlign(s, this.halign, columns, this.metrics, this.session);
                                rendered0[i] = s.toString().toCharArray();
                                continue;
                            }
                            rendered0[i] = this.rendered[i];
                            continue;
                        }
                        rendered0[i] = CoreStringUtils.fillString(' ', columns).toCharArray();
                    }
                    break;
                }
            }
            RenderedCell c = new RenderedCell(this.session);
            c.rendered = rendered0;
            c.columns = columns;
            c.rows = rows;
            c.formatter = this.formatter;
            return c;
        }

        public RenderedCell copy() {
            char[][] rendered0 = new char[this.rendered.length][];
            for (int i = 0; i < rendered0.length; ++i) {
                rendered0[i] = new char[this.rendered[i].length];
                System.arraycopy(this.rendered[i], 0, rendered0[i], 0, this.rendered[i].length);
            }
            RenderedCell c = new RenderedCell(this.session);
            c.rendered = rendered0;
            c.columns = this.columns;
            c.rows = this.rows;
            return c;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            int renderedLength = this.rendered.length;
            for (int i = 0; i < renderedLength; ++i) {
                char[] chars = this.rendered[i];
                if (i > 0) {
                    sb.append("\n");
                }
                sb.append(chars);
            }
            return sb.toString();
        }
    }

    public static class Row {
        List<DefaultCell> cells = new ArrayList<DefaultCell>();
    }
}

