/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.props;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementEntry;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsPropertiesFormat;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsUnsupportedEnumException;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.format.DefaultFormatBase;
import net.thevpc.nuts.runtime.core.format.ObjectOutputFormatWriterHelper;
import net.thevpc.nuts.runtime.core.util.CoreCommonUtils;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;

public class DefaultPropertiesFormat
extends DefaultFormatBase<NutsPropertiesFormat>
implements NutsPropertiesFormat {
    public static final String OPTION_MULTILINE_PROPERTY = "--multiline-property";
    private boolean sorted;
    private boolean compact;
    private boolean javaProps;
    private final String rootName = "";
    private final boolean omitNull = true;
    private boolean escapeText = true;
    private String separator = " = ";
    private Object value;
    private Map<String, String> multilineProperties = new HashMap<String, String>();

    public DefaultPropertiesFormat(NutsWorkspace ws) {
        super(ws, "props-format");
    }

    public boolean configureFirst(NutsCommandLine commandLine) {
        NutsArgument a = commandLine.nextString(new String[]{OPTION_MULTILINE_PROPERTY});
        if (a != null) {
            NutsArgument i = a.getArgumentValue();
            if (i.isEnabled()) {
                this.addMultilineProperty(i.getStringKey(), i.getStringValue());
            }
            return true;
        }
        a = commandLine.nextBoolean(new String[]{"--compact"});
        if (a != null) {
            if (a.isEnabled()) {
                this.compact = a.getBooleanValue();
            }
            return true;
        }
        a = commandLine.nextBoolean(new String[]{"--props"});
        if (a != null) {
            if (a.isEnabled()) {
                this.javaProps = a.getBooleanValue();
            }
            return true;
        }
        a = commandLine.nextBoolean(new String[]{"--escape-text"});
        if (a != null) {
            if (a.isEnabled()) {
                this.escapeText = a.getBooleanValue();
            }
            return true;
        }
        return false;
    }

    public DefaultPropertiesFormat addMultilineProperty(String property, String separator) {
        this.multilineProperties.put(property, separator);
        return this;
    }

    public Map buildModel() {
        Object value = this.getValue();
        if (value instanceof Map) {
            return (Map)value;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        this.fillMap(this.getSession().getWorkspace().elem().toElement(value), map, "");
        return map;
    }

    private void fillMap(NutsElement e, Map<String, Object> map, String prefix) {
        switch (e.type()) {
            case NULL: {
                break;
            }
            case BOOLEAN: 
            case INSTANT: 
            case INTEGER: 
            case FLOAT: 
            case STRING: {
                String k = NutsUtilStrings.isBlank((CharSequence)prefix) ? "value" : prefix;
                map.put(k, this.stringValue(e.asPrimitive().getValue()));
                break;
            }
            case ARRAY: {
                int index = 1;
                for (NutsElement datum : e.asArray().children()) {
                    String k = NutsUtilStrings.isBlank((CharSequence)prefix) ? String.valueOf(index) : prefix + "." + String.valueOf(index);
                    this.fillMap(datum, map, k);
                    ++index;
                }
                break;
            }
            case OBJECT: {
                for (NutsElementEntry datum : e.asObject().children()) {
                    NutsElement k = datum.getKey();
                    if (!k.isString()) {
                        k = this.getSession().getWorkspace().elem().setSession(this.getSession()).forString(k.toString());
                    }
                    String ks = k.asPrimitive().getString();
                    String k2 = NutsUtilStrings.isBlank((CharSequence)prefix) ? ks : prefix + "." + ks;
                    this.fillMap(datum.getValue(), map, k2);
                }
                break;
            }
            default: {
                throw new NutsUnsupportedEnumException(this.getSession(), (Enum)e.type());
            }
        }
    }

    public Map getModel() {
        return this.buildModel();
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public String getSeparator() {
        return this.separator;
    }

    public DefaultPropertiesFormat setSeparator(String separator) {
        this.separator = separator;
        return this;
    }

    public DefaultPropertiesFormat setSorted(boolean sort) {
        this.sorted = sort;
        return this;
    }

    @Override
    public void print(NutsPrintStream w) {
        LinkedHashMap<Object, Object> mm;
        this.checkSession();
        NutsPrintStream out = this.getValidPrintStream(w);
        LinkedHashMap<Object, Object> model = this.buildModel();
        if (this.sorted) {
            mm = new LinkedHashMap<Object, Object>();
            ArrayList keys = new ArrayList(model.keySet());
            if (this.sorted) {
                keys.sort(null);
            }
            for (Object k : keys) {
                Object v = model.get(k);
                mm.put(k, v);
            }
        } else {
            mm = model;
        }
        if (this.javaProps) {
            CoreIOUtils.storeProperties(ObjectOutputFormatWriterHelper.explodeMap(mm), w.asPrintStream(), this.sorted);
        } else {
            this.printMap(out, (NutsString)this.getSession().getWorkspace().text().forBlank(), mm);
        }
    }

    private void printMap(NutsPrintStream out, NutsString prefix, Map<Object, Object> props) {
        int len = 1;
        for (Object extraKey : props.keySet()) {
            int x = this.stringValue(extraKey).textLength();
            if (x <= len) continue;
            len = x;
        }
        boolean first = true;
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            if (first) {
                first = false;
            } else {
                out.println();
            }
            this.printKeyValue(out, prefix, len, this.stringValue(e.getKey()), this.stringValue(e.getValue()));
        }
        out.flush();
    }

    private String getMultilineSeparator(NutsString key) {
        String sep = this.multilineProperties.get(key.filteredText());
        if (sep != null && sep.length() == 0) {
            sep = ":|;";
        }
        return sep;
    }

    private void printKeyValue(NutsPrintStream out, NutsString prefix, int len, NutsString key, NutsString value) {
        this.printKeyValue(out, prefix, len, this.getMultilineSeparator(key), key, value);
    }

    private void printKeyValue(NutsPrintStream out, NutsString prefix, int len, String fancySep, NutsString key, NutsString value) {
        NutsString formattedKey;
        NutsTextManager txt = this.getSession().getWorkspace().text();
        if (prefix == null) {
            prefix = txt.forBlank();
        }
        Object object = formattedKey = this.compact ? key : txt.builder().append((Object)key).append((Object)CoreStringUtils.fillString(' ', len - key.textLength()));
        if (fancySep != null) {
            NutsString cc = this.compact ? key : txt.forPlain(CoreStringUtils.alignLeft("", len + 3));
            String[] split = value.toString().split(fancySep);
            if (split.length == 0) {
                out.print(prefix);
                out.print(formattedKey);
                out.print(this.separator);
            } else {
                for (int i = 0; i < split.length; ++i) {
                    String s = split[i];
                    if (i == 0) {
                        out.print(prefix);
                        if (prefix.isEmpty() || prefix.toString().endsWith("#")) {
                            out.print('\u001e');
                        }
                        out.printf("%s", new Object[]{formattedKey});
                        if (this.separator.isEmpty() || this.separator.startsWith("#")) {
                            out.print('\u001e');
                        }
                        out.print(this.separator);
                        out.print(s);
                        continue;
                    }
                    out.println();
                    out.printf("%s", new Object[]{cc});
                    out.print(s);
                }
            }
        } else {
            out.print(prefix);
            if (prefix.isEmpty() || prefix.toString().endsWith("#")) {
                out.print('\u001e');
            }
            out.printf("%s", new Object[]{txt.forStyled(formattedKey, NutsTextStyle.primary3())});
            if (this.separator.isEmpty() || this.separator.startsWith("#")) {
                out.print('\u001e');
            }
            out.print(this.separator);
            out.print(value);
        }
    }

    private NutsString stringValue(Object o) {
        if (this.escapeText) {
            return CoreCommonUtils.stringValueFormatted(o, this.escapeText, this.getSession());
        }
        return this.getSession().getWorkspace().text().forPlain(String.valueOf(o));
    }

    public Object getValue() {
        return this.value;
    }

    public NutsPropertiesFormat setValue(Object value) {
        this.value = value;
        return this;
    }
}

