/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.plain;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.stream.StreamResult;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementFormat;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsTableFormat;
import net.thevpc.nuts.NutsTableModel;
import net.thevpc.nuts.NutsTreeFormat;
import net.thevpc.nuts.NutsTreeModel;
import net.thevpc.nuts.NutsUnsupportedArgumentException;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.format.NutsObjectFormatBase;
import net.thevpc.nuts.runtime.core.format.tree.DefaultNutsFormatDestructTypePredicate;
import net.thevpc.nuts.runtime.core.format.xml.NutsXmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NutsObjectFormatPlain
extends NutsObjectFormatBase {
    private final String rootName = "";
    private final List<String> extraConfig = new ArrayList<String>();
    private final Map<String, String> multilineProperties = new HashMap<String, String>();

    public NutsObjectFormatPlain(NutsWorkspace ws) {
        super(ws, NutsContentType.PLAIN.id() + "-format");
    }

    @Override
    public boolean configureFirst(NutsCommandLine commandLine) {
        NutsArgument n = commandLine.peek();
        if (n != null) {
            boolean enabled = n.isEnabled();
            NutsArgument a = commandLine.nextString(new String[]{"--multiline-property"});
            if (a != null) {
                if (enabled) {
                    NutsArgument i = a.getArgumentValue();
                    this.extraConfig.add(a.getString());
                    this.addMultilineProperty(i.getStringKey(), i.getStringValue());
                }
            } else {
                a = commandLine.next();
                if (!a.isOption() || a.isEnabled()) {
                    this.extraConfig.add(a.getString());
                }
            }
            return true;
        }
        return false;
    }

    public NutsObjectFormatBase addMultilineProperty(String property, String separator) {
        this.multilineProperties.put(property, separator);
        return this;
    }

    private String getFormattedPrimitiveValue(NutsElement value) {
        switch (value.type()) {
            default: 
        }
        throw new NutsUnsupportedArgumentException(this.getSession(), NutsMessage.cstyle((String)"invalid element type: %s", (Object[])new Object[]{value.type()}));
    }

    @Override
    public void print(NutsPrintStream w) {
        this.checkSession();
        Object value = this.getValue();
        NutsWorkspace ws = this.getSession().getWorkspace();
        if (value instanceof NutsTableModel) {
            ws.formats().table(value).configure(true, this.extraConfig.toArray(new String[0])).print(w);
        } else if (value instanceof NutsTreeModel) {
            ws.formats().tree(value).configure(true, this.extraConfig.toArray(new String[0])).print(w);
        } else if (value instanceof Document) {
            NutsXmlUtils.writeDocument((Document)value, new StreamResult(w.asPrintStream()), false, true, this.getSession());
        } else if (value instanceof Element) {
            Element elem = (Element)value;
            Document doc = NutsXmlUtils.createDocument(this.getSession());
            doc.appendChild(doc.importNode(elem, true));
            NutsXmlUtils.writeDocument(doc, new StreamResult(w.asPrintStream()), false, false, this.getSession());
        } else {
            NutsElementFormat element = ws.elem();
            element.setNtf(true).setDestructTypeFilter(DefaultNutsFormatDestructTypePredicate.INSTANCE);
            this.printElement(w, element.destruct(value));
        }
    }

    public void printElement(NutsPrintStream w, Object value) {
        NutsPrintStream out = this.getValidPrintStream(w);
        NutsWorkspace ws = this.getSession().getWorkspace();
        if (value instanceof Map) {
            NutsTreeFormat tree = ws.formats().tree();
            tree.configure(true, this.extraConfig.toArray(new String[0]));
            tree.setValue(value).print(w);
        } else if (value instanceof List) {
            NutsTableFormat table = ws.formats().table();
            table.configure(true, new String[]{"--no-header", "--border=spaces"});
            table.setValue(value).print(w);
        } else {
            out.printf("%s", new Object[]{value});
            out.flush();
        }
    }
}

