/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.json;

import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCodeFormat;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.runtime.core.format.DefaultSearchFormatBase;
import net.thevpc.nuts.runtime.core.format.NutsFetchDisplayOptions;

public class DefaultSearchFormatJson
extends DefaultSearchFormatBase {
    private boolean compact;
    NutsTextManager factory = this.getWorkspace().text();
    private NutsCodeFormat codeFormat;

    public DefaultSearchFormatJson(NutsSession session, NutsPrintStream writer, NutsFetchDisplayOptions options) {
        super(session, writer, NutsContentType.JSON, options);
        this.codeFormat = session.getWorkspace().text().setSession(session).getCodeFormat("json");
    }

    public void start() {
        this.getWriter().println((NutsString)this.codeFormat.tokenToText("[", "separator", this.getSession()));
        this.getWriter().flush();
    }

    public void complete(long count) {
        this.getWriter().println((NutsString)this.codeFormat.tokenToText("]", "separator", this.getSession()));
        this.getWriter().flush();
    }

    public boolean configureFirst(NutsCommandLine cmd) {
        NutsArgument a = cmd.peek();
        if (a == null) {
            return false;
        }
        if (this.getDisplayOptions().configureFirst(cmd)) {
            return true;
        }
        boolean enabled = a.isEnabled();
        switch (a.getStringKey()) {
            case "--compact": {
                boolean val = cmd.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.compact = val;
                }
                return true;
            }
        }
        return false;
    }

    public void next(Object object, long index) {
        if (index > 0L) {
            this.getWriter().print(", ");
        } else {
            this.getWriter().print("  ");
        }
        String json = this.getWorkspace().elem().setSession(this.getSession()).setContentType(NutsContentType.JSON).setValue(object).setCompact(this.isCompact()).format().filteredText();
        NutsText ee = this.codeFormat.stringToText(json, this.getSession());
        this.getWriter().printf("%s%n", new Object[]{ee});
        this.getWriter().flush();
    }

    public boolean isCompact() {
        return this.compact;
    }
}

