/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.elem;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsArrayElementBuilder;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementEntry;
import net.thevpc.nuts.NutsElementFormat;
import net.thevpc.nuts.NutsElementPath;
import net.thevpc.nuts.NutsElementType;
import net.thevpc.nuts.NutsSession;

public class NutsElementPathFilter {
    private static final NutsElementNameMatcherFalse NUTS_ELEMENT_NAME_MATCHER_FALSE = new NutsElementNameMatcherFalse();
    private static final NutsElementNameMatcherEven NUTS_ELEMENT_NAME_MATCHER_EVEN = new NutsElementNameMatcherEven();
    private static final NutsElementNameMatcherOdd NUTS_ELEMENT_NAME_MATCHER_ODD = new NutsElementNameMatcherOdd();
    private static final NutsElementNameMatcherValue NUTS_ELEMENT_NAME_MATCHER_VALUE_ZERO = new NutsElementNameMatcherValue(0);
    private static final NutsElementNameMatcherValue NUTS_ELEMENT_NAME_MATCHER_VALUE_MINUS_ONE = new NutsElementNameMatcherValue(-1);
    private static final NutsElementNameMatcherTrue NUTS_ELEMENT_NAME_MATCHER_TRUE = new NutsElementNameMatcherTrue();
    private static final NutsElementIndexMatcherFalse NUTS_ELEMENT_INDEX_MATCHER_FALSE = new NutsElementIndexMatcherFalse();
    private static final NutsElementIndexMatcherUnique NUTS_ELEMENT_INDEX_MATCHER_UNIQUE = new NutsElementIndexMatcherUnique();
    private static final NutsElementIndexMatcherEven NUTS_ELEMENT_INDEX_MATCHER_EVEN = new NutsElementIndexMatcherEven();
    private static final NutsElementIndexMatcherOdd NUTS_ELEMENT_INDEX_MATCHER_ODD = new NutsElementIndexMatcherOdd();
    private static final NutsElementIndexMatcherForValue NUTS_ELEMENT_INDEX_MATCHER_FOR_VALUE_0 = new NutsElementIndexMatcherForValue(0);
    private static final NutsElementIndexMatcherForValue NUTS_ELEMENT_INDEX_MATCHER_FOR_VALUE_MINUS_ONE = new NutsElementIndexMatcherForValue(-1);
    private static final NutsElementIndexMatcherTrue NUTS_ELEMENT_INDEX_MATCHER_TRUE = new NutsElementIndexMatcherTrue();

    private static void compile_readChar(StreamTokenizer st, char c) throws IOException {
        int i = st.nextToken();
        if (i != c) {
            throw new IllegalArgumentException("Expected " + c + ". got " + (char)i);
        }
    }

    private static String compile_readArrItem(StreamTokenizer st) throws IOException {
        NutsElementPathFilter.compile_readChar(st, '[');
        st.nextToken();
        String value = null;
        switch (st.ttype) {
            case 93: {
                return "";
            }
            case -3: {
                value = st.sval;
                NutsElementPathFilter.compile_readChar(st, ']');
                return value;
            }
        }
        throw new IllegalArgumentException("Expected string, got " + st);
    }

    public static NutsElementPath compile(String jpath, NutsSession session) {
        StreamTokenizer st = new StreamTokenizer(new StringReader(jpath));
        st.resetSyntax();
        st.wordChars(33, 255);
        st.ordinaryChar(46);
        st.ordinaryChar(91);
        st.ordinaryChar(93);
        QueueJsonPath q = new QueueJsonPath();
        try {
            boolean wasNotDotName = false;
            block7: while (st.nextToken() != -1) {
                switch (st.ttype) {
                    case -3: {
                        wasNotDotName = true;
                        q.queue.add(new SubItemJsonPath(st.sval, session));
                        continue block7;
                    }
                    case 46: {
                        if (!wasNotDotName) {
                            q.queue.add(new SubItemJsonPath("*", session));
                        }
                        wasNotDotName = false;
                        continue block7;
                    }
                    case 91: {
                        wasNotDotName = true;
                        st.pushBack();
                        String p = NutsElementPathFilter.compile_readArrItem(st);
                        if (p.isEmpty()) {
                            q.queue.add(new ArrItemCollectorJsonPath(session));
                            continue block7;
                        }
                        q.queue.add(new SubItemJsonPath(p, session));
                        continue block7;
                    }
                }
                throw new IllegalArgumentException("Unexpected " + st);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return q;
    }

    private static boolean isInt(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static class NutsElementIndexMatcherUnique
    implements NutsElementIndexMatcher {
        @Override
        public boolean matches(NutsElement value, int index, int len, Map<String, Object> matchContext, NutsSession session) {
            String v;
            HashSet<String> u = (HashSet<String>)matchContext.get("unique");
            if (u == null) {
                u = new HashSet<String>();
                matchContext.put("unique", u);
            }
            if (u.contains(v = session.getWorkspace().elem().setSession(session).setContentType(NutsContentType.JSON).setValue((Object)value).format().filteredText())) {
                return false;
            }
            u.add(v);
            return true;
        }
    }

    private static class NutsElementIndexMatcherValueInterval
    implements NutsElementIndexMatcher {
        private final int a;
        private final int b;

        public NutsElementIndexMatcherValueInterval(int a, int b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public boolean matches(NutsElement value, int index, int len, Map<String, Object> matchContext, NutsSession session) {
            return index >= this.a && index <= this.b;
        }
    }

    private static class NutsElementIndexMatcherFalse
    implements NutsElementIndexMatcher {
        @Override
        public boolean matches(NutsElement value, int index, int len, Map<String, Object> matchContext, NutsSession session) {
            return false;
        }
    }

    private static class NutsElementIndexMatcherForValue
    implements NutsElementIndexMatcher {
        private final int a;

        public NutsElementIndexMatcherForValue(int a) {
            this.a = a;
        }

        @Override
        public boolean matches(NutsElement value, int index, int len, Map<String, Object> matchContext, NutsSession session) {
            if (this.a < 0) {
                return index == len + this.a;
            }
            return index == this.a;
        }
    }

    private static class NutsElementNameMatcherString
    implements NutsElementNameMatcher {
        private final String pat;
        private final boolean lower;

        public NutsElementNameMatcherString(String pat, boolean lower) {
            this.lower = lower;
            this.pat = lower ? pat.toLowerCase() : pat;
        }

        @Override
        public boolean matches(int index, NutsElement name, int len, Map<String, Object> matchContext, NutsSession session) {
            if (name.type() == NutsElementType.STRING) {
                String sname = name.asPrimitive().getString();
                return this.lower ? sname.toLowerCase().matches(this.pat) : sname.matches(this.pat);
            }
            return false;
        }
    }

    private static class NutsElementNameMatcherFalse
    implements NutsElementNameMatcher {
        @Override
        public boolean matches(int index, NutsElement name, int len, Map<String, Object> matchContext, NutsSession session) {
            return false;
        }
    }

    private static class NutsElementNameMatcherValueInterval
    implements NutsElementNameMatcher {
        private final int a;
        private final int b;

        public NutsElementNameMatcherValueInterval(int a, int b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public boolean matches(int index, NutsElement name, int len, Map<String, Object> matchContext, NutsSession session) {
            return index >= this.a && index <= this.b;
        }
    }

    private static class NutsElementNameMatcherEven
    implements NutsElementNameMatcher {
        @Override
        public boolean matches(int index, NutsElement name, int len, Map<String, Object> matchContext, NutsSession session) {
            return index % 2 == 0;
        }
    }

    private static class NutsElementNameMatcherOdd
    implements NutsElementNameMatcher {
        @Override
        public boolean matches(int index, NutsElement name, int len, Map<String, Object> matchContext, NutsSession session) {
            return index % 2 == 1;
        }
    }

    private static class NutsElementNameMatcherValue
    implements NutsElementNameMatcher {
        private final int a;

        public NutsElementNameMatcherValue(int a) {
            this.a = a;
        }

        @Override
        public boolean matches(int index, NutsElement name, int len, Map<String, Object> matchContext, NutsSession session) {
            if (this.a < 0) {
                return index == len + this.a;
            }
            return index == this.a;
        }
    }

    private static class NutsElementNameMatcherTrue
    implements NutsElementNameMatcher {
        @Override
        public boolean matches(int index, NutsElement s, int len, Map<String, Object> matchContext, NutsSession session) {
            return true;
        }
    }

    private static class NutsElementIndexMatcherTrue
    implements NutsElementIndexMatcher {
        @Override
        public boolean matches(NutsElement value, int index, int len, Map<String, Object> matchContext, NutsSession session) {
            return true;
        }
    }

    private static class NutsElementIndexMatcherOdd
    implements NutsElementIndexMatcher {
        @Override
        public boolean matches(NutsElement value, int index, int len, Map<String, Object> matchContext, NutsSession session) {
            return index % 2 == 1;
        }
    }

    private static class NutsElementIndexMatcherEven
    implements NutsElementIndexMatcher {
        @Override
        public boolean matches(NutsElement value, int index, int len, Map<String, Object> matchContext, NutsSession session) {
            return index % 2 == 0;
        }
    }

    public static interface NutsElementIndexMatcher {
        public boolean matches(NutsElement var1, int var2, int var3, Map<String, Object> var4, NutsSession var5);
    }

    public static interface NutsElementNameMatcher {
        public boolean matches(int var1, NutsElement var2, int var3, Map<String, Object> var4, NutsSession var5);
    }

    public static class OrNutsElementIndexMatcher
    implements NutsElementIndexMatcher {
        List<NutsElementIndexMatcher> all = new ArrayList<NutsElementIndexMatcher>();

        public OrNutsElementIndexMatcher(NutsElementIndexMatcher[] all) {
            this.all.addAll(Arrays.asList(all));
        }

        @Override
        public boolean matches(NutsElement value, int index, int len, Map<String, Object> matchContext, NutsSession session) {
            for (NutsElementIndexMatcher any : this.all) {
                if (!any.matches(value, index, len, matchContext, session)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "(" + this.all.stream().map(Object::toString).collect(Collectors.joining(" or ")) + ')';
        }
    }

    public static class OrNutsElementNameMatcher
    implements NutsElementNameMatcher {
        List<NutsElementNameMatcher> all = new ArrayList<NutsElementNameMatcher>();

        public OrNutsElementNameMatcher(NutsElementNameMatcher[] all) {
            this.all.addAll(Arrays.asList(all));
        }

        @Override
        public boolean matches(int index, NutsElement name, int len, Map<String, Object> matchContext, NutsSession session) {
            for (NutsElementNameMatcher any : this.all) {
                if (!any.matches(index, name, len, matchContext, session)) continue;
                return true;
            }
            return false;
        }
    }

    private static abstract class AbstractJsonPath
    implements NutsElementPath {
        NutsSession session;

        public AbstractJsonPath(NutsSession session) {
            this.session = session;
        }

        public abstract List<NutsElement> filter(NutsElement var1);

        public List<NutsElement> filter(List<NutsElement> elements) {
            ArrayList<NutsElement> a = new ArrayList<NutsElement>();
            for (NutsElement element : elements) {
                List<NutsElement> ff = this.filter(element);
                if (ff == null) continue;
                a.addAll(ff);
            }
            return a;
        }
    }

    private static class SubItemJsonPath
    extends AbstractJsonPath {
        private String pattern;

        public SubItemJsonPath(String subItem, NutsSession session) {
            super(session);
            this.pattern = subItem;
        }

        public String toString() {
            return "match(" + this.pattern + ')';
        }

        @Override
        public List<NutsElement> filter(NutsElement element) {
            if (element.type() == NutsElementType.ARRAY) {
                ArrayList arr = new ArrayList(element.asArray().children());
                ArrayList<NutsElement> result = new ArrayList<NutsElement>();
                int len = arr.size();
                NutsElementIndexMatcher indexMatcher = this.matchesIndex(this.pattern);
                HashMap<String, Object> matchContext = new HashMap<String, Object>();
                for (int i = 0; i < arr.size(); ++i) {
                    NutsElement value = (NutsElement)arr.get(i);
                    if (!indexMatcher.matches(value, i, len, matchContext, this.session)) continue;
                    result.add(value);
                }
                return result;
            }
            if (element.type() == NutsElementType.OBJECT) {
                ArrayList<NutsElement> result = new ArrayList<NutsElement>();
                Collection aa0 = element.asObject().children();
                int len = aa0.size();
                int index = 0;
                HashMap<String, Object> matchContext = new HashMap<String, Object>();
                NutsElementNameMatcher nameMatcher = this.matchesName(this.pattern);
                for (NutsElementEntry se : aa0) {
                    if (nameMatcher.matches(index, se.getKey(), len, matchContext, this.session)) {
                        result.add(se.getValue());
                    }
                    ++index;
                }
                return result;
            }
            return null;
        }

        private NutsElementNameMatcher matchesName(String s) {
            switch (s) {
                case "*": 
                case ":*": 
                case ":#*": {
                    return NUTS_ELEMENT_NAME_MATCHER_TRUE;
                }
                case ":last": {
                    return NUTS_ELEMENT_NAME_MATCHER_VALUE_MINUS_ONE;
                }
                case ":first": {
                    return NUTS_ELEMENT_NAME_MATCHER_VALUE_ZERO;
                }
                case ":odd": {
                    return NUTS_ELEMENT_NAME_MATCHER_ODD;
                }
                case ":even": {
                    return NUTS_ELEMENT_NAME_MATCHER_EVEN;
                }
            }
            if (s.startsWith(":#")) {
                s = s.substring(2);
                ArrayList<NutsElementNameMatcher> ors = new ArrayList<NutsElementNameMatcher>();
                for (String vir : s.split(",")) {
                    if ((vir = vir.trim()).length() <= 0) continue;
                    if (vir.indexOf(45) > 0) {
                        String[] inter = vir.split("-");
                        if (inter.length != 2 || !NutsElementPathFilter.isInt(inter[0]) || !NutsElementPathFilter.isInt(inter[1])) continue;
                        int a = Integer.parseInt(inter[0]);
                        int b = Integer.parseInt(inter[1]);
                        ors.add(new NutsElementNameMatcherValueInterval(a, b));
                        continue;
                    }
                    if (!NutsElementPathFilter.isInt(vir)) continue;
                    int a = Integer.parseInt(vir);
                    ors.add(new NutsElementNameMatcherValue(a));
                }
                if (ors.size() == 1) {
                    return (NutsElementNameMatcher)ors.get(0);
                }
                if (ors.size() > 1) {
                    return new OrNutsElementNameMatcher(ors.toArray(new NutsElementNameMatcher[0]));
                }
                return NUTS_ELEMENT_NAME_MATCHER_FALSE;
            }
            if (s.startsWith(":nocase=")) {
                return new NutsElementNameMatcherString(s.substring(":nocase=".length()), true);
            }
            return new NutsElementNameMatcherString(this.pattern, false);
        }

        private NutsElementIndexMatcher matchesIndex(String s) {
            switch (s) {
                case "*": 
                case ":*": 
                case ":#*": {
                    return NUTS_ELEMENT_INDEX_MATCHER_TRUE;
                }
                case ":last": {
                    return NUTS_ELEMENT_INDEX_MATCHER_FOR_VALUE_MINUS_ONE;
                }
                case ":first": {
                    return NUTS_ELEMENT_INDEX_MATCHER_FOR_VALUE_0;
                }
                case ":odd": {
                    return NUTS_ELEMENT_INDEX_MATCHER_ODD;
                }
                case ":even": {
                    return NUTS_ELEMENT_INDEX_MATCHER_EVEN;
                }
                case ":unique": {
                    return NUTS_ELEMENT_INDEX_MATCHER_UNIQUE;
                }
            }
            if (s.startsWith(":#")) {
                s = s.substring(2);
                return this.createIndexValueInervalMatcher(s);
            }
            if (NutsElementPathFilter.isInt(s)) {
                return new NutsElementIndexMatcherForValue(Integer.parseInt(s));
            }
            if (s.matches("[0-9][0-9,-]+")) {
                return this.createIndexValueInervalMatcher(s);
            }
            return NUTS_ELEMENT_INDEX_MATCHER_FALSE;
        }

        private NutsElementIndexMatcher createIndexValueInervalMatcher(String s) throws NumberFormatException {
            ArrayList<NutsElementIndexMatcher> ors = new ArrayList<NutsElementIndexMatcher>();
            for (String vir : s.split(",")) {
                if ((vir = vir.trim()).length() <= 0) continue;
                if (vir.indexOf(45) > 0) {
                    String[] inter = vir.split("-");
                    if (inter.length != 2 || !NutsElementPathFilter.isInt(inter[0]) || !NutsElementPathFilter.isInt(inter[1])) continue;
                    int a = Integer.parseInt(inter[0]);
                    int b = Integer.parseInt(inter[1]);
                    ors.add(new NutsElementIndexMatcherValueInterval(a, b));
                    continue;
                }
                if (!NutsElementPathFilter.isInt(vir)) continue;
                ors.add(new NutsElementIndexMatcherForValue(Integer.parseInt(vir)));
            }
            if (ors.size() == 1) {
                return (NutsElementIndexMatcher)ors.get(0);
            }
            if (ors.size() > 1) {
                return new OrNutsElementIndexMatcher(ors.toArray(new NutsElementIndexMatcher[0]));
            }
            return new NutsElementIndexMatcherFalse();
        }
    }

    private static class ArrItemCollectorJsonPath
    implements NutsElementPath {
        private NutsSession session;
        private NutsElementFormat builder;

        public ArrItemCollectorJsonPath(NutsSession session) {
            this.session = session;
            this.builder = session.getWorkspace().elem().setSession(session);
        }

        public List<NutsElement> filter(NutsElement element) {
            NutsArrayElementBuilder aa = this.builder.forArray();
            aa.add(element);
            return aa.children();
        }

        public List<NutsElement> filter(List<NutsElement> elements) {
            NutsArrayElementBuilder aa = this.builder.forArray();
            for (NutsElement element : elements) {
                aa.add(element);
            }
            return aa.children();
        }
    }

    private static class QueueJsonPath
    implements NutsElementPath {
        List<NutsElementPath> queue = new ArrayList<NutsElementPath>();

        private QueueJsonPath() {
        }

        public List<NutsElement> filter(List<NutsElement> elements) {
            for (NutsElementPath jsonPath : this.queue) {
                elements = jsonPath.filter(elements);
            }
            return elements;
        }

        public List<NutsElement> filter(NutsElement element) {
            ArrayList<NutsElement> a = new ArrayList<NutsElement>();
            a.add(element);
            return this.filter(a);
        }

        public String toString() {
            return this.queue.stream().map(Object::toString).collect(Collectors.joining("."));
        }
    }
}

