/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.elem;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Objects;
import net.thevpc.nuts.NutsElementType;
import net.thevpc.nuts.NutsPrimitiveElement;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.core.format.elem.AbstractNutsElement;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;

class DefaultNutsPrimitiveElement
extends AbstractNutsElement
implements NutsPrimitiveElement {
    public static final String[] DATE_FORMATS = new String[]{"yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.SSSX"};
    private final Object value;

    DefaultNutsPrimitiveElement(NutsElementType type, Object value, NutsSession session) {
        super(type, session);
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public String getString() {
        return this.value == null ? null : this.value.toString();
    }

    public boolean isEmpty() {
        switch (this.type()) {
            case NULL: {
                return true;
            }
            case STRING: {
                return this.toString().isEmpty();
            }
        }
        return false;
    }

    public Number getNumber() {
        if (this.value == null) {
            return 0;
        }
        if (this.value instanceof Boolean) {
            return (Boolean)this.value != false ? 1 : 0;
        }
        if (this.value instanceof Number) {
            return (Number)this.value;
        }
        if (this.value instanceof Date) {
            return ((Date)this.value).getTime();
        }
        if (this.value instanceof Instant) {
            return ((Instant)this.value).toEpochMilli();
        }
        String s = String.valueOf(this.value);
        if (s.indexOf(46) >= 0) {
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException ex) {
                return 0;
            }
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException ex2) {
                return 0;
            }
        }
    }

    public boolean getBoolean() {
        if (this.value == null) {
            return false;
        }
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).doubleValue() != 0.0;
        }
        return NutsUtilStrings.parseBoolean((String)String.valueOf(this.value), (Boolean)false, (Boolean)false);
    }

    @Override
    public boolean isByte() {
        if (this.value == null) {
            return false;
        }
        if (this.value instanceof Number) {
            switch (this.value.getClass().getName()) {
                case "java.lang.Byte": {
                    return true;
                }
            }
        } else if (this.value instanceof String) {
            try {
                Byte.parseByte(this.value.toString());
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean isShort() {
        if (this.value == null) {
            return false;
        }
        if (this.value instanceof Number) {
            switch (this.value.getClass().getName()) {
                case "java.lang.Byte": 
                case "java.lang.Short": {
                    return true;
                }
            }
        } else if (this.value instanceof String) {
            try {
                Short.parseShort(this.value.toString());
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean isInt() {
        if (this.value == null) {
            return false;
        }
        if (this.value instanceof Number) {
            switch (this.value.getClass().getName()) {
                case "java.lang.Byte": 
                case "java.lang.Short": 
                case "java.lang.Integer": {
                    return true;
                }
            }
        } else if (this.value instanceof String) {
            try {
                Integer.parseInt(this.value.toString());
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean isLong() {
        if (this.value == null) {
            return false;
        }
        if (this.value instanceof Number) {
            switch (this.value.getClass().getName()) {
                case "java.lang.Byte": 
                case "java.lang.Short": 
                case "java.lang.Integer": 
                case "java.lang.Long": {
                    return true;
                }
            }
        } else if (this.value instanceof String) {
            try {
                Long.parseLong(this.value.toString());
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean isDouble() {
        if (this.value == null) {
            return false;
        }
        if (this.value instanceof Number) {
            switch (this.value.getClass().getName()) {
                case "java.lang.Byte": 
                case "java.lang.Short": 
                case "java.lang.Integer": 
                case "java.lang.Long": 
                case "java.lang.Float": 
                case "java.lang.Double": {
                    return true;
                }
            }
        } else if (this.value instanceof String) {
            try {
                Double.parseDouble(this.value.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean isFloat() {
        if (this.value == null) {
            return false;
        }
        if (this.value instanceof Number) {
            switch (this.value.getClass().getName()) {
                case "java.lang.Byte": 
                case "java.lang.Short": 
                case "java.lang.Integer": 
                case "java.lang.Long": 
                case "java.lang.Float": {
                    return true;
                }
            }
        } else if (this.value instanceof String) {
            try {
                Float.parseFloat(this.value.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public byte getByte() {
        if (this.value == null) {
            return 0;
        }
        if (this.value instanceof Boolean) {
            return (byte)((Boolean)this.value != false ? 1 : 0);
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).byteValue();
        }
        if (this.value instanceof Date) {
            return (byte)((Date)this.value).getTime();
        }
        String s = String.valueOf(this.value);
        if (s.indexOf(46) >= 0) {
            try {
                return (byte)Double.parseDouble(s);
            }
            catch (NumberFormatException ex) {
                return 0;
            }
        }
        try {
            return Byte.parseByte(s);
        }
        catch (NumberFormatException ex) {
            try {
                return (byte)Long.parseLong(s);
            }
            catch (NumberFormatException ex2) {
                return 0;
            }
        }
    }

    public short getShort() {
        if (this.value == null) {
            return 0;
        }
        if (this.value instanceof Boolean) {
            return (short)((Boolean)this.value != false ? 1 : 0);
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).shortValue();
        }
        if (this.value instanceof Date) {
            return (short)((Date)this.value).getTime();
        }
        String s = String.valueOf(this.value);
        if (s.indexOf(46) >= 0) {
            try {
                return (short)Double.parseDouble(s);
            }
            catch (NumberFormatException ex) {
                return 0;
            }
        }
        try {
            return Short.parseShort(s);
        }
        catch (NumberFormatException ex) {
            try {
                return (short)Long.parseLong(s);
            }
            catch (NumberFormatException ex2) {
                return 0;
            }
        }
    }

    public int getInt() {
        if (this.value == null) {
            return 0;
        }
        if (this.value instanceof Boolean) {
            return (Boolean)this.value != false ? 1 : 0;
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).intValue();
        }
        if (this.value instanceof Date) {
            return (int)((Date)this.value).getTime();
        }
        String s = String.valueOf(this.value);
        if (s.indexOf(46) >= 0) {
            try {
                return (int)Double.parseDouble(s);
            }
            catch (NumberFormatException ex) {
                return 0;
            }
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            try {
                return (int)Long.parseLong(s);
            }
            catch (NumberFormatException ex2) {
                return 0;
            }
        }
    }

    public long getLong() {
        if (this.value == null) {
            return 0L;
        }
        if (this.value instanceof Boolean) {
            return (Boolean)this.value != false ? 1L : 0L;
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).longValue();
        }
        if (this.value instanceof Date) {
            return (int)((Date)this.value).getTime();
        }
        String s = String.valueOf(this.value);
        if (s.indexOf(46) >= 0) {
            try {
                return (long)Double.parseDouble(s);
            }
            catch (NumberFormatException ex) {
                return 0L;
            }
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException ex2) {
                return 0L;
            }
        }
    }

    public double getDouble() {
        if (this.value == null) {
            return 0.0;
        }
        if (this.value instanceof Boolean) {
            return (Boolean)this.value != false ? 1.0 : 0.0;
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).doubleValue();
        }
        if (this.value instanceof Date) {
            return ((Date)this.value).getTime();
        }
        String s = String.valueOf(this.value);
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException ex) {
            return 0.0;
        }
    }

    public float getFloat() {
        if (this.value == null) {
            return 0.0f;
        }
        if (this.value instanceof Boolean) {
            return (Boolean)this.value != false ? 1.0f : 0.0f;
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).floatValue();
        }
        if (this.value instanceof Date) {
            return ((Date)this.value).getTime();
        }
        String s = String.valueOf(this.value);
        try {
            return Float.parseFloat(s);
        }
        catch (NumberFormatException ex) {
            return 0.0f;
        }
    }

    public Instant getInstant() {
        if (this.value == null || this.value instanceof Boolean) {
            return Instant.MIN;
        }
        if (this.value instanceof Number) {
            return Instant.ofEpochMilli(((Number)this.value).longValue());
        }
        if (this.value instanceof Date) {
            return ((Date)this.value).toInstant();
        }
        if (this.value instanceof Instant) {
            return (Instant)this.value;
        }
        String s = String.valueOf(this.value);
        try {
            return DateTimeFormatter.ISO_INSTANT.parse((CharSequence)s, Instant::from);
        }
        catch (Exception exception) {
            for (String f : DATE_FORMATS) {
                try {
                    return new SimpleDateFormat(f).parse(s).toInstant();
                }
                catch (Exception exception2) {
                }
            }
            if (this.isLong()) {
                try {
                    return Instant.ofEpochMilli(this.getLong());
                }
                catch (Exception exception3) {
                    // empty catch block
                }
            }
            return Instant.MIN;
        }
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    public static Instant parseDate(String s) {
        try {
            return DateTimeFormatter.ISO_INSTANT.parse((CharSequence)s, Instant::from);
        }
        catch (Exception exception) {
            for (String f : DATE_FORMATS) {
                try {
                    return new SimpleDateFormat(f).parse(s).toInstant();
                }
                catch (Exception exception2) {
                }
            }
            throw new IllegalArgumentException("Invalid date " + s);
        }
    }

    public String toString() {
        switch (this.type()) {
            case NULL: {
                return "null";
            }
            case STRING: {
                return CoreStringUtils.dblQuote(this.getString());
            }
            case BOOLEAN: {
                return String.valueOf(this.getBoolean());
            }
            case INTEGER: 
            case FLOAT: {
                return String.valueOf(this.getNumber());
            }
            case INSTANT: {
                return CoreStringUtils.dblQuote(this.getInstant().toString());
            }
        }
        return this.getString();
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Objects.hashCode(this.value);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultNutsPrimitiveElement other = (DefaultNutsPrimitiveElement)obj;
        return Objects.equals(this.value, other.value);
    }
}

