/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.elem;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementEntry;
import net.thevpc.nuts.NutsElementFormat;
import net.thevpc.nuts.NutsObjectElement;
import net.thevpc.nuts.NutsObjectElementBuilder;
import net.thevpc.nuts.NutsPrimitiveElement;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.core.format.elem.DefaultNutsElementEntry;
import net.thevpc.nuts.runtime.core.format.elem.DefaultNutsObjectElement;

public class DefaultNutsObjectElementBuilder
implements NutsObjectElementBuilder {
    private final Map<NutsElement, NutsElement> values = new LinkedHashMap<NutsElement, NutsElement>();
    private NutsSession session;

    public DefaultNutsObjectElementBuilder(NutsSession session) {
        if (session == null) {
            throw new NullPointerException();
        }
        this.session = session;
    }

    public Collection<NutsElementEntry> children() {
        return this.values.entrySet().stream().map(x -> new DefaultNutsElementEntry((NutsElement)x.getKey(), (NutsElement)x.getValue())).collect(Collectors.toList());
    }

    public NutsElement get(NutsElement s) {
        return this.values.get(s);
    }

    public NutsElement get(String s) {
        return this.values.get(this._elements().forBoolean(s));
    }

    public int size() {
        return this.values.size();
    }

    public NutsObjectElementBuilder set(String name, NutsElement value) {
        this.values.put((NutsElement)this._elements().forString(name), this.denull(value));
        return this;
    }

    public NutsObjectElementBuilder set(String name, boolean value) {
        return this.set((NutsElement)this._elements().forString(name), (NutsElement)this._elements().forBoolean(value));
    }

    public NutsObjectElementBuilder set(String name, int value) {
        return this.set((NutsElement)this._elements().forString(name), (NutsElement)this._elements().forInt(Integer.valueOf(value)));
    }

    public NutsObjectElementBuilder set(String name, double value) {
        return this.set((NutsElement)this._elements().forString(name), (NutsElement)this._elements().forDouble(Double.valueOf(value)));
    }

    public NutsObjectElementBuilder set(String name, String value) {
        return this.set((NutsElement)this._elements().forString(name), (NutsElement)this._elements().forString(value));
    }

    public NutsObjectElementBuilder remove(String name) {
        NutsPrimitiveElement v = name == null ? this._elements().forNull() : this._elements().forString(name);
        this.values.remove(v);
        return this;
    }

    public NutsObjectElementBuilder add(NutsElement name, NutsElement value) {
        this.values.put(name, this.denull(value));
        return this;
    }

    public NutsObjectElementBuilder set(NutsElement name, NutsElement value) {
        this.values.put(name, this.denull(value));
        return this;
    }

    public NutsObjectElementBuilder set(NutsElement name, boolean value) {
        return this.set(name, (NutsElement)this._elements().forBoolean(value));
    }

    public NutsObjectElementBuilder set(NutsElement name, int value) {
        return this.set(name, (NutsElement)this._elements().forInt(Integer.valueOf(value)));
    }

    public NutsObjectElementBuilder set(NutsElement name, double value) {
        return this.set(name, (NutsElement)this._elements().forDouble(Double.valueOf(value)));
    }

    public NutsObjectElementBuilder set(NutsElement name, String value) {
        return this.set(name, (NutsElement)this._elements().forString(value));
    }

    public NutsObjectElementBuilder remove(NutsElement name) {
        this.values.remove(name);
        return this;
    }

    public NutsObjectElementBuilder clear() {
        this.values.clear();
        return this;
    }

    public NutsObjectElementBuilder set(NutsObjectElement other) {
        this.clear();
        this.add(other);
        return this;
    }

    public NutsObjectElementBuilder set(NutsObjectElementBuilder other) {
        this.clear();
        this.add(other);
        return this;
    }

    public NutsObjectElementBuilder add(NutsObjectElement other) {
        if (other != null) {
            for (NutsElementEntry child : other.children()) {
                this.add(child.getKey(), child.getValue());
            }
        }
        return this;
    }

    public NutsObjectElementBuilder add(NutsObjectElementBuilder other) {
        if (other != null) {
            for (NutsElementEntry child : other.children()) {
                this.add(child.getKey(), child.getValue());
            }
        }
        return this;
    }

    public NutsObjectElementBuilder add(NutsElementEntry entry) {
        if (entry != null) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public NutsObjectElement build() {
        return new DefaultNutsObjectElement(this.values, this.session);
    }

    public String toString() {
        return "{" + this.children().stream().map(x -> x.getKey() + ":" + x.getValue().toString()).collect(Collectors.joining(", ")) + "}";
    }

    private NutsElement denull(NutsElement e) {
        if (e == null) {
            return this._elements().forNull();
        }
        return e;
    }

    private NutsElementFormat _elements() {
        return this.session.getWorkspace().elem().setSession(this.session);
    }
}

