/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsVersionFormat;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.format.DefaultFormatBase;

public class DefaultVersionFormat
extends DefaultFormatBase<NutsVersionFormat>
implements NutsVersionFormat {
    private final Map<String, String> extraProperties = new LinkedHashMap<String, String>();
    private boolean all;
    private NutsVersion version;

    public DefaultVersionFormat(NutsWorkspace ws) {
        super(ws, "version");
    }

    public NutsVersion getVersion() {
        return this.version;
    }

    public NutsVersionFormat setVersion(NutsVersion version) {
        this.version = version;
        return this;
    }

    public boolean isWorkspaceVersion() {
        return this.version == null;
    }

    public boolean configureFirst(NutsCommandLine cmdLine) {
        this.checkSession();
        NutsArgument a = cmdLine.peek();
        if (a == null) {
            return false;
        }
        boolean enabled = a.isEnabled();
        switch (a.getStringKey()) {
            case "-a": 
            case "--all": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.all = val;
                }
                return true;
            }
            case "--add": {
                NutsArgument r = cmdLine.nextString(new String[0]).getArgumentValue();
                if (enabled) {
                    this.all = true;
                    this.extraProperties.put(r.getStringKey(), r.getStringValue());
                }
                return true;
            }
        }
        return this.getSession().configureFirst(cmdLine);
    }

    public NutsVersionFormat addProperty(String key, String value) {
        if (value == null) {
            this.extraProperties.remove(key);
        } else {
            this.extraProperties.put(key, value);
        }
        return this;
    }

    public NutsVersionFormat addProperties(Map<String, String> p) {
        if (p != null) {
            for (Map.Entry<String, String> entry : p.entrySet()) {
                this.addProperty(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    @Override
    public void print(NutsPrintStream out) {
        this.checkSession();
        if (!this.isNtf()) {
            if (this.isWorkspaceVersion()) {
                out.printf("%s/%s", new Object[]{this.getSession().getWorkspace().getApiVersion(), this.getSession().getWorkspace().getRuntimeId().getVersion()});
            } else {
                out.printf("%s", new Object[]{this.getVersion()});
            }
        } else if (this.isWorkspaceVersion()) {
            this.getSession().getWorkspace().formats().object(this.buildProps()).print(out);
        } else {
            out.print((NutsString)this.getSession().getWorkspace().text().forStyled(this.getVersion().toString(), NutsTextStyle.version()));
        }
    }

    public Map<String, String> buildProps() {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        TreeSet<Object> extraKeys = new TreeSet();
        if (this.extraProperties != null) {
            extraKeys = new TreeSet<String>(this.extraProperties.keySet());
        }
        NutsWorkspace ws = this.getSession().getWorkspace();
        props.put("nuts-api-version", ws.getApiVersion().toString());
        props.put("nuts-runtime-version", ws.getRuntimeId().getVersion().toString());
        if (this.all) {
            props.put("java-version", System.getProperty("java.version"));
            props.put("os-version", ws.env().getOs().getVersion().toString());
        }
        for (String string : extraKeys) {
            props.put(string, this.extraProperties.get(string));
        }
        return props;
    }
}

