/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.thevpc.nuts.NutsFormat;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsMemoryPrintStream;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSessionTerminal;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.format.DefaultFormatBase0;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;

public abstract class DefaultFormatBase<T extends NutsFormat>
extends DefaultFormatBase0<T>
implements NutsFormat {
    public DefaultFormatBase(NutsWorkspace ws, String name) {
        super(ws, name);
    }

    @Override
    public NutsPrintStream getValidPrintStream(NutsPrintStream out) {
        this.checkSession();
        if (out == null) {
            out = this.getSession().getTerminal().getOut();
        }
        return out;
    }

    @Override
    public NutsPrintStream getValidPrintStream() {
        return this.getValidPrintStream(null);
    }

    public NutsString format() {
        this.checkSession();
        NutsMemoryPrintStream out = this.getSession().getWorkspace().io().createMemoryPrintStream();
        this.print((NutsPrintStream)out);
        return this.isNtf() ? this.getSession().getWorkspace().text().parse(out.toString()) : this.getSession().getWorkspace().text().forPlain(out.toString());
    }

    public void print() {
        this.checkSession();
        this.print(this.getSession().getTerminal());
    }

    public void println() {
        this.checkSession();
        this.println(this.getSession().getTerminal());
    }

    public abstract void print(NutsPrintStream var1);

    public void print(Writer out) {
        this.checkSession();
        if (out == null) {
            NutsPrintStream pout = this.getValidPrintStream();
            this.print(pout);
            pout.flush();
        } else {
            NutsPrintStream pout = this.getSession().getWorkspace().io().createPrintStream(out);
            this.print(pout);
            pout.flush();
        }
    }

    public void print(OutputStream out) {
        this.checkSession();
        NutsPrintStream p = out == null ? this.getValidPrintStream() : this.getSession().getWorkspace().io().createPrintStream(out);
        this.print(p);
        p.flush();
    }

    public void print(Path path) {
        this.checkSession();
        CoreIOUtils.mkdirs(path.getParent());
        try (BufferedWriter w = Files.newBufferedWriter(path, new OpenOption[0]);){
            this.print(w);
        }
        catch (IOException ex) {
            throw new NutsIOException(this.getSession(), (Throwable)ex);
        }
    }

    public void print(File file) {
        this.print(file.toPath());
    }

    public void print(NutsSessionTerminal terminal) {
        this.checkSession();
        this.print(terminal == null ? this.getSession().getTerminal().out() : terminal.out());
    }

    public void println(Writer w) {
        this.checkSession();
        if (w == null) {
            NutsPrintStream pout = this.getValidPrintStream();
            this.println(pout);
            pout.flush();
        } else {
            NutsPrintStream pout = this.getSession().getWorkspace().io().createPrintStream(w);
            this.println(pout);
            pout.flush();
        }
    }

    public void println(OutputStream out) {
        this.checkSession();
        if (out == null) {
            NutsPrintStream pout = this.getValidPrintStream();
            this.println(pout);
            pout.flush();
        } else {
            NutsPrintStream pout = this.getSession().getWorkspace().io().createPrintStream(out);
            this.println(pout);
            pout.flush();
        }
    }

    public void println(NutsPrintStream out) {
        this.checkSession();
        NutsPrintStream p = this.getValidPrintStream(out);
        this.print(out);
        p.println();
        p.flush();
    }

    public void println(Path path) {
        this.checkSession();
        try (BufferedWriter w = Files.newBufferedWriter(path, new OpenOption[0]);){
            this.println(w);
        }
        catch (IOException ex) {
            throw new NutsIOException(this.getSession(), (Throwable)ex);
        }
    }

    public void println(NutsSessionTerminal terminal) {
        this.checkSession();
        this.println(terminal == null ? this.getSession().getTerminal().out() : terminal.out());
    }

    public void println(File file) {
        this.println(file.toPath());
    }

    public String toString() {
        return this.format().toString();
    }
}

