/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsConfirmationMode;
import net.thevpc.nuts.NutsExecutionType;
import net.thevpc.nuts.NutsFetchStrategy;
import net.thevpc.nuts.NutsLogConfig;
import net.thevpc.nuts.NutsOpenMode;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsRunAs;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsStoreLocationStrategy;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsUnsupportedEnumException;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.NutsWorkspaceOptionsFormat;
import net.thevpc.nuts.boot.NutsBootVersion;
import net.thevpc.nuts.runtime.core.model.CoreNutsWorkspaceOptions;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;

public class CoreNutsWorkspaceOptionsFormat
implements NutsWorkspaceOptionsFormat {
    private static final long serialVersionUID = 1L;
    private final NutsSession session;
    private final NutsWorkspaceOptions options;
    private boolean exportedOptions;
    private boolean runtimeOptions;
    private boolean createOptions;
    private boolean shortOptions;
    private boolean singleArgOptions;
    private boolean omitDefaults;
    private String apiVersion;
    private NutsVersion apiVersionObj;

    public CoreNutsWorkspaceOptionsFormat(NutsSession session, NutsWorkspaceOptions options) {
        this.options = options;
        this.session = session;
    }

    public boolean isInit() {
        return this.createOptions;
    }

    public boolean isRuntime() {
        return this.runtimeOptions;
    }

    public boolean isExported() {
        return this.exportedOptions;
    }

    public NutsWorkspaceOptionsFormat setExported(boolean e) {
        this.exportedOptions = true;
        return this;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public NutsWorkspaceOptionsFormat setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        this.apiVersionObj = null;
        return this;
    }

    public NutsWorkspaceOptionsFormat setRuntime(boolean e) {
        this.runtimeOptions = true;
        return this;
    }

    public NutsWorkspaceOptionsFormat setInit(boolean e) {
        this.createOptions = true;
        return this;
    }

    public NutsCommandLine getBootCommandLine() {
        NutsVersion apiVersionObj = this.getApiVersionObj();
        ArrayList<String> arguments = new ArrayList<String>();
        if (this.exportedOptions || this.isImplicitAll()) {
            NutsLogConfig logConfig;
            this.fillOption("--boot-runtime", null, this.options.getRuntimeId(), arguments, false);
            this.fillOption("--java", "-j", this.options.getJavaCommand(), arguments, false);
            this.fillOption("--java-options", "-O", this.options.getJavaOptions(), arguments, false);
            String wsString = this.options.getWorkspace();
            if (NutsUtilStrings.isBlank((CharSequence)wsString)) {
                wsString = "";
            } else if (wsString.contains("/") || wsString.contains("\\")) {
                wsString = CoreIOUtils.getAbsolutePath(wsString);
            }
            this.fillOption("--workspace", "-w", wsString, arguments, false);
            this.fillOption("--user", "-u", this.options.getUserName(), arguments, false);
            this.fillOption("--password", "-p", this.options.getCredentials(), arguments, false);
            this.fillOption("--boot-version", "-V", this.options.getApiVersion(), arguments, false);
            if (!this.omitDefaults || this.options.getTerminalMode() != null) {
                this.fillOption("--color", "-c", (Enum)this.options.getTerminalMode(), NutsTerminalMode.class, arguments, true);
            }
            if ((logConfig = this.options.getLogConfig()) != null) {
                if (logConfig.getLogTermLevel() != null && logConfig.getLogTermLevel() == logConfig.getLogFileLevel()) {
                    this.fillOption("--log-" + logConfig.getLogFileLevel().toString().toLowerCase(), null, true, false, arguments, false);
                } else {
                    if (logConfig.getLogTermLevel() != null) {
                        this.fillOption("--log-term-" + logConfig.getLogTermLevel().toString().toLowerCase(), null, true, false, arguments, false);
                    }
                    if (logConfig.getLogFileLevel() != null) {
                        this.fillOption("--log-file-" + logConfig.getLogFileLevel().toString().toLowerCase(), null, true, false, arguments, false);
                    }
                }
                if (logConfig.getLogFileCount() > 0) {
                    this.fillOption("--log-file-count", null, String.valueOf(logConfig.getLogFileCount()), arguments, false);
                }
                this.fillOption("--log-file-size", null, logConfig.getLogFileSize(), arguments, false);
                this.fillOption("--log-file-base", null, logConfig.getLogFileBase(), arguments, false);
                this.fillOption("--log-file-name", null, logConfig.getLogFileName(), arguments, false);
                this.fillOption("--log-inherited", null, logConfig.isLogInherited(), false, arguments, false);
            }
            this.fillOption("--exclude-extension", "-X", this.options.getExcludedExtensions(), ";", arguments, false);
            if (apiVersionObj == null || apiVersionObj.compareTo("0.8.1") >= 0) {
                this.fillOption("--repositories", "-r", this.options.getRepositories(), ";", arguments, false);
            } else {
                this.fillOption("--repository", "-r", this.options.getRepositories(), ";", arguments, false);
            }
            this.fillOption("--global", "-g", this.options.isGlobal(), false, arguments, false);
            this.fillOption("--gui", null, this.options.isGui(), false, arguments, false);
            this.fillOption("--read-only", "-R", this.options.isReadOnly(), false, arguments, false);
            this.fillOption("--trace", "-t", this.options.isTrace(), true, arguments, false);
            this.fillOption("--progress", "-P", this.options.getProgressOptions(), arguments, false);
            this.fillOption("--skip-companions", "-k", this.options.isSkipCompanions(), false, arguments, false);
            this.fillOption("--skip-welcome", "-K", this.options.isSkipWelcome(), false, arguments, false);
            this.fillOption("--out-line-prefix", null, this.options.isSkipWelcome(), false, arguments, false);
            this.fillOption("--skip-boot", "-Q", this.options.isSkipBoot(), false, arguments, false);
            this.fillOption("--cached", null, this.options.isCached(), true, arguments, false);
            this.fillOption("--indexed", null, this.options.isIndexed(), true, arguments, false);
            this.fillOption("--transitive", null, this.options.isTransitive(), true, arguments, false);
            if (apiVersionObj == null || apiVersionObj.compareTo("0.8.1") >= 0) {
                this.fillOption("--bot", "-B", this.options.isBot(), false, arguments, false);
            }
            if (this.options.getFetchStrategy() != null && this.options.getFetchStrategy() != NutsFetchStrategy.ONLINE) {
                this.fillOption("--fetch", "-f", (Enum)this.options.getFetchStrategy(), NutsFetchStrategy.class, arguments, false);
            }
            this.fillOption((Enum)this.options.getConfirm(), arguments, false);
            this.fillOption((Enum)this.options.getOutputFormat(), arguments, false);
            String[] stringArray = this.options.getOutputFormatOptions();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                this.fillOption("--output-format-option", "-T", string, arguments, false);
            }
            if (apiVersionObj == null || apiVersionObj.compareTo("0.8.0") >= 0) {
                this.fillOption("--expire", "-N", this.options.getExpireTime() == null ? null : this.options.getExpireTime().toString(), arguments, false);
                if (this.options.getOutLinePrefix() != null && Objects.equals(this.options.getOutLinePrefix(), this.options.getErrLinePrefix()) && this.options.getOutLinePrefix().length() > 0) {
                    this.fillOption("--line-prefix", null, this.options.getOutLinePrefix(), arguments, false);
                } else {
                    if (this.options.getOutLinePrefix() != null && this.options.getOutLinePrefix().length() > 0) {
                        this.fillOption("--out-line-prefix", null, this.options.getOutLinePrefix(), arguments, false);
                    }
                    if (this.options.getErrLinePrefix() != null && this.options.getErrLinePrefix().length() > 0) {
                        this.fillOption("--err-line-prefix", null, this.options.getErrLinePrefix(), arguments, false);
                    }
                }
            }
            if (apiVersionObj == null || apiVersionObj.compareTo("0.8.1") >= 0) {
                this.fillOption("--theme", null, this.options.getTheme(), arguments, false);
            }
        }
        if (this.createOptions || this.isImplicitAll()) {
            this.fillOption("--name", null, NutsUtilStrings.trim((String)this.options.getName()), arguments, false);
            this.fillOption("--archetype", "-A", this.options.getArchetype(), arguments, false);
            this.fillOption("--store-layout", null, (Enum)this.options.getStoreLocationLayout(), NutsOsFamily.class, arguments, false);
            this.fillOption("--store-strategy", null, (Enum)this.options.getStoreLocationStrategy(), NutsStoreLocationStrategy.class, arguments, false);
            this.fillOption("--repo-store-strategy", null, (Enum)this.options.getRepositoryStoreLocationStrategy(), NutsStoreLocationStrategy.class, arguments, false);
            Map storeLocations = this.options.getStoreLocations();
            for (NutsStoreLocation location : NutsStoreLocation.values()) {
                String string = (String)storeLocations.get(location.id());
                if (NutsUtilStrings.isBlank((CharSequence)string)) continue;
                this.fillOption("--" + location.id() + "-location", null, string, arguments, false);
            }
            Map homeLocations = this.options.getHomeLocations();
            if (homeLocations != null) {
                for (NutsStoreLocation nutsStoreLocation : NutsStoreLocation.values()) {
                    String s = (String)homeLocations.get(CoreNutsWorkspaceOptions.createHomeLocationKey(null, nutsStoreLocation));
                    if (NutsUtilStrings.isBlank((CharSequence)s)) continue;
                    this.fillOption("--system-" + nutsStoreLocation.id() + "-home", null, s, arguments, false);
                }
                for (NutsStoreLocation nutsStoreLocation : NutsOsFamily.values()) {
                    for (NutsStoreLocation location : NutsStoreLocation.values()) {
                        String s = (String)homeLocations.get(CoreNutsWorkspaceOptions.createHomeLocationKey((NutsOsFamily)nutsStoreLocation, location));
                        if (NutsUtilStrings.isBlank((CharSequence)s)) continue;
                        this.fillOption("--" + nutsStoreLocation.id() + "-" + location.id() + "-home", null, s, arguments, false);
                    }
                }
            }
            if ((apiVersionObj == null || apiVersionObj.compareTo("0.8.0") >= 0) && this.options.getSwitchWorkspace() != null) {
                this.fillOption("--switch", null, this.options.getSwitchWorkspace(), false, arguments, false);
            }
        }
        if (this.runtimeOptions || this.isImplicitAll()) {
            if (!this.omitDefaults || this.options.getOpenMode() != null && this.options.getOpenMode() != NutsOpenMode.OPEN_OR_CREATE) {
                this.fillOption((Enum)this.options.getOpenMode(), arguments, false);
            }
            this.fillOption((Enum)this.options.getExecutionType(), arguments, false);
            this.fillOption(this.options.getRunAs(), arguments);
            this.fillOption("--reset", "-Z", this.options.isReset(), false, arguments, false);
            this.fillOption("--recover", "-z", this.options.isRecover(), false, arguments, false);
            this.fillOption("--dry", "-D", this.options.isDry(), false, arguments, false);
            if (apiVersionObj == null || apiVersionObj.compareTo("0.8.1") >= 0) {
                if (this.options.getProperties() != null) {
                    for (String property : this.options.getProperties()) {
                        arguments.add("---" + property);
                    }
                }
                this.fillOption("--locale", "-L", this.options.getLocale(), arguments, false);
            }
            if (!this.omitDefaults || this.options.getExecutorOptions().length > 0) {
                arguments.add(this.selectOptionName("--exec", "-e"));
            }
            arguments.addAll(Arrays.asList(this.options.getExecutorOptions()));
            arguments.addAll(Arrays.asList(this.options.getApplicationArguments()));
        }
        return this.session.getWorkspace().commandLine().create(arguments.toArray(new String[0]));
    }

    public NutsWorkspaceOptionsFormat setCompact(boolean compact) {
        if (compact) {
            this.shortOptions = true;
            this.singleArgOptions = true;
            this.omitDefaults = true;
        } else {
            this.shortOptions = false;
            this.singleArgOptions = false;
            this.omitDefaults = false;
        }
        return this;
    }

    private boolean isImplicitAll() {
        return !this.exportedOptions && !this.runtimeOptions && !this.createOptions;
    }

    private void fillOption(String longName, String shortName, String[] values, String sep, List<String> arguments, boolean forceSingle) {
        if (values != null && values.length > 0) {
            this.fillOption0(this.selectOptionName(longName, shortName), String.join((CharSequence)sep, values), arguments, forceSingle);
        }
    }

    private void fillOption(String longName, String shortName, boolean value, boolean defaultValue, List<String> arguments, boolean forceSingle) {
        if (defaultValue) {
            if (!value) {
                if (this.shortOptions && shortName != null) {
                    arguments.add("-!" + shortName.substring(1));
                } else {
                    arguments.add("--!" + longName.substring(2));
                }
            }
        } else if (value) {
            arguments.add(this.selectOptionName(longName, shortName));
        }
    }

    private void fillOption(String longName, String shortName, char[] value, List<String> arguments, boolean forceSingle) {
        if (value != null && new String(value).isEmpty()) {
            this.fillOption0(this.selectOptionName(longName, shortName), new String(value), arguments, forceSingle);
        }
    }

    private void fillOption(String longName, String shortName, String value, List<String> arguments, boolean forceSingle) {
        if (!NutsUtilStrings.isBlank((CharSequence)value)) {
            this.fillOption0(this.selectOptionName(longName, shortName), value, arguments, forceSingle);
        }
    }

    private void fillOption(String longName, String shortName, int value, List<String> arguments, boolean forceSingle) {
        if (value > 0) {
            this.fillOption0(this.selectOptionName(longName, shortName), String.valueOf(value), arguments, forceSingle);
        }
    }

    private void fillOption(String longName, String shortName, Enum value, Class enumType, List<String> arguments, boolean forceSingle) {
        if (this.tryFillOptionShort(value, arguments, forceSingle)) {
            return;
        }
        if (value != null) {
            if (this.shortOptions) {
                if (value instanceof NutsOsFamily) {
                    switch ((NutsOsFamily)value) {
                        case LINUX: {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("l", "linux"), arguments, forceSingle);
                            return;
                        }
                        case WINDOWS: {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("w", "windows"), arguments, forceSingle);
                            return;
                        }
                        case MACOS: {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("m", "macos"), arguments, forceSingle);
                            return;
                        }
                        case UNIX: {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("u", "unix"), arguments, forceSingle);
                            return;
                        }
                        case UNKNOWN: {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("x", "unknown"), arguments, forceSingle);
                            return;
                        }
                    }
                } else if (value instanceof NutsStoreLocationStrategy) {
                    switch ((NutsStoreLocationStrategy)value) {
                        case EXPLODED: {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("e", "exploded"), arguments, forceSingle);
                            return;
                        }
                        case STANDALONE: {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("s", "standalone"), arguments, forceSingle);
                            return;
                        }
                    }
                } else if (value instanceof NutsTerminalMode) {
                    switch ((NutsTerminalMode)value) {
                        case FILTERED: {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("n", "no"), arguments, forceSingle);
                            return;
                        }
                        case INHERITED: {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("h", "inherited"), arguments, forceSingle);
                            return;
                        }
                        case FORMATTED: {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("y", "yes"), arguments, forceSingle);
                            return;
                        }
                    }
                }
            }
            this.fillOption0(this.selectOptionName(longName, shortName), value.toString().toLowerCase(), arguments, forceSingle);
        } else if (enumType.equals(NutsTerminalMode.class)) {
            this.fillOption0(this.selectOptionName(longName, shortName), this.shortOptions ? "s" : "system", arguments, forceSingle);
        }
    }

    private boolean fillOption(NutsRunAs value, List<String> arguments) {
        switch (value.getMode()) {
            case CURRENT_USER: {
                if (!NutsUtilStrings.isBlank((CharSequence)this.apiVersion) && NutsBootVersion.parse((String)this.apiVersion).compareTo(NutsBootVersion.parse((String)"0.8.1")) < 0) {
                    arguments.add("--user-cmd");
                } else if (!this.omitDefaults) {
                    arguments.add("--current-user");
                }
                return true;
            }
            case ROOT: {
                if (!NutsUtilStrings.isBlank((CharSequence)this.apiVersion) && NutsBootVersion.parse((String)this.apiVersion).compareTo(NutsBootVersion.parse((String)"0.8.1")) < 0) {
                    arguments.add("--root-cmd");
                } else {
                    arguments.add("--as-root");
                }
                return true;
            }
            case SUDO: {
                if (NutsUtilStrings.isBlank((CharSequence)this.apiVersion) || NutsBootVersion.parse((String)this.apiVersion).compareTo(NutsBootVersion.parse((String)"0.8.1")) >= 0) {
                    arguments.add("--sudo");
                }
                return true;
            }
            case USER: {
                if (NutsUtilStrings.isBlank((CharSequence)this.apiVersion) || NutsBootVersion.parse((String)this.apiVersion).compareTo(NutsBootVersion.parse((String)"0.8.1")) >= 0) {
                    arguments.add("--run-as=" + value.getUser());
                }
                return true;
            }
        }
        throw new NutsUnsupportedEnumException(this.session, (Enum)value.getMode());
    }

    private boolean tryFillOptionShort(Enum value, List<String> arguments, boolean forceSingle) {
        if (value != null && this.shortOptions) {
            if (value instanceof NutsOpenMode) {
                switch ((NutsOpenMode)value) {
                    case OPEN_OR_ERROR: {
                        this.fillOption0("-o", "r", arguments, forceSingle);
                        return true;
                    }
                    case CREATE_OR_ERROR: {
                        this.fillOption0("-o", "w", arguments, forceSingle);
                        return true;
                    }
                    case OPEN_OR_CREATE: {
                        if (!this.omitDefaults) {
                            this.fillOption0("-o", "rw", arguments, forceSingle);
                        }
                        return true;
                    }
                    case OPEN_OR_NULL: {
                        this.fillOption0("-o", "on", arguments, forceSingle);
                        return true;
                    }
                }
            }
            if (value instanceof NutsExecutionType) {
                switch ((NutsExecutionType)value) {
                    case SYSTEM: {
                        if (!NutsUtilStrings.isBlank((CharSequence)this.apiVersion) && NutsBootVersion.parse((String)this.apiVersion).compareTo(NutsBootVersion.parse((String)"0.8.1")) < 0) {
                            arguments.add("--user-cmd");
                        } else {
                            arguments.add("--system");
                        }
                        return true;
                    }
                    case EMBEDDED: {
                        arguments.add("-b");
                        return true;
                    }
                    case SPAWN: {
                        if (!this.omitDefaults) {
                            arguments.add("-x");
                        }
                        return true;
                    }
                    case OPEN: {
                        return true;
                    }
                }
            }
            if (value instanceof NutsConfirmationMode) {
                switch ((NutsConfirmationMode)value) {
                    case YES: {
                        arguments.add("-y");
                        return true;
                    }
                    case NO: {
                        arguments.add("-n");
                        return true;
                    }
                    case ASK: {
                        if (this.omitDefaults) break;
                        arguments.add("--ask");
                        return true;
                    }
                }
            }
            if (value instanceof NutsTerminalMode) {
                switch ((NutsTerminalMode)value) {
                    case FILTERED: {
                        arguments.add("-C");
                        return true;
                    }
                    case FORMATTED: {
                        arguments.add("-c");
                        return true;
                    }
                    case INHERITED: {
                        arguments.add("-c=h");
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void fillOption(Enum value, List<String> arguments, boolean forceSingle) {
        if (value != null) {
            if (this.tryFillOptionShort(value, arguments, forceSingle)) {
                return;
            }
            arguments.add("--" + value.toString().toLowerCase().replace('_', '-'));
        }
    }

    private String selectOptionVal(String shortName, String longName) {
        if (this.shortOptions) {
            return shortName;
        }
        return longName;
    }

    private String selectOptionName(String longName, String shortName) {
        if (this.shortOptions && shortName != null) {
            return shortName;
        }
        return longName;
    }

    private void fillOption0(String name, String value, List<String> arguments, boolean forceSingle) {
        if (this.singleArgOptions || forceSingle) {
            arguments.add(name + "=" + value);
        } else {
            arguments.add(name);
            arguments.add(value);
        }
    }

    public int hashCode() {
        return Objects.hash(this.exportedOptions, this.runtimeOptions, this.createOptions, this.shortOptions, this.singleArgOptions, this.omitDefaults, this.options);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreNutsWorkspaceOptionsFormat that = (CoreNutsWorkspaceOptionsFormat)o;
        return this.exportedOptions == that.exportedOptions && this.runtimeOptions == that.runtimeOptions && this.createOptions == that.createOptions && this.shortOptions == that.shortOptions && this.singleArgOptions == that.singleArgOptions && this.omitDefaults == that.omitDefaults && Objects.equals(this.apiVersion, that.apiVersion) && Objects.equals(this.options, that.options);
    }

    public String toString() {
        return this.getBootCommandLine().toString();
    }

    public NutsVersion getApiVersionObj() {
        if (this.apiVersionObj == null && this.apiVersion != null) {
            this.apiVersionObj = this.session.getWorkspace().version().parser().parse(this.apiVersion);
        }
        return this.apiVersionObj;
    }
}

