/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters.version;

import java.util.List;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersionFilter;
import net.thevpc.nuts.NutsVersionFilterManager;
import net.thevpc.nuts.runtime.core.filters.DefaultNutsFilterModel;
import net.thevpc.nuts.runtime.core.filters.InternalNutsTypedFilters;
import net.thevpc.nuts.runtime.core.filters.version.DefaultNutsVersionFilter;
import net.thevpc.nuts.runtime.core.filters.version.NutsVersionFilterAnd;
import net.thevpc.nuts.runtime.core.filters.version.NutsVersionFilterFalse;
import net.thevpc.nuts.runtime.core.filters.version.NutsVersionFilterNone;
import net.thevpc.nuts.runtime.core.filters.version.NutsVersionFilterOr;
import net.thevpc.nuts.runtime.core.filters.version.NutsVersionFilterParser;
import net.thevpc.nuts.runtime.core.filters.version.NutsVersionFilterTrue;
import net.thevpc.nuts.runtime.core.filters.version.NutsVersionJavascriptFilter;

public class InternalNutsVersionFilterManager
extends InternalNutsTypedFilters<NutsVersionFilter>
implements NutsVersionFilterManager {
    public InternalNutsVersionFilterManager(DefaultNutsFilterModel model) {
        super(model, NutsVersionFilter.class);
    }

    public NutsVersionFilterManager setSession(NutsSession session) {
        super.setSession(session);
        return this;
    }

    public NutsVersionFilter byValue(String version) {
        this.checkSession();
        return DefaultNutsVersionFilter.parse(version, this.getSession());
    }

    public NutsVersionFilter always() {
        this.checkSession();
        return new NutsVersionFilterTrue(this.getSession());
    }

    public NutsVersionFilter never() {
        this.checkSession();
        return new NutsVersionFilterFalse(this.getSession());
    }

    public NutsVersionFilter not(NutsFilter other) {
        this.checkSession();
        return new NutsVersionFilterNone(this.getSession(), (NutsVersionFilter)other);
    }

    public NutsVersionFilter byExpression(String expression) {
        this.checkSession();
        if (NutsUtilStrings.isBlank((CharSequence)expression)) {
            return this.always();
        }
        return NutsVersionJavascriptFilter.valueOf(expression, this.getSession());
    }

    public NutsVersionFilter as(NutsFilter a) {
        this.checkSession();
        if (a instanceof NutsVersionFilter) {
            return (NutsVersionFilter)a;
        }
        return null;
    }

    public NutsVersionFilter from(NutsFilter a) {
        this.checkSession();
        if (a == null) {
            return null;
        }
        NutsVersionFilter t = this.as(a);
        if (t == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"not a VersionFilter", (Object[])new Object[0]));
        }
        return t;
    }

    public NutsVersionFilter all(NutsFilter ... others) {
        this.checkSession();
        List<NutsVersionFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        if (all.size() == 1) {
            return (NutsVersionFilter)all.get(0);
        }
        return new NutsVersionFilterAnd(this.getSession(), all.toArray(new NutsVersionFilter[0]));
    }

    public NutsVersionFilter any(NutsFilter ... others) {
        this.checkSession();
        List<NutsVersionFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        if (all.size() == 1) {
            return (NutsVersionFilter)all.get(0);
        }
        return new NutsVersionFilterOr(this.getSession(), all.toArray(new NutsVersionFilter[0]));
    }

    public NutsVersionFilter none(NutsFilter ... others) {
        this.checkSession();
        List<NutsVersionFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        return new NutsVersionFilterNone(this.getSession(), all.toArray(new NutsVersionFilter[0]));
    }

    public NutsVersionFilter parse(String expression) {
        this.checkSession();
        return (NutsVersionFilter)new NutsVersionFilterParser(expression, this.getSession()).parse();
    }
}

