/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters.repository;

import java.util.Arrays;
import java.util.List;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsRepositoryFilter;
import net.thevpc.nuts.NutsRepositoryFilterManager;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.core.filters.DefaultNutsFilterModel;
import net.thevpc.nuts.runtime.core.filters.InternalNutsTypedFilters;
import net.thevpc.nuts.runtime.core.filters.repository.DefaultNutsRepositoryFilter;
import net.thevpc.nuts.runtime.core.filters.repository.NutsRepositoryFilterAnd;
import net.thevpc.nuts.runtime.core.filters.repository.NutsRepositoryFilterFalse;
import net.thevpc.nuts.runtime.core.filters.repository.NutsRepositoryFilterNone;
import net.thevpc.nuts.runtime.core.filters.repository.NutsRepositoryFilterOr;
import net.thevpc.nuts.runtime.core.filters.repository.NutsRepositoryFilterParser;
import net.thevpc.nuts.runtime.core.filters.repository.NutsRepositoryFilterTrue;

public class InternalNutsRepositoryFilterManager
extends InternalNutsTypedFilters<NutsRepositoryFilter>
implements NutsRepositoryFilterManager {
    public InternalNutsRepositoryFilterManager(DefaultNutsFilterModel model) {
        super(model, NutsRepositoryFilter.class);
    }

    @Override
    public InternalNutsRepositoryFilterManager setSession(NutsSession session) {
        super.setSession(session);
        return this;
    }

    public NutsRepositoryFilter always() {
        this.checkSession();
        return new NutsRepositoryFilterTrue(this.getSession());
    }

    public NutsRepositoryFilter never() {
        this.checkSession();
        return new NutsRepositoryFilterFalse(this.getSession());
    }

    public NutsRepositoryFilter not(NutsFilter other) {
        this.checkSession();
        return new NutsRepositoryFilterNone(this.getSession(), (NutsRepositoryFilter)other);
    }

    public NutsRepositoryFilter installedRepo() {
        this.checkSession();
        return new DefaultNutsRepositoryFilter(this.getSession(), Arrays.asList("<main>"));
    }

    public NutsRepositoryFilter byName(String[] names) {
        this.checkSession();
        if (names == null || names.length == 0) {
            return this.always();
        }
        return new DefaultNutsRepositoryFilter(this.getSession(), Arrays.asList(names));
    }

    public NutsRepositoryFilter byUuid(String ... uuids) {
        this.checkSession();
        if (uuids == null || uuids.length == 0) {
            return this.always();
        }
        return new DefaultNutsRepositoryFilter(this.getSession(), Arrays.asList(uuids));
    }

    public NutsRepositoryFilter as(NutsFilter a) {
        if (a instanceof NutsRepositoryFilter) {
            return (NutsRepositoryFilter)a;
        }
        return null;
    }

    public NutsRepositoryFilter from(NutsFilter a) {
        this.checkSession();
        if (a == null) {
            return null;
        }
        NutsRepositoryFilter t = this.as(a);
        if (t == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"not a RepositoryFilter", (Object[])new Object[0]));
        }
        return t;
    }

    public NutsRepositoryFilter all(NutsFilter ... others) {
        this.checkSession();
        List<NutsRepositoryFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        if (all.size() == 1) {
            return (NutsRepositoryFilter)all.get(0);
        }
        return new NutsRepositoryFilterAnd(this.getSession(), all.toArray(new NutsRepositoryFilter[0]));
    }

    public NutsRepositoryFilter any(NutsFilter ... others) {
        this.checkSession();
        List<NutsRepositoryFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        if (all.size() == 1) {
            return (NutsRepositoryFilter)all.get(0);
        }
        return new NutsRepositoryFilterOr(this.getSession(), all.toArray(new NutsRepositoryFilter[0]));
    }

    public NutsRepositoryFilter none(NutsFilter ... others) {
        this.checkSession();
        List<NutsRepositoryFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        return new NutsRepositoryFilterNone(this.getSession(), all.toArray(new NutsRepositoryFilter[0]));
    }

    public NutsRepositoryFilter parse(String expression) {
        this.checkSession();
        return (NutsRepositoryFilter)new NutsRepositoryFilterParser(expression, this.getSession()).parse();
    }
}

