/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters.repository;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryFilter;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.bundles.string.GlobUtils;
import net.thevpc.nuts.runtime.core.filters.repository.AbstractRepositoryFilter;

public class DefaultNutsRepositoryFilter
extends AbstractRepositoryFilter {
    private final Set<String> exactRepos = new HashSet<String>();
    private final Set<Pattern> wildcardRepos = new HashSet<Pattern>();

    public DefaultNutsRepositoryFilter(NutsSession ws, Collection<String> exactRepos) {
        super(ws, NutsFilterOp.CUSTOM);
        for (String repo : exactRepos) {
            if (NutsUtilStrings.isBlank((CharSequence)repo)) continue;
            if (repo.indexOf(42) > 0) {
                this.wildcardRepos.add(GlobUtils.ofExact(repo));
                continue;
            }
            if (repo.length() > 2 && repo.startsWith("/") && repo.endsWith("/")) {
                this.wildcardRepos.add(Pattern.compile(repo.substring(1, repo.length() - 1)));
                continue;
            }
            this.exactRepos.add(repo);
        }
    }

    public boolean acceptRepository(NutsRepository repository) {
        if (this.exactRepos.isEmpty() && this.wildcardRepos.isEmpty()) {
            return true;
        }
        if (this.exactRepos.contains(repository.getUuid()) || this.exactRepos.contains(repository.getName())) {
            return true;
        }
        for (Pattern wildcardRepo : this.wildcardRepos) {
            if (!wildcardRepo.matcher(repository.getName()).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public NutsRepositoryFilter simplify() {
        if (this.exactRepos.isEmpty() && this.wildcardRepos.isEmpty()) {
            return (NutsRepositoryFilter)this.getWorkspace().repos().filter().always();
        }
        return this;
    }

    public String toString() {
        return "DefaultNutsRepositoryFilter{repos=" + this.exactRepos + " ; " + this.wildcardRepos + '}';
    }

    public int hashCode() {
        int hash = this.getClass().getName().hashCode();
        hash = 41 * hash + Objects.hashCode(this.exactRepos);
        hash = 41 * hash + Objects.hashCode(this.wildcardRepos);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultNutsRepositoryFilter other = (DefaultNutsRepositoryFilter)obj;
        if (!Objects.equals(this.exactRepos, other.exactRepos)) {
            return false;
        }
        return Objects.equals(this.wildcardRepos, other.wildcardRepos);
    }
}

