/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters.id;

import java.util.Arrays;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.core.filters.descriptor.AbstractDescriptorFilter;

public class NutsLockedIdExtensionFilter
extends AbstractDescriptorFilter {
    private NutsId[] lockedIds;

    public NutsLockedIdExtensionFilter(NutsSession ws, NutsId[] lockedIds) {
        super(ws, NutsFilterOp.CUSTOM);
        this.lockedIds = lockedIds;
    }

    public boolean acceptId(NutsId id, NutsSession session) {
        for (NutsId nutsId : this.lockedIds) {
            if (!nutsId.getShortNameId().equalsShortName(id.getShortNameId())) continue;
            return id.getVersion().filter().acceptVersion(nutsId.getVersion(), session);
        }
        return true;
    }

    public boolean acceptDescriptor(NutsDescriptor other, NutsSession session) {
        if (!this.acceptId(other.getId(), session)) {
            return false;
        }
        for (NutsDependency dependency : other.getDependencies()) {
            if (this.acceptId(dependency.toId(), session)) continue;
            return false;
        }
        return true;
    }

    @Override
    public NutsDescriptorFilter simplify() {
        return this;
    }

    public String toString() {
        return "LockedIds(" + Arrays.stream(this.lockedIds).map(NutsId::getLongName).collect(Collectors.joining(",")) + ")";
    }
}

