/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters.id;

import java.util.Objects;
import java.util.Set;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.bundles.common.JavascriptHelper;
import net.thevpc.nuts.runtime.core.filters.id.AbstractIdFilter;
import net.thevpc.nuts.runtime.core.filters.id.NutsScriptAwareIdFilter;
import net.thevpc.nuts.runtime.core.util.Simplifiable;

public class NutsJavascriptIdFilter
extends AbstractIdFilter
implements NutsIdFilter,
Simplifiable<NutsIdFilter>,
NutsScriptAwareIdFilter {
    private String code;

    public static NutsIdFilter valueOf(String value, NutsSession ws) {
        if (NutsUtilStrings.isBlank((CharSequence)value)) {
            return (NutsIdFilter)ws.getWorkspace().id().filter().always();
        }
        return new NutsJavascriptIdFilter(ws, value);
    }

    public NutsJavascriptIdFilter(NutsSession ws, String code) {
        super(ws, NutsFilterOp.CUSTOM);
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public boolean acceptId(NutsId id, NutsSession session) {
        Set<String> blacklist = null;
        JavascriptHelper engineHelper = new JavascriptHelper(this.code, "var id=x.getId(); var version=id.getVersion();", blacklist, null, session);
        return engineHelper.accept(id);
    }

    @Override
    public NutsIdFilter simplify() {
        return this;
    }

    @Override
    public String toJsNutsIdFilterExpr() {
        return this.getCode();
    }

    public int hashCode() {
        int hash = 3;
        hash = 17 * hash + Objects.hashCode(this.code);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutsJavascriptIdFilter other = (NutsJavascriptIdFilter)obj;
        return Objects.equals(this.code, other.code);
    }

    public String toString() {
        return "NutsIdJavascriptFilter{" + this.code + '}';
    }
}

