/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters.id;

import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.core.filters.descriptor.AbstractDescriptorFilter;

public class NutsExecStatusIdFilter
extends AbstractDescriptorFilter {
    private final Boolean executable;
    private final Boolean nutsApplication;

    public NutsExecStatusIdFilter(NutsSession ws, Boolean executable, Boolean nutsApplication) {
        super(ws, NutsFilterOp.CUSTOM);
        this.executable = executable;
        this.nutsApplication = nutsApplication;
    }

    public boolean acceptDescriptor(NutsDescriptor other, NutsSession session) {
        if (this.executable != null) {
            return other.isExecutable() == this.executable.booleanValue();
        }
        if (this.nutsApplication != null) {
            return other.isApplication() == this.nutsApplication.booleanValue();
        }
        return true;
    }

    @Override
    public NutsDescriptorFilter simplify() {
        if (this.executable == null && this.nutsApplication == null) {
            return null;
        }
        return this;
    }

    public String toString() {
        if (this.executable != null && this.nutsApplication != null) {
            if (this.executable.booleanValue() && this.nutsApplication.booleanValue()) {
                return "nuts-app";
            }
            if (!this.executable.booleanValue() && !this.nutsApplication.booleanValue()) {
                return "not(exec)";
            }
            if (this.executable.booleanValue()) {
                return "exec";
            }
            if (this.nutsApplication.booleanValue()) {
                return "nuts-app";
            }
        } else {
            if (this.executable != null) {
                return this.executable != false ? "exec" : "not(exec)";
            }
            if (this.nutsApplication != null) {
                return this.nutsApplication != false ? "nuts-app" : "not(nuts-app)";
            }
        }
        return "any";
    }
}

