/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters.id;

import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.core.filters.descriptor.AbstractDescriptorFilter;

public class NutsExecRuntimeFilter
extends AbstractDescriptorFilter {
    private NutsId apiId;
    private boolean communityRuntime;

    public NutsExecRuntimeFilter(NutsSession ws, NutsId apiId, boolean communityRuntime) {
        super(ws, NutsFilterOp.CUSTOM);
        this.apiId = apiId;
        this.communityRuntime = communityRuntime;
    }

    public boolean acceptDescriptor(NutsDescriptor other, NutsSession session) {
        if (other.getId().getShortName().equals("net.thevpc.nuts:nuts-runtime")) {
            if (this.apiId == null) {
                return true;
            }
            for (NutsDependency dependency : other.getDependencies()) {
                if (!dependency.toId().getShortName().equals("net.thevpc.nuts:nuts")) continue;
                return this.apiId.getVersion().equals(dependency.toId().getVersion());
            }
        }
        if (this.communityRuntime) {
            if (!NutsUtilStrings.parseBoolean((String)((String)other.getProperties().get("nuts-runtime")), (Boolean)false, (Boolean)false).booleanValue()) {
                return false;
            }
            for (NutsDependency dependency : other.getDependencies()) {
                if (!dependency.toId().getShortName().equals("net.thevpc.nuts:nuts")) continue;
                if (this.apiId == null) {
                    return true;
                }
                return this.apiId.getVersion().equals(dependency.toId().getVersion());
            }
        }
        return false;
    }

    @Override
    public NutsDescriptorFilter simplify() {
        return this;
    }

    public String toString() {
        if (this.apiId == null) {
            return "runtime";
        }
        return "runtime(" + this.apiId.getVersion() + ")";
    }
}

