/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters.id;

import java.util.Objects;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.core.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.core.filters.id.AbstractIdFilter;
import net.thevpc.nuts.runtime.core.util.Simplifiable;

public class NutsDefaultVersionIdFilter
extends AbstractIdFilter
implements NutsIdFilter,
Simplifiable<NutsIdFilter> {
    private final Boolean defaultVersion;

    public NutsDefaultVersionIdFilter(NutsSession ws, Boolean defaultVersion) {
        super(ws, NutsFilterOp.CUSTOM);
        this.defaultVersion = defaultVersion;
    }

    public boolean acceptId(NutsId other, NutsSession session) {
        if (this.defaultVersion == null) {
            return true;
        }
        return NutsWorkspaceExt.of(session.getWorkspace()).getInstalledRepository().isDefaultVersion(other, session) == this.defaultVersion.booleanValue();
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.defaultVersion);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutsDefaultVersionIdFilter other = (NutsDefaultVersionIdFilter)obj;
        return Objects.equals(this.defaultVersion, other.defaultVersion);
    }

    @Override
    public NutsIdFilter simplify() {
        if (this.defaultVersion == null) {
            return null;
        }
        return this;
    }

    public String toString() {
        return "defaultVersion(" + this.defaultVersion + ")";
    }
}

