/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters.id;

import java.util.List;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIdFilterManager;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInstallStatusFilter;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersionFilter;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.io.NutsInstallStatusIdFilter;
import net.thevpc.nuts.runtime.core.filters.DefaultNutsFilterModel;
import net.thevpc.nuts.runtime.core.filters.InternalNutsTypedFilters;
import net.thevpc.nuts.runtime.core.filters.NutsPatternIdFilter;
import net.thevpc.nuts.runtime.core.filters.id.NutsDefaultVersionIdFilter;
import net.thevpc.nuts.runtime.core.filters.id.NutsDescriptorIdFilter;
import net.thevpc.nuts.runtime.core.filters.id.NutsIdFilterAnd;
import net.thevpc.nuts.runtime.core.filters.id.NutsIdFilterFalse;
import net.thevpc.nuts.runtime.core.filters.id.NutsIdFilterNone;
import net.thevpc.nuts.runtime.core.filters.id.NutsIdFilterOr;
import net.thevpc.nuts.runtime.core.filters.id.NutsIdFilterParser;
import net.thevpc.nuts.runtime.core.filters.id.NutsIdFilterTrue;
import net.thevpc.nuts.runtime.core.filters.id.NutsJavascriptIdFilter;
import net.thevpc.nuts.runtime.core.filters.id.NutstVersionIdFilter;

public class InternalNutsIdFilterManager
extends InternalNutsTypedFilters<NutsIdFilter>
implements NutsIdFilterManager {
    private final LocalModel localModel;

    public InternalNutsIdFilterManager(DefaultNutsFilterModel model) {
        super(model, NutsIdFilter.class);
        this.localModel = model.getShared(LocalModel.class, () -> new LocalModel(this.ws));
    }

    @Override
    public InternalNutsIdFilterManager setSession(NutsSession session) {
        super.setSession(session);
        return this;
    }

    public NutsIdFilter always() {
        this.checkSession();
        return new NutsIdFilterTrue(this.getSession());
    }

    public NutsIdFilter not(NutsFilter other) {
        return new NutsIdFilterNone(this.getSession(), (NutsIdFilter)other);
    }

    public NutsIdFilter never() {
        this.checkSession();
        return new NutsIdFilterFalse(this.getSession());
    }

    public NutsIdFilter byExpression(String expression) {
        if (NutsUtilStrings.isBlank((CharSequence)expression)) {
            return this.always();
        }
        return NutsJavascriptIdFilter.valueOf(expression, this.getSession());
    }

    public NutsIdFilter byDefaultVersion(Boolean defaultVersion) {
        if (defaultVersion == null) {
            return this.always();
        }
        return new NutsDefaultVersionIdFilter(this.getSession(), defaultVersion);
    }

    public NutsIdFilter byInstallStatus(NutsInstallStatusFilter installStatus) {
        return new NutsInstallStatusIdFilter(this.getSession(), installStatus);
    }

    public NutsIdFilter byName(String ... names) {
        this.checkSession();
        if (names == null || names.length == 0) {
            return this.always();
        }
        NutsPatternIdFilter f = null;
        for (String wildcardId : names) {
            f = f == null ? new NutsPatternIdFilter(this.getSession(), this.getSession().getWorkspace().id().parser().parse(wildcardId)) : f.or(new NutsPatternIdFilter(this.getSession(), this.getSession().getWorkspace().id().parser().parse(wildcardId)));
        }
        return f;
    }

    public NutsIdFilter as(NutsFilter a) {
        this.checkSession();
        if (a instanceof NutsIdFilter) {
            return (NutsIdFilter)a;
        }
        if (a instanceof NutsDescriptorFilter) {
            return new NutsDescriptorIdFilter((NutsDescriptorFilter)a, this.getSession());
        }
        if (a instanceof NutsVersionFilter) {
            return new NutstVersionIdFilter((NutsVersionFilter)a, this.getSession());
        }
        return null;
    }

    public NutsIdFilter from(NutsFilter a) {
        this.checkSession();
        if (a == null) {
            return null;
        }
        NutsIdFilter t = this.as(a);
        if (t == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"not a IdFilter", (Object[])new Object[0]));
        }
        return t;
    }

    public NutsIdFilter all(NutsFilter ... others) {
        List<NutsIdFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        if (all.size() == 1) {
            return (NutsIdFilter)all.get(0);
        }
        return new NutsIdFilterAnd(this.getSession(), all.toArray(new NutsIdFilter[0]));
    }

    public NutsIdFilter any(NutsFilter ... others) {
        List<NutsIdFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        if (all.size() == 1) {
            return (NutsIdFilter)all.get(0);
        }
        return new NutsIdFilterOr(this.getSession(), all.toArray(new NutsIdFilter[0]));
    }

    public NutsIdFilter none(NutsFilter ... others) {
        List<NutsIdFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        return new NutsIdFilterNone(this.getSession(), all.toArray(new NutsIdFilter[0]));
    }

    public NutsIdFilter parse(String expression) {
        return (NutsIdFilter)new NutsIdFilterParser(expression, this.getSession()).parse();
    }

    private static class LocalModel {
        private NutsIdFilterTrue nutsIdFilterTrue;
        private NutsIdFilterFalse nutsIdFilterFalse;
        private NutsWorkspace ws;

        public LocalModel(NutsWorkspace ws) {
            this.ws = ws;
        }
    }
}

