/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters.descriptor;

import java.util.Objects;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.bundles.common.JavascriptHelper;
import net.thevpc.nuts.runtime.core.filters.descriptor.AbstractDescriptorFilter;
import net.thevpc.nuts.runtime.core.filters.descriptor.JsNutsDescriptorFilter;

public class NutsDescriptorJavascriptFilter
extends AbstractDescriptorFilter
implements JsNutsDescriptorFilter {
    private String code;

    public static NutsDescriptorFilter valueOf(String value, NutsSession ws) {
        if (NutsUtilStrings.isBlank((CharSequence)value)) {
            return (NutsDescriptorFilter)ws.getWorkspace().descriptor().filter().always();
        }
        return new NutsDescriptorJavascriptFilter(ws, value);
    }

    public NutsDescriptorJavascriptFilter(NutsSession ws, String code) {
        super(ws, NutsFilterOp.CUSTOM);
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public boolean acceptDescriptor(NutsDescriptor d, NutsSession session) {
        JavascriptHelper engineHelper = new JavascriptHelper(this.code, "var descriptor=x; var id=x.getId(); var version=id.getVersion();", null, null, session);
        return engineHelper.accept(d);
    }

    @Override
    public NutsDescriptorFilter simplify() {
        return this;
    }

    @Override
    public String toJsNutsDescriptorFilterExpr() {
        return this.getCode();
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + Objects.hashCode(this.code);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutsDescriptorJavascriptFilter other = (NutsDescriptorJavascriptFilter)obj;
        return Objects.equals(this.code, other.code);
    }

    public String toString() {
        return "NutsDescriptorJavascriptFilter{" + this.code + '}';
    }
}

