/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters.descriptor;

import java.util.Objects;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.core.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.core.filters.descriptor.AbstractDescriptorFilter;
import net.thevpc.nuts.runtime.core.filters.descriptor.JsNutsDescriptorFilter;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;

public class NutsDescriptorFilterPlatform
extends AbstractDescriptorFilter
implements JsNutsDescriptorFilter {
    private final String platform;

    public NutsDescriptorFilterPlatform(NutsSession ws, String packaging) {
        super(ws, NutsFilterOp.CUSTOM);
        this.platform = packaging;
    }

    public String getPlatform() {
        return this.platform;
    }

    public boolean acceptDescriptor(NutsDescriptor descriptor, NutsSession session) {
        return CoreFilterUtils.matchesPlatform(this.platform, descriptor, session);
    }

    @Override
    public NutsDescriptorFilter simplify() {
        if (NutsUtilStrings.isBlank((CharSequence)this.platform)) {
            return null;
        }
        return this;
    }

    @Override
    public String toJsNutsDescriptorFilterExpr() {
        return "descriptor.matchesPlatform('" + CoreStringUtils.escapeQuoteStrings(this.platform) + "')";
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + Objects.hashCode(this.platform);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutsDescriptorFilterPlatform other = (NutsDescriptorFilterPlatform)obj;
        return Objects.equals(this.platform, other.platform);
    }

    public String toString() {
        return "Platform{" + this.platform + '}';
    }
}

