/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters.descriptor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsDescriptorFilterManager;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.runtime.core.filters.DefaultNutsFilterModel;
import net.thevpc.nuts.runtime.core.filters.InternalNutsTypedFilters;
import net.thevpc.nuts.runtime.core.filters.descriptor.NutsDescriptorFilterAnd;
import net.thevpc.nuts.runtime.core.filters.descriptor.NutsDescriptorFilterArch;
import net.thevpc.nuts.runtime.core.filters.descriptor.NutsDescriptorFilterById;
import net.thevpc.nuts.runtime.core.filters.descriptor.NutsDescriptorFilterFalse;
import net.thevpc.nuts.runtime.core.filters.descriptor.NutsDescriptorFilterNone;
import net.thevpc.nuts.runtime.core.filters.descriptor.NutsDescriptorFilterOr;
import net.thevpc.nuts.runtime.core.filters.descriptor.NutsDescriptorFilterOsdist;
import net.thevpc.nuts.runtime.core.filters.descriptor.NutsDescriptorFilterPackaging;
import net.thevpc.nuts.runtime.core.filters.descriptor.NutsDescriptorFilterParser;
import net.thevpc.nuts.runtime.core.filters.descriptor.NutsDescriptorFilterPlatform;
import net.thevpc.nuts.runtime.core.filters.descriptor.NutsDescriptorFilterTrue;
import net.thevpc.nuts.runtime.core.filters.descriptor.NutsDescriptorJavascriptFilter;
import net.thevpc.nuts.runtime.core.filters.id.BootAPINutsDescriptorFilter;
import net.thevpc.nuts.runtime.core.filters.id.NutsExecCompanionFilter;
import net.thevpc.nuts.runtime.core.filters.id.NutsExecExtensionFilter;
import net.thevpc.nuts.runtime.core.filters.id.NutsExecRuntimeFilter;
import net.thevpc.nuts.runtime.core.filters.id.NutsExecStatusIdFilter;
import net.thevpc.nuts.runtime.core.filters.id.NutsLockedIdExtensionFilter;

public class InternalNutsDescriptorFilterManager
extends InternalNutsTypedFilters<NutsDescriptorFilter>
implements NutsDescriptorFilterManager {
    public InternalNutsDescriptorFilterManager(DefaultNutsFilterModel model) {
        super(model, NutsDescriptorFilter.class);
    }

    @Override
    public InternalNutsDescriptorFilterManager setSession(NutsSession session) {
        super.setSession(session);
        return this;
    }

    public NutsDescriptorFilter always() {
        this.checkSession();
        return new NutsDescriptorFilterTrue(this.getSession());
    }

    public NutsDescriptorFilter never() {
        this.checkSession();
        return new NutsDescriptorFilterFalse(this.getSession());
    }

    public NutsDescriptorFilter not(NutsFilter other) {
        this.checkSession();
        return new NutsDescriptorFilterNone(this.getSession(), (NutsDescriptorFilter)other);
    }

    public NutsDescriptorFilter byExpression(String expression) {
        this.checkSession();
        if (NutsUtilStrings.isBlank((CharSequence)expression)) {
            return this.always();
        }
        return NutsDescriptorJavascriptFilter.valueOf(expression, this.getSession());
    }

    public NutsDescriptorFilter byPackaging(String ... values) {
        this.checkSession();
        if (values == null || values.length == 0) {
            return this.always();
        }
        ArrayList<NutsDescriptorFilterPackaging> packs = new ArrayList<NutsDescriptorFilterPackaging>();
        for (String v : values) {
            packs.add(new NutsDescriptorFilterPackaging(this.getSession(), v));
        }
        if (packs.size() == 1) {
            return (NutsDescriptorFilter)packs.get(0);
        }
        return this.all((NutsFilter[])packs.toArray(new NutsDescriptorFilter[0]));
    }

    public NutsDescriptorFilter byArch(String ... values) {
        this.checkSession();
        if (values == null || values.length == 0) {
            return this.always();
        }
        ArrayList<NutsDescriptorFilterArch> packs = new ArrayList<NutsDescriptorFilterArch>();
        for (String v : values) {
            packs.add(new NutsDescriptorFilterArch(this.getSession(), v));
        }
        if (packs.size() == 1) {
            return (NutsDescriptorFilter)packs.get(0);
        }
        return this.all((NutsFilter[])packs.toArray(new NutsDescriptorFilter[0]));
    }

    public NutsDescriptorFilter byOsdist(String ... values) {
        this.checkSession();
        if (values == null || values.length == 0) {
            return this.always();
        }
        ArrayList<NutsDescriptorFilterOsdist> packs = new ArrayList<NutsDescriptorFilterOsdist>();
        for (String v : values) {
            packs.add(new NutsDescriptorFilterOsdist(this.getSession(), v));
        }
        if (packs.size() == 1) {
            return (NutsDescriptorFilter)packs.get(0);
        }
        return this.all((NutsFilter[])packs.toArray(new NutsDescriptorFilter[0]));
    }

    public NutsDescriptorFilter byPlatform(String ... values) {
        this.checkSession();
        if (values == null || values.length == 0) {
            return this.always();
        }
        ArrayList<NutsDescriptorFilterPlatform> packs = new ArrayList<NutsDescriptorFilterPlatform>();
        for (String v : values) {
            packs.add(new NutsDescriptorFilterPlatform(this.getSession(), v));
        }
        if (packs.size() == 1) {
            return (NutsDescriptorFilter)packs.get(0);
        }
        return this.all((NutsFilter[])packs.toArray(new NutsDescriptorFilter[0]));
    }

    public NutsDescriptorFilter byExec(Boolean value) {
        this.checkSession();
        if (value == null) {
            return this.always();
        }
        return new NutsExecStatusIdFilter(this.getSession(), value, null);
    }

    public NutsDescriptorFilter byApp(Boolean value) {
        this.checkSession();
        if (value == null) {
            return this.always();
        }
        return new NutsExecStatusIdFilter(this.getSession(), null, value);
    }

    public NutsDescriptorFilter byExtension(NutsVersion targetApiVersion) {
        this.checkSession();
        return new NutsExecExtensionFilter(this.getSession(), targetApiVersion == null ? null : this.getSession().getWorkspace().id().parser().parse("net.thevpc.nuts:nuts").builder().setVersion(targetApiVersion).build());
    }

    public NutsDescriptorFilter byRuntime(NutsVersion targetApiVersion) {
        this.checkSession();
        return new NutsExecRuntimeFilter(this.getSession(), targetApiVersion == null ? null : this.getSession().getWorkspace().id().parser().parse("net.thevpc.nuts:nuts").builder().setVersion(targetApiVersion).build(), false);
    }

    public NutsDescriptorFilter byCompanion(NutsVersion targetApiVersion) {
        this.checkSession();
        return new NutsExecCompanionFilter(this.getSession(), targetApiVersion == null ? null : this.ws.id().parser().parse("net.thevpc.nuts:nuts").builder().setVersion(targetApiVersion).build(), (String[])this.ws.getCompanionIds(this.getSession()).stream().map(NutsId::getShortName).toArray(String[]::new));
    }

    public NutsDescriptorFilter byApiVersion(NutsVersion apiVersion) {
        this.checkSession();
        if (apiVersion == null) {
            apiVersion = this.getSession().getWorkspace().getApiVersion();
        }
        return new BootAPINutsDescriptorFilter(this.getSession(), this.getSession().getWorkspace().id().parser().parse("net.thevpc.nuts:nuts").builder().setVersion(apiVersion).build().getVersion());
    }

    public NutsDescriptorFilter byLockedIds(String ... ids) {
        this.checkSession();
        return new NutsLockedIdExtensionFilter(this.getSession(), (NutsId[])Arrays.stream(ids).map(x -> this.ws.id().parser().setLenient(false).parse(x)).toArray(NutsId[]::new));
    }

    public NutsDescriptorFilter as(NutsFilter a) {
        this.checkSession();
        if (a instanceof NutsDescriptorFilter) {
            return (NutsDescriptorFilter)a;
        }
        if (a instanceof NutsIdFilter) {
            return new NutsDescriptorFilterById((NutsIdFilter)a, this.getSession());
        }
        return null;
    }

    public NutsDescriptorFilter from(NutsFilter a) {
        this.checkSession();
        if (a == null) {
            return null;
        }
        NutsDescriptorFilter t = this.as(a);
        if (t == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"not a DescriptorFilter", (Object[])new Object[0]));
        }
        return t;
    }

    public NutsDescriptorFilter all(NutsFilter ... others) {
        this.checkSession();
        List<NutsDescriptorFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        if (all.size() == 1) {
            return (NutsDescriptorFilter)all.get(0);
        }
        return new NutsDescriptorFilterAnd(this.getSession(), all.toArray(new NutsDescriptorFilter[0]));
    }

    public NutsDescriptorFilter any(NutsFilter ... others) {
        this.checkSession();
        List<NutsDescriptorFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        if (all.size() == 1) {
            return (NutsDescriptorFilter)all.get(0);
        }
        return new NutsDescriptorFilterOr(this.getSession(), all.toArray(new NutsDescriptorFilter[0]));
    }

    public NutsDescriptorFilter none(NutsFilter ... others) {
        this.checkSession();
        List<NutsDescriptorFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        return new NutsDescriptorFilterNone(this.getSession(), all.toArray(new NutsDescriptorFilter[0]));
    }

    public NutsDescriptorFilter parse(String expression) {
        this.checkSession();
        return (NutsDescriptorFilter)new NutsDescriptorFilterParser(expression, this.getSession()).parse();
    }
}

