/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters.dependency;

import java.util.Objects;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.core.filters.dependency.AbstractDependencyFilter;
import net.thevpc.nuts.runtime.core.util.CoreNutsDependencyUtils;

public class NutsDependencyTypeFilter
extends AbstractDependencyFilter {
    private String type = null;

    public NutsDependencyTypeFilter(NutsSession session, String type) {
        super(session, NutsFilterOp.CUSTOM);
        this.type = type;
    }

    public boolean acceptDependency(NutsId from, NutsDependency dependency, NutsSession session) {
        String curr = CoreNutsDependencyUtils.normalizeDependencyType(dependency.getType());
        String toCheck = CoreNutsDependencyUtils.normalizeDependencyType(this.type);
        return Objects.equals(curr, toCheck);
    }

    public String toString() {
        return this.type == null || this.type.isEmpty() ? "empty-type" : "type=" + this.type;
    }

    @Override
    public NutsDependencyFilter simplify() {
        return this;
    }
}

