/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters.dependency;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.core.filters.dependency.AbstractDependencyFilter;

public class NutsDependencyOsFilter
extends AbstractDependencyFilter {
    private Set<NutsOsFamily> os = EnumSet.noneOf(NutsOsFamily.class);

    public NutsDependencyOsFilter(NutsSession ws) {
        super(ws, NutsFilterOp.CUSTOM);
    }

    private NutsDependencyOsFilter(NutsSession ws, Collection<NutsOsFamily> os) {
        super(ws, NutsFilterOp.CUSTOM);
        this.os = EnumSet.copyOf(os);
    }

    public NutsDependencyOsFilter(NutsSession ws, String os) {
        super(ws, NutsFilterOp.CUSTOM);
        this.os = EnumSet.noneOf(NutsOsFamily.class);
        for (String e : os.split("[,; ]")) {
            if (e.isEmpty()) continue;
            this.os.add(NutsOsFamily.parseLenient((String)e));
        }
    }

    public NutsDependencyOsFilter add(Collection<NutsOsFamily> os) {
        EnumSet<NutsOsFamily> s2 = EnumSet.copyOf(this.os);
        s2.addAll(os);
        return new NutsDependencyOsFilter(this.getSession(), s2);
    }

    public boolean acceptDependency(NutsId from, NutsDependency dependency, NutsSession session) {
        String current = dependency.getOs();
        boolean empty = true;
        if (current != null) {
            for (String e : current.split("[,; ]")) {
                if (e.isEmpty()) continue;
                empty = false;
                if (!this.os.contains(NutsOsFamily.parseLenient((String)e))) continue;
                return true;
            }
        }
        return empty;
    }

    public String toString() {
        return this.os.isEmpty() ? "true" : "os in (" + this.os.stream().map(x -> x.id()).collect(Collectors.joining(", ")) + ')';
    }

    @Override
    public NutsDependencyFilter simplify() {
        return this.os.isEmpty() ? (NutsDependencyFilter)this.getWorkspace().filters().dependency().always() : this;
    }
}

