/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters.dependency;

import java.util.Objects;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.bundles.common.JavascriptHelper;
import net.thevpc.nuts.runtime.core.filters.dependency.AbstractDependencyFilter;
import net.thevpc.nuts.runtime.core.filters.dependency.JsNutsDependencyFilter;

public class NutsDependencyJavascriptFilter
extends AbstractDependencyFilter
implements JsNutsDependencyFilter {
    private String code;

    public static NutsDependencyJavascriptFilter valueOf(String value, NutsSession ws) {
        if (NutsUtilStrings.isBlank((CharSequence)value)) {
            return null;
        }
        return new NutsDependencyJavascriptFilter(ws, value);
    }

    public NutsDependencyJavascriptFilter(NutsSession ws, String code) {
        super(ws, NutsFilterOp.CUSTOM);
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public boolean acceptDependency(NutsId from, NutsDependency d, NutsSession session) {
        JavascriptHelper engineHelper = new JavascriptHelper(this.code, "var dependency=x; var id=x.getId(); var version=id.getVersion();", null, null, session);
        return engineHelper.accept(d);
    }

    @Override
    public NutsDependencyFilter simplify() {
        return this;
    }

    @Override
    public String toJsNutsDependencyFilterExpr() {
        return this.getCode();
    }

    public String toString() {
        return "NutsDependencyJavascriptFilter{" + this.code + '}';
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + Objects.hashCode(this.code);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutsDependencyJavascriptFilter other = (NutsDependencyJavascriptFilter)obj;
        return Objects.equals(this.code, other.code);
    }
}

