/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters.dependency;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsArchFamily;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.core.filters.dependency.AbstractDependencyFilter;

public class NutsDependencyArchFilter
extends AbstractDependencyFilter {
    private Set<NutsArchFamily> archs = EnumSet.noneOf(NutsArchFamily.class);

    public NutsDependencyArchFilter(NutsSession ws) {
        super(ws, NutsFilterOp.CUSTOM);
    }

    private NutsDependencyArchFilter(NutsSession ws, Collection<NutsArchFamily> os) {
        super(ws, NutsFilterOp.CUSTOM);
        this.archs = EnumSet.copyOf(os);
    }

    public NutsDependencyArchFilter(NutsSession ws, String os) {
        super(ws, NutsFilterOp.CUSTOM);
        this.archs = EnumSet.noneOf(NutsArchFamily.class);
        for (String e : os.split("[,; ]")) {
            if (e.isEmpty()) continue;
            this.archs.add(NutsArchFamily.parseLenient((String)e));
        }
    }

    public NutsDependencyArchFilter add(Collection<NutsArchFamily> os) {
        EnumSet<NutsArchFamily> s2 = EnumSet.copyOf(this.archs);
        s2.addAll(os);
        return new NutsDependencyArchFilter(this.getSession(), s2);
    }

    public boolean acceptDependency(NutsId from, NutsDependency dependency, NutsSession session) {
        String current = dependency.getArch();
        boolean empty = true;
        if (current != null) {
            for (String e : current.split("[,; ]")) {
                if (e.isEmpty()) continue;
                empty = false;
                if (!this.archs.contains(NutsArchFamily.parseLenient((String)e))) continue;
                return true;
            }
        }
        return empty;
    }

    public String toString() {
        return this.archs.isEmpty() ? "true" : "arch in (" + this.archs.stream().map(x -> x.id()).collect(Collectors.joining(", ")) + ')';
    }

    @Override
    public NutsDependencyFilter simplify() {
        return this.archs.isEmpty() ? (NutsDependencyFilter)this.getWorkspace().filters().dependency().always() : this;
    }
}

