/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters.dependency;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.thevpc.nuts.NutsArchFamily;
import net.thevpc.nuts.NutsDependencyFilter;
import net.thevpc.nuts.NutsDependencyFilterManager;
import net.thevpc.nuts.NutsDependencyScope;
import net.thevpc.nuts.NutsDependencyScopePattern;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.core.filters.DefaultNutsFilterModel;
import net.thevpc.nuts.runtime.core.filters.InternalNutsTypedFilters;
import net.thevpc.nuts.runtime.core.filters.dependency.NutsDependencyArchFilter;
import net.thevpc.nuts.runtime.core.filters.dependency.NutsDependencyFilterAnd;
import net.thevpc.nuts.runtime.core.filters.dependency.NutsDependencyFilterFalse;
import net.thevpc.nuts.runtime.core.filters.dependency.NutsDependencyFilterNone;
import net.thevpc.nuts.runtime.core.filters.dependency.NutsDependencyFilterOr;
import net.thevpc.nuts.runtime.core.filters.dependency.NutsDependencyFilterParser;
import net.thevpc.nuts.runtime.core.filters.dependency.NutsDependencyFilterTrue;
import net.thevpc.nuts.runtime.core.filters.dependency.NutsDependencyJavascriptFilter;
import net.thevpc.nuts.runtime.core.filters.dependency.NutsDependencyOptionFilter;
import net.thevpc.nuts.runtime.core.filters.dependency.NutsDependencyOsFilter;
import net.thevpc.nuts.runtime.core.filters.dependency.NutsDependencyScopeFilter;
import net.thevpc.nuts.runtime.core.filters.dependency.NutsDependencyTypeFilter;
import net.thevpc.nuts.runtime.core.filters.dependency.NutsExclusionDependencyFilter;
import net.thevpc.nuts.runtime.core.filters.dependency.ScopeNutsDependencyFilter;

public class InternalNutsDependencyFilterManager
extends InternalNutsTypedFilters<NutsDependencyFilter>
implements NutsDependencyFilterManager {
    public InternalNutsDependencyFilterManager(DefaultNutsFilterModel model) {
        super(model, NutsDependencyFilter.class);
    }

    @Override
    public InternalNutsDependencyFilterManager setSession(NutsSession session) {
        super.setSession(session);
        return this;
    }

    public NutsDependencyFilter not(NutsFilter other) {
        this.checkSession();
        return new NutsDependencyFilterNone(this.getSession(), (NutsDependencyFilter)other);
    }

    public NutsDependencyFilter always() {
        this.checkSession();
        return new NutsDependencyFilterTrue(this.getSession());
    }

    public NutsDependencyFilter never() {
        this.checkSession();
        return new NutsDependencyFilterFalse(this.getSession());
    }

    @Override
    public NutsDependencyFilter nonnull(NutsFilter filter) {
        this.checkSession();
        return (NutsDependencyFilter)super.nonnull(filter);
    }

    public NutsDependencyFilter byScope(NutsDependencyScopePattern scope) {
        this.checkSession();
        if (scope == null) {
            return this.always();
        }
        return new ScopeNutsDependencyFilter(this.getSession(), scope);
    }

    public NutsDependencyFilter byScope(NutsDependencyScope scope) {
        this.checkSession();
        if (scope == null) {
            return this.always();
        }
        return new NutsDependencyScopeFilter(this.getSession()).add(Arrays.asList(scope));
    }

    public NutsDependencyFilter byScope(NutsDependencyScope ... scope) {
        this.checkSession();
        if (scope == null) {
            return this.always();
        }
        return new NutsDependencyScopeFilter(this.getSession()).add(Arrays.asList(scope));
    }

    public NutsDependencyFilter byScope(Collection<NutsDependencyScope> scope) {
        this.checkSession();
        if (scope == null) {
            return this.always();
        }
        return new NutsDependencyScopeFilter(this.getSession()).add(scope);
    }

    public NutsDependencyFilter byOs(String os) {
        this.checkSession();
        if (os == null) {
            return this.always();
        }
        return new NutsDependencyOsFilter(this.getSession(), os);
    }

    public NutsDependencyFilter byType(String type) {
        return new NutsDependencyTypeFilter(this.getSession(), type);
    }

    public NutsDependencyFilter byOs(NutsOsFamily os) {
        this.checkSession();
        if (os == null) {
            return this.always();
        }
        return new NutsDependencyOsFilter(this.getSession()).add(Arrays.asList(os));
    }

    public NutsDependencyFilter byOs(NutsOsFamily ... os) {
        this.checkSession();
        this.checkSession();
        if (os == null) {
            return this.always();
        }
        return new NutsDependencyOsFilter(this.getSession()).add(Arrays.asList(os));
    }

    public NutsDependencyFilter byOs(Collection<NutsOsFamily> os) {
        this.checkSession();
        if (os == null) {
            return this.always();
        }
        return new NutsDependencyOsFilter(this.getSession()).add(os);
    }

    public NutsDependencyFilter byArch(NutsArchFamily os) {
        this.checkSession();
        if (os == null) {
            return this.always();
        }
        return new NutsDependencyArchFilter(this.getSession()).add(Arrays.asList(os));
    }

    public NutsDependencyFilter byArch(NutsArchFamily ... arch) {
        this.checkSession();
        if (arch == null) {
            return this.always();
        }
        return new NutsDependencyArchFilter(this.getSession()).add(Arrays.asList(arch));
    }

    public NutsDependencyFilter byArch(Collection<NutsArchFamily> arch) {
        this.checkSession();
        if (arch == null) {
            return this.always();
        }
        return new NutsDependencyArchFilter(this.getSession()).add(arch);
    }

    public NutsDependencyFilter byArch(String arch) {
        this.checkSession();
        if (arch == null) {
            return this.always();
        }
        return new NutsDependencyArchFilter(this.getSession(), arch);
    }

    public NutsDependencyFilter byOptional(Boolean optional) {
        this.checkSession();
        if (optional == null) {
            return this.always();
        }
        return new NutsDependencyOptionFilter(this.getSession(), optional);
    }

    public NutsDependencyFilter byExpression(String expression) {
        this.checkSession();
        if (NutsUtilStrings.isBlank((CharSequence)expression)) {
            return this.always();
        }
        return NutsDependencyJavascriptFilter.valueOf(expression, this.getSession());
    }

    public NutsDependencyFilter byExclude(NutsDependencyFilter filter, String[] exclusions) {
        this.checkSession();
        return new NutsExclusionDependencyFilter(this.getSession(), filter, (NutsId[])Arrays.stream(exclusions).map(x -> this.ws.id().parser().setLenient(false).parse(x)).toArray(NutsId[]::new));
    }

    public NutsDependencyFilter as(NutsFilter a) {
        this.checkSession();
        if (a instanceof NutsDependencyFilter) {
            return (NutsDependencyFilter)a;
        }
        return null;
    }

    public NutsDependencyFilter from(NutsFilter a) {
        this.checkSession();
        if (a == null) {
            return null;
        }
        NutsDependencyFilter t = this.as(a);
        if (t == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"not a NutsDependencyFilter", (Object[])new Object[0]));
        }
        return t;
    }

    public NutsDependencyFilter all(NutsFilter ... others) {
        this.checkSession();
        List<NutsDependencyFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        if (all.size() == 1) {
            return (NutsDependencyFilter)all.get(0);
        }
        return new NutsDependencyFilterAnd(this.getSession(), all.toArray(new NutsDependencyFilter[0]));
    }

    public NutsDependencyFilter any(NutsFilter ... others) {
        this.checkSession();
        List<NutsDependencyFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        if (all.size() == 1) {
            return (NutsDependencyFilter)all.get(0);
        }
        return new NutsDependencyFilterOr(this.getSession(), all.toArray(new NutsDependencyFilter[0]));
    }

    public NutsDependencyFilter none(NutsFilter ... others) {
        this.checkSession();
        List<NutsDependencyFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        return new NutsDependencyFilterNone(this.getSession(), all.toArray(new NutsDependencyFilter[0]));
    }

    public NutsDependencyFilter parse(String expression) {
        this.checkSession();
        return (NutsDependencyFilter)new NutsDependencyFilterParser(expression, this.getSession()).parse();
    }
}

