/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.thevpc.nuts.NutsDependencyFilter;
import net.thevpc.nuts.NutsDependencyFilterManager;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsDescriptorFilterManager;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIdFilterManager;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInstallStatusFilter;
import net.thevpc.nuts.NutsInstallStatusFilterManager;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsRepositoryFilter;
import net.thevpc.nuts.NutsRepositoryFilterManager;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTypedFilters;
import net.thevpc.nuts.NutsVersionFilter;
import net.thevpc.nuts.NutsVersionFilterManager;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.filters.dependency.InternalNutsDependencyFilterManager;
import net.thevpc.nuts.runtime.core.filters.dependency.NutsDependencyFilterNone;
import net.thevpc.nuts.runtime.core.filters.descriptor.InternalNutsDescriptorFilterManager;
import net.thevpc.nuts.runtime.core.filters.descriptor.NutsDescriptorFilterNone;
import net.thevpc.nuts.runtime.core.filters.id.InternalNutsIdFilterManager;
import net.thevpc.nuts.runtime.core.filters.id.NutsIdFilterNone;
import net.thevpc.nuts.runtime.core.filters.installstatus.InternalNutsInstallStatusFilterManager;
import net.thevpc.nuts.runtime.core.filters.repository.InternalNutsRepositoryFilterManager;
import net.thevpc.nuts.runtime.core.filters.repository.NutsRepositoryFilterNone;
import net.thevpc.nuts.runtime.core.filters.version.InternalNutsVersionFilterManager;
import net.thevpc.nuts.runtime.core.filters.version.NutsVersionFilterNone;

public class DefaultNutsFilterModel {
    private NutsWorkspace workspace;
    private Map<String, Object> shared = new HashMap<String, Object>();

    public DefaultNutsFilterModel(NutsWorkspace ws) {
        this.workspace = ws;
    }

    public NutsWorkspace getWorkspace() {
        return this.workspace;
    }

    public <T> T getShared(Class<T> clz, Supplier<T> s) {
        return (T)this.shared.computeIfAbsent(clz.getName(), t -> s.get());
    }

    public <T extends NutsFilter> T nonnull(Class<T> type, NutsFilter filter, NutsSession session) {
        if (filter == null) {
            return this.always(type, session);
        }
        return (T)filter.to(type);
    }

    public NutsTypedFilters resolveNutsTypedFilters(Class type, NutsSession session) {
        if (type == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unable to detected Filter type", (Object[])new Object[0]));
        }
        switch (type.getName()) {
            case "net.thevpc.nuts.NutsDependencyFilter": {
                return this.dependency().setSession(session);
            }
            case "net.thevpc.nuts.NutsRepositoryFilter": {
                return this.repository().setSession(session);
            }
            case "net.thevpc.nuts.NutsIdFilter": {
                return this.id().setSession(session);
            }
            case "net.thevpc.nuts.NutsVersionFilter": {
                return this.version().setSession(session);
            }
            case "net.thevpc.nuts.NutsDescriptorFilter": {
                return this.descriptor().setSession(session);
            }
            case "net.thevpc.nuts.NutsInstallStatusFilter": {
                return this.installStatus().setSession(session);
            }
        }
        throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unsupported filter type: %s", (Object[])new Object[]{type}));
    }

    public <T extends NutsFilter> T always(Class<T> type, NutsSession session) {
        return (T)this.resolveNutsTypedFilters(type, session).always();
    }

    public <T extends NutsFilter> T never(Class<T> type, NutsSession session) {
        return (T)this.resolveNutsTypedFilters(type, session).never();
    }

    public <T extends NutsFilter> T all(Class<T> type, NutsFilter[] others, NutsSession session) {
        others = this.expandAll(others).toArray(new NutsFilter[0]);
        if (type == null || type.equals(NutsFilter.class)) {
            ArrayList<NutsFilter> all = new ArrayList<NutsFilter>();
            all.addAll(Arrays.asList(others));
            type = this.detectType(all.toArray(new NutsFilter[0]), session);
            if (type == null) {
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unable to detected Filter type", (Object[])new Object[0]));
            }
        }
        return (T)this.resolveNutsTypedFilters(type, session).all(others);
    }

    public <T extends NutsFilter> T all(NutsFilter[] others, NutsSession session) {
        return this.all(null, others, session);
    }

    public <T extends NutsFilter> T any(Class<T> type, NutsFilter[] others, NutsSession session) {
        others = this.expandAny(others).toArray(new NutsFilter[0]);
        if (type == null || type.equals(NutsFilter.class)) {
            ArrayList<NutsFilter> all = new ArrayList<NutsFilter>();
            all.addAll(Arrays.asList(others));
            type = this.detectType(all.toArray(new NutsFilter[0]), session);
            if (type == null) {
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unable to detected Filter type", (Object[])new Object[0]));
            }
        }
        return (T)this.resolveNutsTypedFilters(type, session).any(others);
    }

    public <T extends NutsFilter> T not(NutsFilter other, NutsSession session) {
        return this.not(null, other, session);
    }

    public <T extends NutsFilter> T not(Class<T> type, NutsFilter other, NutsSession session) {
        if ((type == null || type.equals(NutsFilter.class)) && (type = this.detectType(other, session)) == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unable to detected Filter type", (Object[])new Object[0]));
        }
        return (T)this.resolveNutsTypedFilters(type, session).not(other);
    }

    public <T extends NutsFilter> T any(NutsFilter[] others, NutsSession session) {
        return this.any(null, others, session);
    }

    public <T extends NutsFilter> T none(Class<T> type, NutsFilter[] others, NutsSession session) {
        others = this.expandAll(others).toArray(new NutsFilter[0]);
        if (type == null || type.equals(NutsFilter.class)) {
            ArrayList<NutsFilter> all = new ArrayList<NutsFilter>();
            all.addAll(Arrays.asList(others));
            type = this.detectType(all.toArray(new NutsFilter[0]), session);
            if (type == null) {
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unable to detected Filter type", (Object[])new Object[0]));
            }
        }
        switch (type.getName()) {
            case "net.thevpc.nuts.NutsDependencyFilter": {
                ArrayList<NutsDependencyFilter> all = new ArrayList<NutsDependencyFilter>();
                for (NutsFilter other : others) {
                    NutsDependencyFilter a = (NutsDependencyFilter)this.dependency().from(other);
                    if (a == null) continue;
                    all.add(a);
                }
                if (all.isEmpty()) {
                    return this.always(type, session);
                }
                return (T)new NutsDependencyFilterNone(session, all.toArray(new NutsDependencyFilter[0]));
            }
            case "net.thevpc.nuts.NutsRepositoryFilter": {
                ArrayList<NutsRepositoryFilter> all = new ArrayList<NutsRepositoryFilter>();
                for (NutsFilter other : others) {
                    NutsRepositoryFilter a = (NutsRepositoryFilter)this.repository().from(other);
                    if (a == null) continue;
                    all.add(a);
                }
                if (all.isEmpty()) {
                    return this.always(type, session);
                }
                return (T)new NutsRepositoryFilterNone(session, all.toArray(new NutsRepositoryFilter[0]));
            }
            case "net.thevpc.nuts.NutsIdFilter": {
                ArrayList<NutsIdFilter> all = new ArrayList<NutsIdFilter>();
                for (NutsFilter other : others) {
                    NutsIdFilter a = (NutsIdFilter)this.id().from(other);
                    if (a == null) continue;
                    all.add(a);
                }
                if (all.isEmpty()) {
                    return this.always(type, session);
                }
                return (T)new NutsIdFilterNone(session, all.toArray(new NutsIdFilter[0]));
            }
            case "net.thevpc.nuts.NutsVersionFilter": {
                ArrayList<NutsVersionFilter> all = new ArrayList<NutsVersionFilter>();
                for (NutsFilter other : others) {
                    NutsVersionFilter a = (NutsVersionFilter)this.version().from(other);
                    if (a == null) continue;
                    all.add(a);
                }
                if (all.isEmpty()) {
                    return this.always(type, session);
                }
                return (T)new NutsVersionFilterNone(session, all.toArray(new NutsVersionFilter[0]));
            }
            case "net.thevpc.nuts.NutsDescriptorFilter": {
                ArrayList<NutsDescriptorFilter> all = new ArrayList<NutsDescriptorFilter>();
                for (NutsFilter other : others) {
                    NutsDescriptorFilter a = (NutsDescriptorFilter)this.descriptor().from(other);
                    if (a == null) continue;
                    all.add(a);
                }
                if (all.isEmpty()) {
                    return this.always(type, session);
                }
                return (T)new NutsDescriptorFilterNone(session, all.toArray(new NutsDescriptorFilter[0]));
            }
        }
        throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unsupported filter type: %s", (Object[])new Object[]{type}));
    }

    public <T extends NutsFilter> T none(NutsFilter[] others, NutsSession session) {
        return this.none(null, others, session);
    }

    public <T extends NutsFilter> T to(Class<T> toFilterInterface, NutsFilter filter, NutsSession session) {
        return (T)this.resolveNutsTypedFilters(toFilterInterface, session).from(filter);
    }

    public <T extends NutsFilter> T as(Class<T> toFilterInterface, NutsFilter filter, NutsSession session) {
        return (T)this.resolveNutsTypedFilters(toFilterInterface, session).as(filter);
    }

    public Class<? extends NutsFilter> detectType(NutsFilter nutsFilter, NutsSession session) {
        if (nutsFilter == null) {
            return null;
        }
        return this.detectType(nutsFilter.getClass(), session);
    }

    public NutsIdFilterManager id() {
        return new InternalNutsIdFilterManager(this);
    }

    public NutsDependencyFilterManager dependency() {
        return new InternalNutsDependencyFilterManager(this);
    }

    public NutsRepositoryFilterManager repository() {
        return new InternalNutsRepositoryFilterManager(this);
    }

    public NutsVersionFilterManager version() {
        return new InternalNutsVersionFilterManager(this);
    }

    public NutsDescriptorFilterManager descriptor() {
        return new InternalNutsDescriptorFilterManager(this);
    }

    public NutsInstallStatusFilterManager installStatus() {
        return new InternalNutsInstallStatusFilterManager(this);
    }

    private Collection<NutsFilter> expandAny(NutsFilter ... others) {
        ArrayList<NutsFilter> ok = new ArrayList<NutsFilter>();
        if (others != null) {
            for (NutsFilter other : others) {
                if (other == null) continue;
                if (other.getFilterOp() == NutsFilterOp.OR) {
                    ok.addAll(Arrays.asList(other.getSubFilters()));
                    continue;
                }
                ok.addAll(Arrays.asList(other));
            }
        }
        return ok;
    }

    private Collection<NutsFilter> expandAll(NutsFilter ... others) {
        ArrayList<NutsFilter> ok = new ArrayList<NutsFilter>();
        if (others != null) {
            for (NutsFilter other : others) {
                if (other == null) continue;
                if (other.getFilterOp() == NutsFilterOp.AND) {
                    ok.addAll(Arrays.asList(other.getSubFilters()));
                    continue;
                }
                ok.addAll(Arrays.asList(other));
            }
        }
        return ok;
    }

    private Collection<NutsFilter> expandNone(NutsFilter ... others) {
        ArrayList<NutsFilter> ok = new ArrayList<NutsFilter>();
        if (others != null) {
            for (NutsFilter other : others) {
                if (other == null) continue;
                if (other.getFilterOp() == NutsFilterOp.NOT) {
                    ok.addAll(Arrays.asList(other.getSubFilters()));
                    continue;
                }
                ok.addAll(Arrays.asList(other));
            }
        }
        return ok;
    }

    public <T extends NutsFilter> Class<T> detectType(NutsFilter[] others, NutsSession session) {
        Class<T> c = null;
        for (NutsFilter other : others) {
            if (other == null) continue;
            c = c == null ? this.detectType(other.getClass(), session) : this.detectType(c, other.getClass(), session);
        }
        if (c == null) {
            return null;
        }
        return c;
    }

    public <T extends NutsFilter> Class<T> detectType(Class<? extends NutsFilter> c1, NutsSession session) {
        if (c1 == null) {
            return null;
        }
        if (NutsVersionFilter.class.isAssignableFrom(c1)) {
            return NutsVersionFilter.class;
        }
        if (NutsIdFilter.class.isAssignableFrom(c1)) {
            return NutsIdFilter.class;
        }
        if (NutsDescriptorFilter.class.isAssignableFrom(c1)) {
            return NutsDescriptorFilter.class;
        }
        if (NutsRepositoryFilter.class.isAssignableFrom(c1)) {
            return NutsRepositoryFilter.class;
        }
        if (NutsDependencyFilter.class.isAssignableFrom(c1)) {
            return NutsDependencyFilter.class;
        }
        if (NutsInstallStatusFilter.class.isAssignableFrom(c1)) {
            return NutsInstallStatusFilter.class;
        }
        throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"cannot detect filter type for %s", (Object[])new Object[]{c1}));
    }

    public <T extends NutsFilter> Class<T> detectType(Class<? extends NutsFilter> c1, Class<? extends NutsFilter> c2, NutsSession session) {
        if (NutsVersionFilter.class.isAssignableFrom(c1)) {
            if (NutsVersionFilter.class.isAssignableFrom(c2)) {
                return NutsVersionFilter.class;
            }
            if (NutsIdFilter.class.isAssignableFrom(c2)) {
                return NutsIdFilter.class;
            }
            if (NutsDescriptorFilter.class.isAssignableFrom(c2)) {
                return NutsDescriptorFilter.class;
            }
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"cannot detect common type for %s and %s", (Object[])new Object[]{c1, c2}));
        }
        if (NutsIdFilter.class.isAssignableFrom(c1)) {
            if (NutsVersionFilter.class.isAssignableFrom(c2)) {
                return NutsIdFilter.class;
            }
            if (NutsIdFilter.class.isAssignableFrom(c2)) {
                return NutsIdFilter.class;
            }
            if (NutsDescriptorFilter.class.isAssignableFrom(c2)) {
                return NutsDescriptorFilter.class;
            }
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"cannot detect common type for %s and %s", (Object[])new Object[]{c1, c2}));
        }
        if (NutsDescriptorFilter.class.isAssignableFrom(c1)) {
            if (NutsVersionFilter.class.isAssignableFrom(c2)) {
                return NutsDescriptorFilter.class;
            }
            if (NutsIdFilter.class.isAssignableFrom(c2)) {
                return NutsDescriptorFilter.class;
            }
            if (NutsDescriptorFilter.class.isAssignableFrom(c2)) {
                return NutsDescriptorFilter.class;
            }
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"cannot detect common type for %s and %s", (Object[])new Object[]{c1, c2}));
        }
        if (NutsDependencyFilter.class.isAssignableFrom(c1)) {
            if (NutsDependencyFilter.class.isAssignableFrom(c2)) {
                return NutsDependencyFilter.class;
            }
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"cannot detect common type for %s and %s", (Object[])new Object[]{c1, c2}));
        }
        if (NutsRepositoryFilter.class.isAssignableFrom(c1)) {
            if (NutsRepositoryFilter.class.isAssignableFrom(c2)) {
                return NutsRepositoryFilter.class;
            }
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"cannot detect common type for %s and %s", (Object[])new Object[]{c1, c2}));
        }
        if (NutsInstallStatusFilter.class.isAssignableFrom(c1)) {
            if (NutsInstallStatusFilter.class.isAssignableFrom(c2)) {
                return NutsInstallStatusFilter.class;
            }
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"cannot detect common type for %s and %s", (Object[])new Object[]{c1, c2}));
        }
        throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"cannot detect common type for %s and %s", (Object[])new Object[]{c1, c2}));
    }
}

