/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyFilter;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsDescriptorFilterManager;
import net.thevpc.nuts.NutsExtensionInformation;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIdParser;
import net.thevpc.nuts.NutsPredicates;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;

public class CoreFilterUtils {
    private static int andInts(Boolean a, Boolean b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return b != false ? 1 : -1;
        }
        if (b == null) {
            return a != false ? 1 : -1;
        }
        if (a.equals(b)) {
            return a != false ? 1 : -1;
        }
        return 2;
    }

    private static int orInts(Boolean a, Boolean b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return b != false ? 1 : -1;
        }
        if (b == null) {
            return a != false ? 1 : -1;
        }
        if (a.equals(b)) {
            return a != false ? 1 : -1;
        }
        return 0;
    }

    public static <T extends NutsFilter> T[] getTopLevelFilters(NutsFilter idFilter, Class<T> clazz, NutsWorkspace ws) {
        return (NutsFilter[])Arrays.stream(CoreFilterUtils.getTopLevelFilters(idFilter)).map(x -> ws.filters().as(clazz, x)).toArray(value -> (NutsFilter[])Array.newInstance(clazz, value));
    }

    public static NutsFilter[] getTopLevelFilters(NutsFilter idFilter) {
        if (idFilter == null) {
            return new NutsFilter[0];
        }
        if (idFilter.getFilterOp() == NutsFilterOp.AND) {
            return idFilter.getSubFilters();
        }
        return new NutsFilter[]{idFilter};
    }

    public static NutsIdFilter idFilterOf(Map<String, String> map, NutsIdFilter idFilter, NutsDescriptorFilter descriptorFilter, NutsWorkspace ws) {
        return ((NutsIdFilter)ws.id().filter().nonnull((NutsFilter)idFilter)).and((NutsIdFilter)CoreFilterUtils.createNutsDescriptorFilter(map, ws).and(descriptorFilter).to(NutsIdFilter.class));
    }

    public static NutsDescriptorFilter createNutsDescriptorFilter(String arch, String os, String osdist, String platform, NutsWorkspace ws) {
        NutsDescriptorFilterManager d = ws.descriptor().filter();
        return d.byArch(new String[]{arch}).and(d.byOsdist(new String[]{osdist})).and(d.byPlatform(new String[]{platform}));
    }

    public static NutsDescriptorFilter createNutsDescriptorFilter(Map<String, String> faceMap, NutsWorkspace ws) {
        return CoreFilterUtils.createNutsDescriptorFilter(faceMap == null ? null : faceMap.get("arch"), faceMap == null ? null : faceMap.get("os"), faceMap == null ? null : faceMap.get("osdist"), faceMap == null ? null : faceMap.get("platform"), ws);
    }

    public static <T> Predicate<NutsId> createFilter(NutsIdFilter t, NutsSession session) {
        if (t == null) {
            return null;
        }
        return new NutsIdFilterToPredicate(t, session);
    }

    public static List<NutsExtensionInformation> filterNutsExtensionInfoByLatestVersion(List<NutsExtensionInformation> base) {
        LinkedHashMap<String, NutsExtensionInformation> valid = new LinkedHashMap<String, NutsExtensionInformation>();
        for (NutsExtensionInformation n : base) {
            NutsExtensionInformation old = (NutsExtensionInformation)valid.get(n.getId().getShortName());
            if (old != null && old.getId().getVersion().compareTo(n.getId().getVersion()) >= 0) continue;
            valid.put(n.getId().getShortName(), n);
        }
        return new ArrayList<NutsExtensionInformation>(valid.values());
    }

    public static List<NutsId> filterNutsIdByLatestVersion(List<NutsId> base) {
        LinkedHashMap<String, NutsId> valid = new LinkedHashMap<String, NutsId>();
        for (NutsId n : base) {
            NutsId old = (NutsId)valid.get(n.getShortName());
            if (old != null && old.getVersion().compareTo(n.getVersion()) >= 0) continue;
            valid.put(n.getShortName(), n);
        }
        return new ArrayList<NutsId>(valid.values());
    }

    public static boolean matchesPackaging(String packaging, NutsDescriptor desc, NutsSession session) {
        if (NutsUtilStrings.isBlank((CharSequence)packaging)) {
            return true;
        }
        if (NutsUtilStrings.isBlank((CharSequence)desc.getPackaging())) {
            return true;
        }
        NutsIdParser parser = session.getWorkspace().id().parser();
        NutsId _v = parser.parse(packaging);
        NutsId _v2 = parser.parse(desc.getPackaging());
        if (_v == null || _v2 == null) {
            return _v == _v2;
        }
        return _v.equalsShortName(_v2) && _v.getVersion().filter().acceptVersion(_v2.getVersion(), session);
    }

    public static boolean matchesArch(String arch, NutsDescriptor desc, NutsSession session) {
        if (NutsUtilStrings.isBlank((CharSequence)arch)) {
            return true;
        }
        NutsIdParser parser = session.getWorkspace().id().parser();
        NutsId _v = parser.parse(arch);
        String[] all = desc.getArch();
        if (all != null && all.length > 0) {
            for (String v : all) {
                if (NutsUtilStrings.isBlank((CharSequence)v)) {
                    return true;
                }
                NutsId y = parser.setLenient(false).parse(v);
                if (!y.equalsShortName(_v) || !y.getVersion().filter().acceptVersion(_v.getVersion(), session)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean matchesOs(String os, NutsDescriptor desc, NutsSession session) {
        if (NutsUtilStrings.isBlank((CharSequence)os)) {
            return true;
        }
        NutsIdParser parser = session.getWorkspace().id().parser();
        NutsId _v = parser.parse(os);
        String[] all = desc.getOs();
        if (all != null && all.length > 0) {
            for (String v : all) {
                if (NutsUtilStrings.isBlank((CharSequence)v)) {
                    return true;
                }
                NutsId y = parser.setLenient(false).parse(v);
                if (!y.equalsShortName(_v) || !y.getVersion().filter().acceptVersion(_v.getVersion(), session)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean matchesOsdist(String osdist, NutsDescriptor desc, NutsSession session) {
        if (NutsUtilStrings.isBlank((CharSequence)osdist)) {
            return true;
        }
        NutsIdParser parser = session.getWorkspace().id().parser();
        NutsId _v = parser.parse(osdist);
        String[] all = desc.getOsdist();
        if (all != null && all.length > 0) {
            for (String v : all) {
                if (NutsUtilStrings.isBlank((CharSequence)v)) {
                    return true;
                }
                NutsId y = parser.setLenient(false).parse(v);
                if (!y.equalsShortName(_v) || !y.getVersion().filter().acceptVersion(_v.getVersion(), session)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean matchesPlatform(String platform, NutsDescriptor desc, NutsSession session) {
        if (NutsUtilStrings.isBlank((CharSequence)platform)) {
            return true;
        }
        NutsIdParser parser = session.getWorkspace().id().parser();
        NutsId _v = parser.parse(platform);
        String[] all = desc.getPlatform();
        if (all != null && all.length > 0) {
            for (String v : all) {
                if (NutsUtilStrings.isBlank((CharSequence)v)) {
                    return true;
                }
                NutsId y = parser.setLenient(false).parse(v);
                if (y.getShortName().equals("java")) {
                    return true;
                }
                if (!y.equalsShortName(_v) || !y.getVersion().filter().acceptVersion(_v.getVersion(), session)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean matchesEnv(String arch, String os, String dist, String platform, NutsDescriptor desc, NutsSession session) {
        if (!CoreFilterUtils.matchesArch(arch, desc, session)) {
            return false;
        }
        if (!CoreFilterUtils.matchesOs(os, desc, session)) {
            return false;
        }
        if (!CoreFilterUtils.matchesOsdist(dist, desc, session)) {
            return false;
        }
        return CoreFilterUtils.matchesPlatform(platform, desc, session);
    }

    public static NutsDependency[] filterDependencies(NutsId from, NutsDependency[] d0, NutsDependencyFilter dependencyFilter, NutsSession session) {
        if (dependencyFilter == null) {
            return d0;
        }
        ArrayList<NutsDependency> r = new ArrayList<NutsDependency>(d0.length);
        for (NutsDependency nutsDependency : d0) {
            if (!dependencyFilter.acceptDependency(from, nutsDependency, session)) continue;
            r.add(nutsDependency);
        }
        return r.toArray(new NutsDependency[0]);
    }

    private static class NutsIdFilterToPredicate
    extends NutsPredicates.BasePredicate<NutsId> {
        private final NutsIdFilter t;
        private final NutsSession session;

        public NutsIdFilterToPredicate(NutsIdFilter t, NutsSession session) {
            this.t = t;
            this.session = session;
        }

        public boolean test(NutsId value) {
            return this.t.acceptId(value, this.session);
        }

        public String toString() {
            return this.t.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            NutsIdFilterToPredicate that = (NutsIdFilterToPredicate)((Object)o);
            return Objects.equals(this.t, that.t) && Objects.equals(this.session, that.session);
        }

        public int hashCode() {
            return Objects.hash(this.t, this.session);
        }
    }
}

