/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.commands.ws;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.NutsArtifactCall;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsExecutionContext;
import net.thevpc.nuts.NutsExecutionType;
import net.thevpc.nuts.NutsRunAs;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.commands.ws.DefaultNutsExecutionContext;
import net.thevpc.nuts.runtime.core.commands.ws.NutsExecutionContextBuilder;

public class DefaultNutsExecutionContextBuilder
implements NutsExecutionContextBuilder {
    private NutsDefinition definition;
    private Map<String, String> env;
    private final List<String> executorArguments = new ArrayList<String>();
    private Map<String, String> executorProperties = new LinkedHashMap<String, String>();
    private String[] arguments;
    private NutsSession execSession;
    private NutsSession traceSession;
    private NutsWorkspace workspace;
    private NutsArtifactCall executorDescriptor;
    private String cwd;
    private String commandName;
    private boolean failFast;
    private boolean temporary;
    private long sleepMillis = 1000L;
    private boolean inheritSystemIO;
    private String redirectOuputFile;
    private String redirectInpuFile;
    private NutsExecutionType executionType;
    private NutsRunAs runAs = NutsRunAs.currentUser();

    public DefaultNutsExecutionContextBuilder() {
    }

    public DefaultNutsExecutionContextBuilder(NutsDefinition definition, String[] arguments, String[] executorArgs, Map<String, String> env, Map<String, String> executorProperties, String cwd, NutsSession traceSession, NutsSession execSession, NutsWorkspace workspace, boolean failFast, boolean temporary, NutsExecutionType executionType, String commandName, long sleepMillis) {
        if (arguments == null) {
            arguments = new String[]{};
        }
        if (executorArgs == null) {
            executorArgs = new String[]{};
        }
        if (executorProperties == null) {
            executorProperties = new LinkedHashMap<String, String>();
        }
        this.commandName = commandName;
        this.definition = definition;
        this.arguments = arguments;
        this.execSession = execSession;
        this.traceSession = traceSession;
        this.workspace = workspace;
        this.executorArguments.addAll(Arrays.asList(executorArgs));
        this.executorProperties.putAll(executorProperties);
        this.sleepMillis = sleepMillis;
        this.cwd = cwd;
        if (env == null) {
            env = new LinkedHashMap<String, String>();
        }
        this.env = env;
        this.failFast = failFast;
        this.temporary = temporary;
        this.executionType = executionType;
        this.executorDescriptor = definition.getDescriptor().getExecutor();
    }

    public DefaultNutsExecutionContextBuilder(NutsExecutionContext other) {
        this.commandName = other.getCommandName();
        this.definition = other.getDefinition();
        this.arguments = other.getArguments();
        this.execSession = other.getExecSession();
        this.traceSession = other.getTraceSession();
        this.workspace = other.getWorkspace();
        this.executorArguments.addAll(Arrays.asList(other.getExecutorArguments()));
        this.executorProperties.putAll(other.getExecutorProperties());
        this.cwd = other.getCwd();
        this.env = other.getEnv();
        this.failFast = other.isFailFast();
        this.temporary = other.isTemporary();
        this.executionType = other.getExecutionType();
        this.executorDescriptor = other.getExecutorDescriptor();
        this.sleepMillis = other.getSleepMillis();
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public long getSleepMillis() {
        return this.sleepMillis;
    }

    @Override
    public String[] getExecutorArguments() {
        return this.executorArguments.toArray(new String[0]);
    }

    @Override
    public Map<String, String> getExecutorProperties() {
        return this.executorProperties;
    }

    @Override
    public NutsDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public String[] getArguments() {
        return this.arguments;
    }

    @Override
    public NutsWorkspace getWorkspace() {
        return this.workspace;
    }

    @Override
    public NutsArtifactCall getExecutorDescriptor() {
        return this.executorDescriptor;
    }

    @Override
    public NutsSession getExecSession() {
        return this.execSession;
    }

    @Override
    public NutsSession getTraceSession() {
        return this.traceSession;
    }

    @Override
    public Map<String, String> getEnv() {
        return this.env;
    }

    @Override
    public String getCwd() {
        return this.cwd;
    }

    @Override
    public boolean isFailFast() {
        return this.failFast;
    }

    @Override
    public boolean isTemporary() {
        return this.temporary;
    }

    @Override
    public NutsExecutionType getExecutionType() {
        return this.executionType;
    }

    @Override
    public NutsRunAs getRunAs() {
        return this.runAs;
    }

    @Override
    public NutsExecutionContextBuilder setDefinition(NutsDefinition definition) {
        this.definition = definition;
        return this;
    }

    @Override
    public NutsExecutionContextBuilder setSleepMillis(long sleepMillis) {
        this.sleepMillis = sleepMillis;
        return this;
    }

    @Override
    public NutsExecutionContextBuilder setEnv(Map<String, String> env) {
        this.env = env;
        return this;
    }

    @Override
    public NutsExecutionContextBuilder setExecutorArguments(String[] executorArguments) {
        this.executorArguments.clear();
        if (executorArguments != null) {
            this.executorArguments.addAll(Arrays.asList(executorArguments));
        }
        return this;
    }

    @Override
    public NutsExecutionContextBuilder addExecutorArguments(String[] executorArguments) {
        if (executorArguments != null) {
            this.executorArguments.addAll(Arrays.asList(executorArguments));
        }
        return this;
    }

    @Override
    public NutsExecutionContextBuilder addExecutorProperties(Map<String, String> executorProperties) {
        if (executorProperties != null) {
            this.executorProperties.putAll(executorProperties);
        }
        return this;
    }

    @Override
    public NutsExecutionContextBuilder setExecutorProperties(Map<String, String> executorProperties) {
        this.executorProperties.clear();
        if (executorProperties != null) {
            this.executorProperties.putAll(executorProperties);
        }
        return this;
    }

    @Override
    public NutsExecutionContextBuilder setArguments(String[] arguments) {
        this.arguments = arguments;
        return this;
    }

    @Override
    public NutsExecutionContextBuilder setExecSession(NutsSession execSession) {
        this.execSession = execSession;
        return this;
    }

    @Override
    public NutsExecutionContextBuilder setTraceSession(NutsSession traceSession) {
        this.traceSession = traceSession;
        return this;
    }

    @Override
    public NutsExecutionContextBuilder setWorkspace(NutsWorkspace workspace) {
        this.workspace = workspace;
        return this;
    }

    @Override
    public NutsExecutionContextBuilder setExecutorDescriptor(NutsArtifactCall executorDescriptor) {
        this.executorDescriptor = executorDescriptor;
        return this;
    }

    @Override
    public NutsExecutionContextBuilder setCwd(String cwd) {
        this.cwd = cwd;
        return this;
    }

    @Override
    public NutsExecutionContextBuilder setCommandName(String commandName) {
        this.commandName = commandName;
        return this;
    }

    @Override
    public NutsExecutionContextBuilder setFailFast(boolean failFast) {
        this.failFast = failFast;
        return this;
    }

    @Override
    public NutsExecutionContextBuilder setTemporary(boolean temporary) {
        this.temporary = temporary;
        return this;
    }

    @Override
    public NutsExecutionContextBuilder setExecutionType(NutsExecutionType executionType) {
        this.executionType = executionType;
        return this;
    }

    @Override
    public NutsExecutionContextBuilder setRunAs(NutsRunAs runAs) {
        this.runAs = runAs == null ? NutsRunAs.currentUser() : runAs;
        return this;
    }

    @Override
    public boolean isInheritSystemIO() {
        return this.inheritSystemIO;
    }

    @Override
    public String getRedirectOuputFile() {
        return this.redirectOuputFile;
    }

    @Override
    public String getRedirectInpuFile() {
        return this.redirectInpuFile;
    }

    @Override
    public NutsExecutionContextBuilder setInheritSystemIO(boolean inheritSystemIO) {
        this.inheritSystemIO = inheritSystemIO;
        return this;
    }

    @Override
    public NutsExecutionContextBuilder setRedirectOuputFile(String redirectOuputFile) {
        this.redirectOuputFile = redirectOuputFile;
        return this;
    }

    @Override
    public NutsExecutionContextBuilder setRedirectInpuFile(String redirectInpuFile) {
        this.redirectInpuFile = redirectInpuFile;
        return this;
    }

    @Override
    public NutsExecutionContext build() {
        return new DefaultNutsExecutionContext(this.definition, this.arguments, this.executorArguments.toArray(new String[0]), this.env, this.executorProperties, this.cwd, this.traceSession, this.execSession, this.workspace, this.failFast, this.temporary, this.executionType, this.commandName, this.sleepMillis, this.inheritSystemIO, this.redirectOuputFile, this.redirectInpuFile);
    }

    @Override
    public NutsExecutionContextBuilder setAll(NutsExecutionContext other) {
        this.commandName = other.getCommandName();
        this.definition = other.getDefinition();
        this.arguments = other.getArguments();
        this.execSession = other.getExecSession();
        this.traceSession = other.getTraceSession();
        this.workspace = other.getWorkspace();
        this.executorArguments.clear();
        this.executorArguments.addAll(Arrays.asList(other.getExecutorArguments()));
        this.executorProperties = other.getExecutorProperties();
        this.cwd = other.getCwd();
        this.env = other.getEnv();
        this.failFast = other.isFailFast();
        this.temporary = other.isTemporary();
        this.executionType = other.getExecutionType();
        this.executorDescriptor = other.getExecutorDescriptor();
        this.sleepMillis = other.getSleepMillis();
        this.inheritSystemIO = other.isInheritSystemIO();
        this.redirectOuputFile = other.getRedirectOutputFile();
        this.redirectInpuFile = other.getRedirectInputFile();
        return this;
    }
}

