/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.commands.ws;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsResultList;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTooManyElementsException;

public abstract class AbstractNutsResultList<T>
implements NutsResultList<T> {
    protected NutsSession session;
    private String nutsBase;

    public AbstractNutsResultList(NutsSession session, String nutsBase) {
        this.session = session;
        this.nutsBase = nutsBase;
    }

    public List<T> list() {
        ArrayList list = new ArrayList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object a = iterator.next();
            list.add(a);
        }
        return list;
    }

    public T first() {
        Iterator it = this.iterator();
        if (it.hasNext()) {
            return (T)it.next();
        }
        return null;
    }

    public T required() throws NutsNotFoundException {
        Iterator it = this.iterator();
        if (it.hasNext()) {
            return (T)it.next();
        }
        NutsId n = this.session.getWorkspace().id().parser().setLenient(true).parse(this.nutsBase);
        if (n != null) {
            throw new NutsNotFoundException(this.session, n);
        }
        throw new NutsNotFoundException(this.session, null, NutsMessage.cstyle((String)"artifact not found: %s%s", (Object[])new Object[]{this.nutsBase == null ? "<null>" : this.nutsBase}), null);
    }

    public T singleton() {
        Iterator it = this.iterator();
        if (it.hasNext()) {
            Object t = it.next();
            if (it.hasNext()) {
                throw new NutsTooManyElementsException(this.session, NutsMessage.cstyle((String)"too many results for %s", (Object[])new Object[]{this.nutsBase}));
            }
            return (T)t;
        }
        NutsId nid = this.session.getWorkspace().id().parser().setLenient(true).parse(this.nutsBase);
        if (nid != null) {
            throw new NutsNotFoundException(this.session, nid);
        }
        throw new NutsNotFoundException(this.session, null, NutsMessage.cstyle((String)"result not found for %s", (Object[])new Object[]{this.nutsBase}));
    }

    public Stream<T> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 16), false);
    }

    public long count() {
        long count = 0L;
        Iterator it = this.iterator();
        if (it.hasNext()) {
            ++count;
        }
        return count;
    }
}

