/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.app;

import net.thevpc.nuts.NutsCommandLineFormatStrategy;
import net.thevpc.nuts.NutsCommandlineFamily;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.core.app.DefaultCommandLineBash;
import net.thevpc.nuts.runtime.core.app.DefaultCommandLineWindowsCmd;

public interface NutsCommandLineBashFamilySupport {
    public static final NutsCommandLineBashFamilySupport BASH = new DefaultCommandLineBash();
    public static final NutsCommandLineBashFamilySupport WINDOWS_CMD = new DefaultCommandLineWindowsCmd();

    public static NutsCommandLineBashFamilySupport of(NutsCommandlineFamily f, NutsSession s) {
        if (f == null) {
            f = NutsCommandlineFamily.DEFAULT;
        }
        if (f == NutsCommandlineFamily.DEFAULT) {
            switch (s.getWorkspace().env().getOsFamily()) {
                case WINDOWS: {
                    return WINDOWS_CMD;
                }
                case LINUX: 
                case MACOS: 
                case UNIX: {
                    return BASH;
                }
            }
        }
        return BASH;
    }

    public String escapeArgument(String var1, NutsCommandLineFormatStrategy var2, NutsSession var3);

    default public String escapeArguments(String[] args, NutsCommandLineFormatStrategy s, NutsSession session) {
        if (s == null) {
            s = NutsCommandLineFormatStrategy.DEFAULT;
        }
        if (s == NutsCommandLineFormatStrategy.DEFAULT) {
            s = NutsCommandLineFormatStrategy.SUPPORT_QUOTES;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(this.escapeArgument(arg, s, session));
        }
        return sb.toString();
    }
}

