/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.app;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.thevpc.nuts.NutsCommandHistory;
import net.thevpc.nuts.NutsCommandHistoryEntry;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.app.NutsCommandHistoryEntryImpl;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;

public class NutsCommandHistoryImpl
implements NutsCommandHistory {
    private NutsWorkspace ws;
    private List<NutsCommandHistoryEntry> entries = new ArrayList<NutsCommandHistoryEntry>();
    private Path path;

    public NutsCommandHistoryImpl(NutsWorkspace ws, Path path) {
        this.ws = ws;
        this.path = path;
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
    }

    public int size() {
        return this.entries.size();
    }

    public void load() {
        this.entries.clear();
        if (Files.exists(this.path, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(this.path, new OpenOption[0]);){
                this.load(in);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
    }

    public void load(InputStream in) {
        this.entries.clear();
        if (in != null) {
            try (BufferedReader out = new BufferedReader(new InputStreamReader(in));){
                String line = null;
                Instant instant = null;
                int index = 0;
                while ((line = out.readLine()) != null) {
                    if (line.length() <= 0) continue;
                    if (line.startsWith("#")) {
                        if (!line.startsWith("#at:")) continue;
                        instant = Instant.parse(line.substring("#at:".length()).trim());
                        continue;
                    }
                    this.entries.add(new NutsCommandHistoryEntryImpl(index, line, instant));
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
    }

    public void save(OutputStream outs) {
        try (PrintStream out = new PrintStream(outs);){
            for (NutsCommandHistoryEntry entry : this.entries) {
                out.println("#at:" + entry.getTime().toString());
                out.println(entry.getLine().replace("\n", "\\n").replace("\r", "\\r"));
            }
        }
    }

    public void save() {
        Path p = this.path.getParent();
        CoreIOUtils.mkdirs(p);
        try (OutputStream out = Files.newOutputStream(this.path, new OpenOption[0]);){
            this.save(out);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public void purge() {
        this.entries.clear();
        if (Files.exists(this.path, new LinkOption[0])) {
            try {
                Files.delete(this.path);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
    }

    public NutsCommandHistoryEntry getEntry(int index) {
        return this.entries.get(index);
    }

    public ListIterator<NutsCommandHistoryEntry> iterator(int index) {
        return this.entries.listIterator(index);
    }

    public void add(Instant time, String line) {
        this.entries.add(new NutsCommandHistoryEntryImpl(this.entries.size(), line, time));
    }
}

