/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.app;

import java.util.List;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsArgumentCandidate;
import net.thevpc.nuts.NutsArgumentCandidateBuilder;
import net.thevpc.nuts.NutsArgumentName;
import net.thevpc.nuts.NutsCommandHistoryBuilder;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCommandLineFormat;
import net.thevpc.nuts.NutsCommandLineManager;
import net.thevpc.nuts.NutsCommandlineFamily;
import net.thevpc.nuts.NutsDefaultArgumentCandidate;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.app.ArchitectureNonOption;
import net.thevpc.nuts.runtime.core.app.DefaultCommandLineBash;
import net.thevpc.nuts.runtime.core.app.DefaultCommandLineWindowsCmd;
import net.thevpc.nuts.runtime.core.app.DefaultNonOption;
import net.thevpc.nuts.runtime.core.app.DefaultNutsArgument;
import net.thevpc.nuts.runtime.core.app.DefaultNutsArgumentCandidateBuilder;
import net.thevpc.nuts.runtime.core.app.DefaultNutsCommandLine;
import net.thevpc.nuts.runtime.core.app.DefaultNutsCommandLineFormat;
import net.thevpc.nuts.runtime.core.app.ExtensionNonOption;
import net.thevpc.nuts.runtime.core.app.FileNonOption;
import net.thevpc.nuts.runtime.core.app.GroupNonOption;
import net.thevpc.nuts.runtime.core.app.NutsCommandHistoryBuilderImpl;
import net.thevpc.nuts.runtime.core.app.PackagingNonOption;
import net.thevpc.nuts.runtime.core.app.PermissionNonOption;
import net.thevpc.nuts.runtime.core.app.RepositoryNonOption;
import net.thevpc.nuts.runtime.core.app.RepositoryTypeNonOption;
import net.thevpc.nuts.runtime.core.app.UserNonOption;
import net.thevpc.nuts.runtime.core.app.ValueNonOption;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class DefaultNutsCommandLineManager
implements NutsCommandLineManager {
    private NutsWorkspace ws;
    private NutsSession session;
    private NutsCommandlineFamily family = NutsCommandlineFamily.DEFAULT;

    public DefaultNutsCommandLineManager(NutsWorkspace ws) {
        this.ws = ws;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsCommandLineManager setSession(NutsSession session) {
        this.session = session;
        return this;
    }

    public NutsCommandlineFamily getCommandlineFamily() {
        return this.family;
    }

    public NutsCommandLineManager setCommandlineFamily(NutsCommandlineFamily family) {
        this.family = family == null ? NutsCommandlineFamily.DEFAULT : family;
        return this;
    }

    public NutsWorkspace getWorkspace() {
        return this.ws;
    }

    public NutsCommandLineFormat formatter(NutsCommandLine commandLine) {
        return this.formatter().setValue(commandLine);
    }

    public NutsCommandLineFormat formatter() {
        return ((NutsCommandLineFormat)new DefaultNutsCommandLineFormat(this.getWorkspace()).setSession(this.session)).setCommandlineFamily(this.getCommandlineFamily());
    }

    public NutsCommandLine parse(String line) {
        this.checkSession();
        return new DefaultNutsCommandLine(this.getSession(), this.parseCommandLineArr(line));
    }

    private String[] parseCommandLineArr(String line) {
        NutsCommandlineFamily f = this.getCommandlineFamily();
        if (f == null) {
            f = NutsCommandlineFamily.DEFAULT;
        }
        if (f == NutsCommandlineFamily.DEFAULT) {
            switch (this.getWorkspace().env().getOsFamily()) {
                case WINDOWS: {
                    f = NutsCommandlineFamily.WINDOWS_CMD;
                    break;
                }
                case LINUX: {
                    f = NutsCommandlineFamily.BASH;
                    break;
                }
                default: {
                    f = NutsCommandlineFamily.BASH;
                }
            }
        }
        switch (f) {
            case WINDOWS_CMD: {
                return new DefaultCommandLineWindowsCmd().parseCommandLineArrBash(line, this.getSession());
            }
            case BASH: {
                return new DefaultCommandLineBash().parseCommandLineArrBash(line, this.getSession());
            }
        }
        return new DefaultCommandLineBash().parseCommandLineArrBash(line, this.getSession());
    }

    protected void checkSession() {
        NutsWorkspaceUtils.checkSession(this.ws, this.session);
    }

    public NutsCommandLine create(String ... args) {
        this.checkSession();
        return new DefaultNutsCommandLine(this.getSession(), args);
    }

    public NutsCommandLine create(List<String> args) {
        this.checkSession();
        return new DefaultNutsCommandLine(this.getSession(), args, null);
    }

    public NutsArgumentCandidateBuilder createCandidate() {
        this.checkSession();
        return new DefaultNutsArgumentCandidateBuilder();
    }

    public NutsArgument createArgument(String argument) {
        this.checkSession();
        return Factory.createArgument0(this.getWorkspace(), argument, '=');
    }

    public NutsArgumentName createName(String type, String label) {
        this.checkSession();
        return Factory.createName0(this.getSession(), type, label);
    }

    public NutsArgumentName createName(String type) {
        this.checkSession();
        return this.createName(type, type);
    }

    public NutsCommandHistoryBuilder createHistory() {
        return new NutsCommandHistoryBuilderImpl(this.ws);
    }

    public static class Factory {
        public static NutsArgument createArgument0(NutsWorkspace ws, String argument, char eq) {
            return new DefaultNutsArgument(argument, eq);
        }

        public static NutsArgumentCandidate createCandidate0(NutsWorkspace ws, String value, String label) {
            return new NutsDefaultArgumentCandidate(value, NutsUtilStrings.isBlank((CharSequence)label) ? value : label);
        }

        public static NutsArgumentName createName0(NutsSession session, String type, String label) {
            if (type == null) {
                type = "";
            }
            if (label == null) {
                label = type;
            }
            switch (type) {
                case "arch": {
                    return new ArchitectureNonOption(label);
                }
                case "packaging": {
                    return new PackagingNonOption(label);
                }
                case "extension": {
                    return new ExtensionNonOption(type, session);
                }
                case "file": {
                    return new FileNonOption(type);
                }
                case "boolean": {
                    return new ValueNonOption(type, "true", "false");
                }
                case "repository": {
                    return new RepositoryNonOption(label);
                }
                case "repository-type": {
                    return new RepositoryTypeNonOption(label);
                }
                case "right": {
                    return new PermissionNonOption(label, null, false);
                }
                case "user": {
                    return new UserNonOption(label);
                }
                case "group": {
                    return new GroupNonOption(label);
                }
            }
            return new DefaultNonOption(label);
        }
    }
}

