/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.app;

import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCommandLineFormat;
import net.thevpc.nuts.NutsCommandLineFormatStrategy;
import net.thevpc.nuts.NutsCommandlineFamily;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.app.NutsCommandLineBashFamilySupport;
import net.thevpc.nuts.runtime.core.format.DefaultFormatBase;

public class DefaultNutsCommandLineFormat
extends DefaultFormatBase<NutsCommandLineFormat>
implements NutsCommandLineFormat {
    private NutsCommandLine value;
    private NutsCommandlineFamily formatFamily = NutsCommandlineFamily.DEFAULT;
    private NutsCommandLineFormatStrategy formatStrategy = NutsCommandLineFormatStrategy.DEFAULT;

    public DefaultNutsCommandLineFormat(NutsWorkspace ws) {
        super(ws, "commandline");
    }

    @Override
    public NutsCommandLineFormat setNtf(boolean ntf) {
        super.setNtf(ntf);
        return this;
    }

    public NutsCommandLineFormat setValue(NutsCommandLine value) {
        this.value = value;
        return this;
    }

    public NutsCommandLineFormat setValue(String[] args) {
        this.checkSession();
        return this.setValue(args == null ? null : this.getSession().getWorkspace().commandLine().create(args));
    }

    public NutsCommandLineFormat setValue(String args) {
        return this.setValue(args == null ? null : this.getSession().getWorkspace().commandLine().parse(args));
    }

    public NutsCommandlineFamily getCommandlineFamily() {
        return this.formatFamily;
    }

    public NutsCommandLineFormat setCommandlineFamily(NutsCommandlineFamily family) {
        this.formatFamily = family == null ? NutsCommandlineFamily.DEFAULT : family;
        return this;
    }

    public NutsCommandLineFormatStrategy getFormatStrategy() {
        return this.formatStrategy;
    }

    public void setFormatStrategy(NutsCommandLineFormatStrategy formatStrategy) {
        this.formatStrategy = formatStrategy == null ? NutsCommandLineFormatStrategy.DEFAULT : formatStrategy;
    }

    public NutsCommandLine getValue() {
        return this.value;
    }

    public boolean configureFirst(NutsCommandLine commandLine) {
        return false;
    }

    @Override
    public void print(NutsPrintStream out) {
        this.checkSession();
        if (this.value != null) {
            String cmd = NutsCommandLineBashFamilySupport.of(this.getCommandlineFamily(), this.getSession()).escapeArguments(this.value.toStringArray(), this.getFormatStrategy(), this.getSession());
            if (this.isNtf()) {
                out.print("```sh " + cmd + "```");
            } else {
                out.print(cmd);
            }
        }
    }
}

