/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.app;

import java.io.IOException;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.util.NoSuchElementException;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.core.filters.DefaultNutsTokenFilter;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;

public class DefaultNutsArgument
extends DefaultNutsTokenFilter
implements NutsArgument {
    boolean enabled = true;
    boolean negated = false;
    String optionPrefix = null;
    String optionName = null;
    String keyPart = null;
    String valuePart = null;
    private final char eq;

    public DefaultNutsArgument(String expression) {
        this(expression, '\u0000');
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DefaultNutsArgument(String expression, char eq) {
        super(expression);
        if (expression != null) {
            if (expression.length() == 0) {
                this.optionPrefix = "";
                this.optionName = "";
                this.keyPart = "";
            } else if (expression.length() == 1) {
                switch (expression.charAt(0)) {
                    case '+': 
                    case '-': {
                        this.optionPrefix = expression;
                        this.optionName = "";
                        this.keyPart = expression;
                        break;
                    }
                    default: {
                        this.optionPrefix = "";
                        this.optionName = "";
                        this.keyPart = expression;
                        break;
                    }
                }
            } else {
                StringReader reader = new StringReader(expression);
                int r = -1;
                boolean EXPECT_OPTION = true;
                int EXPECT_COMMENT = 2;
                int EXPECT_NEG = 3;
                int EXPECT_NAME = 4;
                int EXPECT_VAL = 5;
                int status = 1;
                StringBuilder b_option_prefix = new StringBuilder();
                StringBuilder b_option_name = new StringBuilder();
                StringBuilder b_key = new StringBuilder();
                StringBuilder b_val = null;
                try {
                    block12: while ((r = reader.read()) != -1) {
                        char c = (char)r;
                        switch (status) {
                            case 1: {
                                if (c == '-' || c == '+') {
                                    b_option_prefix.append(c);
                                    b_key.append(c);
                                    if (b_option_prefix.length() < 2) continue block12;
                                    status = 2;
                                    continue block12;
                                }
                                if (c == '/') {
                                    reader.mark(1);
                                    r = reader.read();
                                    if (r == 47) {
                                        this.enabled = false;
                                        status = 3;
                                        continue block12;
                                    }
                                    if (b_option_prefix.length() > 0) {
                                        b_option_name.append('/');
                                    }
                                    b_key.append('/');
                                    if (r != -1) {
                                        reader.reset();
                                    }
                                    status = 4;
                                    continue block12;
                                }
                                if (c == '!') {
                                    this.negated = true;
                                    status = 4;
                                    continue block12;
                                }
                                if (DefaultNutsArgument.isEq(c, eq)) {
                                    eq = c;
                                    status = 5;
                                    b_val = new StringBuilder();
                                    continue block12;
                                }
                                if (b_option_prefix.length() > 0) {
                                    b_option_name.append(c);
                                }
                                b_key.append(c);
                                status = 4;
                                continue block12;
                            }
                            case 2: {
                                if (c == '/') {
                                    reader.mark(1);
                                    r = reader.read();
                                    if (r == 47) {
                                        this.enabled = false;
                                        status = 3;
                                        continue block12;
                                    }
                                    b_option_name.append('/');
                                    if (r != -1) {
                                        reader.reset();
                                    }
                                    status = 4;
                                    continue block12;
                                }
                                if (c == '!') {
                                    this.negated = true;
                                    status = 4;
                                    continue block12;
                                }
                                if (DefaultNutsArgument.isEq(c, eq)) {
                                    eq = c;
                                    status = 5;
                                    b_val = new StringBuilder();
                                    continue block12;
                                }
                                if (b_option_prefix.length() > 0) {
                                    b_option_name.append(c);
                                }
                                b_key.append(c);
                                status = 4;
                                continue block12;
                            }
                            case 3: {
                                if (c == '!') {
                                    this.negated = true;
                                    status = 4;
                                    continue block12;
                                }
                                if (DefaultNutsArgument.isEq(c, eq)) {
                                    eq = c;
                                    status = 5;
                                    b_val = new StringBuilder();
                                    continue block12;
                                }
                                if (b_option_prefix.length() > 0) {
                                    b_option_name.append(c);
                                }
                                b_key.append(c);
                                status = 4;
                                continue block12;
                            }
                            case 4: {
                                if (DefaultNutsArgument.isEq(c, eq)) {
                                    eq = c;
                                    status = 5;
                                    b_val = new StringBuilder();
                                    continue block12;
                                }
                                if (b_option_prefix.length() > 0) {
                                    b_option_name.append(c);
                                }
                                b_key.append(c);
                                status = 4;
                                continue block12;
                            }
                            case 5: {
                                b_val.append(c);
                                continue block12;
                            }
                        }
                        throw new IllegalStateException("Unsupported state");
                    }
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
                this.optionPrefix = b_option_prefix.toString();
                this.optionName = b_option_name.toString();
                this.keyPart = b_key.toString();
                this.valuePart = b_val == null ? null : b_val.toString();
            }
        }
        this.eq = (char)(eq == '\u0000' ? 61 : (int)eq);
    }

    private static boolean isEq(char found, char expected) {
        return expected == '\u0000' ? found == '=' || found == ':' : found == expected;
    }

    public boolean isUnsupported() {
        return this.expression != null && (this.expression.startsWith("-!!") || this.expression.startsWith("--!!") || this.expression.startsWith("---") || this.expression.startsWith("++") || this.expression.startsWith("!!"));
    }

    public boolean isOption() {
        return this.optionPrefix != null && this.optionPrefix.length() > 0;
    }

    public boolean isNonOption() {
        return !this.isOption();
    }

    public boolean isKeyValue() {
        return this.valuePart != null;
    }

    public String getStringOptionPrefix() {
        return this.optionPrefix;
    }

    public String getKeyValueSeparator() {
        return String.valueOf(this.eq);
    }

    public NutsArgument getArgumentKey() {
        if (this.expression == null) {
            return this;
        }
        return new DefaultNutsArgument(this.keyPart, this.eq);
    }

    public NutsArgument getArgumentOptionName() {
        if (this.expression == null) {
            return this;
        }
        return new DefaultNutsArgument(this.optionName, this.eq);
    }

    public String getStringOptionName() {
        return this.optionName;
    }

    public NutsArgument getArgumentValue() {
        if (this.expression == null) {
            return this;
        }
        return new DefaultNutsArgument(this.valuePart, this.eq);
    }

    public String getString() {
        return this.expression;
    }

    public String getString(String defaultValue) {
        return this.expression == null ? defaultValue : this.expression;
    }

    @Override
    public boolean isNull() {
        return this.expression == null;
    }

    @Override
    public boolean isBlank() {
        return this.expression == null || this.expression.trim().isEmpty();
    }

    public boolean isNegated() {
        return this.negated;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isInt() {
        try {
            if (this.expression != null) {
                Integer.parseInt(this.expression);
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public int getInt() {
        if (NutsUtilStrings.isBlank((CharSequence)this.expression)) {
            throw new NumberFormatException("missing value");
        }
        return Integer.parseInt(this.expression);
    }

    public int getIntValue(int defaultValue) {
        return this.getArgumentValue().getInt(defaultValue);
    }

    public int getIntValue() {
        try {
            return this.getArgumentValue().getInt();
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("invalid int value for " + this.getString() + ": " + CoreStringUtils.exceptionToString(e));
        }
    }

    public long getLongValue() {
        try {
            return this.getArgumentValue().getLong();
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("invalid long value for " + this.getString() + ": " + CoreStringUtils.exceptionToString(e));
        }
    }

    public double getDoubleValue() {
        try {
            return this.getArgumentValue().getDouble();
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("invalid double value for " + this.getString() + ": " + CoreStringUtils.exceptionToString(e));
        }
    }

    public int getInt(int defaultValue) {
        if (NutsUtilStrings.isBlank((CharSequence)this.expression)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(this.expression);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public boolean isLong() {
        try {
            if (this.expression != null) {
                Long.parseLong(this.expression);
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public long getLong() {
        if (NutsUtilStrings.isBlank((CharSequence)this.expression)) {
            throw new NumberFormatException("missing value");
        }
        return Long.parseLong(this.expression);
    }

    public long getLong(long defaultValue) {
        if (NutsUtilStrings.isBlank((CharSequence)this.expression)) {
            return defaultValue;
        }
        try {
            return Long.parseLong(this.expression);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public boolean isDouble() {
        try {
            if (this.expression != null) {
                Double.parseDouble(this.expression);
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public double getDouble() {
        if (NutsUtilStrings.isBlank((CharSequence)this.expression)) {
            throw new NumberFormatException("missing value");
        }
        return Double.parseDouble(this.expression);
    }

    public double getDouble(double defaultValue) {
        if (NutsUtilStrings.isBlank((CharSequence)this.expression)) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(this.expression);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public boolean getBoolean() {
        boolean b = NutsUtilStrings.parseBoolean((String)this.expression, (Boolean)false, (Boolean)false);
        if (this.isNegated()) {
            return !b;
        }
        return b;
    }

    public boolean isBoolean() {
        return NutsUtilStrings.parseBoolean((String)this.expression, null, null) != null;
    }

    public Boolean getBoolean(Boolean defaultValue) {
        return NutsUtilStrings.parseBoolean((String)this.expression, (Boolean)defaultValue, (Boolean)false);
    }

    public String toString() {
        return String.valueOf(this.expression);
    }

    public NutsArgument required() {
        if (this.expression == null) {
            throw new NoSuchElementException("missing value");
        }
        return this;
    }

    public String getStringKey() {
        return this.getArgumentKey().getString();
    }

    public String getStringValue() {
        return this.getArgumentValue().getString();
    }

    public boolean getBooleanValue() {
        return this.getArgumentValue().getBoolean();
    }

    public Boolean getBooleanValue(Boolean defaultValue) {
        return this.getArgumentValue().getBoolean(defaultValue);
    }

    public String getStringValue(String defaultValue) {
        return this.getArgumentValue().getString(defaultValue);
    }
}

