/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.app;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.NutsAppVersionStoreLocationSupplier;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsApplicationMode;
import net.thevpc.nuts.NutsApplications;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsArgumentCandidate;
import net.thevpc.nuts.NutsCommandAutoComplete;
import net.thevpc.nuts.NutsCommandAutoCompleteBase;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCommandLineConfigurable;
import net.thevpc.nuts.NutsCommandLineProcessor;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceLocationManager;
import net.thevpc.nuts.runtime.core.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.core.app.DefaultNutsCommandLine;
import net.thevpc.nuts.runtime.core.app.NutsCommandLineUtils;
import net.thevpc.nuts.runtime.standalone.util.NutsConfigurableHelper;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class DefaultNutsApplicationContext
implements NutsApplicationContext {
    private final Class appClass;
    private NutsWorkspace workspace;
    private NutsSession session;
    private String[] folders = new String[NutsStoreLocation.values().length];
    private String[] sharedFolders = new String[NutsStoreLocation.values().length];
    private NutsId appId;
    private long startTimeMillis;
    private String[] args;
    private NutsApplicationMode mode = NutsApplicationMode.RUN;
    private NutsAppVersionStoreLocationSupplier appVersionStoreLocationSupplier;
    private NutsVersion appPreviousVersion;
    private NutsCommandAutoComplete autoComplete;
    private String[] modeArgs = new String[0];

    public DefaultNutsApplicationContext(NutsWorkspace workspace, NutsSession session, String[] args, Class appClass, String storeId, long startTimeMillis) {
        NutsId _appId;
        long l = this.startTimeMillis = startTimeMillis <= 0L ? System.currentTimeMillis() : startTimeMillis;
        if (workspace == null && session == null) {
            throw new IllegalArgumentException("missing workpace and/or session");
        }
        if (workspace != null) {
            if (session == null) {
                this.session = workspace.createSession();
            } else {
                NutsWorkspaceUtils.checkSession(workspace, session);
                this.session = session.copy();
            }
            this.workspace = this.session.getWorkspace();
        } else {
            this.session = session;
            this.workspace = session.getWorkspace();
        }
        session = this.session;
        int wordIndex = -1;
        if (args.length > 0 && args[0].startsWith("--nuts-exec-mode=")) {
            NutsCommandLine execModeCommand = this.workspace.commandLine().parse(args[0].substring(args[0].indexOf(61) + 1));
            if (execModeCommand.hasNext()) {
                NutsArgument a = execModeCommand.next();
                switch (a.getStringKey()) {
                    case "auto-complete": {
                        this.mode = NutsApplicationMode.AUTO_COMPLETE;
                        if (execModeCommand.hasNext()) {
                            wordIndex = execModeCommand.next().getInt();
                        }
                        this.modeArgs = execModeCommand.toStringArray();
                        execModeCommand.skipAll();
                        break;
                    }
                    case "install": {
                        this.mode = NutsApplicationMode.INSTALL;
                        this.modeArgs = execModeCommand.toStringArray();
                        execModeCommand.skipAll();
                        break;
                    }
                    case "uninstall": {
                        this.mode = NutsApplicationMode.UNINSTALL;
                        this.modeArgs = execModeCommand.toStringArray();
                        execModeCommand.skipAll();
                        break;
                    }
                    case "update": {
                        this.mode = NutsApplicationMode.UPDATE;
                        if (execModeCommand.hasNext()) {
                            this.appPreviousVersion = this.workspace.version().parser().parse(execModeCommand.next().getString());
                        }
                        this.modeArgs = execModeCommand.toStringArray();
                        execModeCommand.skipAll();
                        break;
                    }
                    default: {
                        throw new NutsExecutionException(session, NutsMessage.cstyle((String)"Unsupported nuts-exec-mode : %s", (Object[])new Object[]{args[0]}), 205);
                    }
                }
            }
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        if ((_appId = (NutsId)NutsApplications.getSharedMap().get("nuts.embedded.application.id")) == null) {
            _appId = this.workspace.id().setSession(session).resolveId(appClass);
        }
        if (_appId == null) {
            throw new NutsExecutionException(session, NutsMessage.cstyle((String)"invalid Nuts Application (%s). Id cannot be resolved", (Object[])new Object[]{appClass.getName()}), 203);
        }
        this.args = args;
        this.appId = _appId;
        this.appClass = appClass;
        this.session.setAppId(this.appId);
        NutsWorkspaceLocationManager locations = this.workspace.locations().setSession(session);
        for (NutsStoreLocation folder : NutsStoreLocation.values()) {
            this.setFolder(folder, locations.getStoreLocation(this.appId, folder));
            this.setSharedFolder(folder, locations.getStoreLocation(this.appId.builder().setVersion("SHARED").build(), folder));
        }
        if (this.mode == NutsApplicationMode.AUTO_COMPLETE) {
            if (wordIndex < 0) {
                wordIndex = args.length;
            }
            this.autoComplete = new AppCommandAutoComplete(this.session, args, wordIndex, this.getSession().out());
        } else {
            this.autoComplete = null;
        }
    }

    public NutsApplicationMode getMode() {
        return this.mode;
    }

    public NutsApplicationContext setMode(NutsApplicationMode mode) {
        this.mode = mode;
        return this;
    }

    public String[] getModeArguments() {
        return this.modeArgs;
    }

    public NutsApplicationContext setModeArgs(String[] modeArgs) {
        this.modeArgs = modeArgs;
        return this;
    }

    public NutsCommandAutoComplete getAutoComplete() {
        return this.autoComplete;
    }

    public final NutsApplicationContext configure(boolean skipUnsupported, String ... args) {
        NutsId appId = this.getAppId();
        String appName = appId == null ? "app" : appId.getArtifactId();
        return (NutsApplicationContext)NutsConfigurableHelper.configure((NutsCommandLineConfigurable)this, this.getSession(), skipUnsupported, args, appName);
    }

    public final boolean configure(boolean skipUnsupported, NutsCommandLine commandLine) {
        return NutsConfigurableHelper.configure((NutsCommandLineConfigurable)this, this.getSession(), skipUnsupported, commandLine);
    }

    public boolean configureFirst(NutsCommandLine cmd) {
        NutsArgument a = cmd.peek();
        if (a == null) {
            return false;
        }
        boolean enabled = a.isEnabled();
        switch (a.getStringKey()) {
            case "-?": 
            case "-h": 
            case "--help": {
                cmd.skip();
                if (!enabled) break;
                if (cmd.isExecMode()) {
                    this.printHelp();
                }
                cmd.skipAll();
                throw new NutsExecutionException(this.session, NutsMessage.cstyle((String)"help", (Object[])new Object[0]), 0);
            }
            case "--skip-event": {
                switch (this.getMode()) {
                    case INSTALL: 
                    case UNINSTALL: 
                    case UPDATE: {
                        if (!enabled) break;
                        cmd.skip();
                        throw new NutsExecutionException(this.session, NutsMessage.cstyle((String)"skip-event", (Object[])new Object[0]), 0);
                    }
                }
                return true;
            }
            case "--version": {
                cmd.skip();
                if (enabled) {
                    if (cmd.isExecMode()) {
                        this.getSession().out().printf("%s%n", new Object[]{this.getWorkspace().id().setSession(this.session).resolveId(this.getClass()).getVersion().toString()});
                        cmd.skipAll();
                    }
                    throw new NutsExecutionException(this.session, NutsMessage.cstyle((String)"version", (Object[])new Object[0]), 0);
                }
                return true;
            }
            default: {
                if (this.getSession() == null || !this.getSession().configureFirst(cmd)) break;
                return true;
            }
        }
        return false;
    }

    public void printHelp() {
        String h = NutsWorkspaceExt.of(this.getWorkspace()).resolveDefaultHelp(this.getAppClass(), this.session);
        if (h == null) {
            h = "Help is ```error missing```.";
        }
        this.getSession().out().println(h);
        this.getSession().out().flush();
    }

    public Class getAppClass() {
        return this.appClass;
    }

    public NutsWorkspace getWorkspace() {
        return this.workspace;
    }

    public NutsApplicationContext setWorkspace(NutsWorkspace workspace) {
        this.workspace = workspace;
        return this;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsApplicationContext setSession(NutsSession session) {
        this.session = session;
        return this;
    }

    public String getAppsFolder() {
        return this.getFolder(NutsStoreLocation.APPS);
    }

    public String getConfigFolder() {
        return this.getFolder(NutsStoreLocation.CONFIG);
    }

    public String getLogFolder() {
        return this.getFolder(NutsStoreLocation.LOG);
    }

    public String getTempFolder() {
        return this.getFolder(NutsStoreLocation.TEMP);
    }

    public String getVarFolder() {
        return this.getFolder(NutsStoreLocation.VAR);
    }

    public String getLibFolder() {
        return this.getFolder(NutsStoreLocation.LIB);
    }

    public String getRunFolder() {
        return this.getFolder(NutsStoreLocation.RUN);
    }

    public String getCacheFolder() {
        return this.getFolder(NutsStoreLocation.CACHE);
    }

    public String getFolder(NutsStoreLocation location) {
        return this.folders[location.ordinal()];
    }

    public String getVersionFolderFolder(NutsStoreLocation location, String version) {
        String r;
        if (version == null || version.isEmpty() || version.equalsIgnoreCase("current") || version.equals(this.getAppId().getVersion().getValue())) {
            return this.getFolder(location);
        }
        if (this.appVersionStoreLocationSupplier != null && (r = this.appVersionStoreLocationSupplier.getStoreLocation(location, version)) != null) {
            return r;
        }
        return this.workspace.locations().getStoreLocation(this.getAppId().builder().setVersion(version).build(), location);
    }

    public NutsApplicationContext setFolder(NutsStoreLocation location, String folder) {
        this.folders[location.ordinal()] = folder;
        return this;
    }

    public NutsApplicationContext setSharedFolder(NutsStoreLocation location, String folder) {
        this.sharedFolders[location.ordinal()] = folder;
        return this;
    }

    public String getSharedAppsFolder() {
        return this.getSharedFolder(NutsStoreLocation.APPS);
    }

    public String getSharedConfigFolder() {
        return this.getSharedFolder(NutsStoreLocation.CONFIG);
    }

    public String getSharedLogFolder() {
        return this.getSharedFolder(NutsStoreLocation.LOG);
    }

    public String getSharedTempFolder() {
        return this.getSharedFolder(NutsStoreLocation.TEMP);
    }

    public String getSharedVarFolder() {
        return this.getSharedFolder(NutsStoreLocation.VAR);
    }

    public String getSharedLibFolder() {
        return this.getSharedFolder(NutsStoreLocation.LIB);
    }

    public String getSharedRunFolder() {
        return this.getSharedFolder(NutsStoreLocation.RUN);
    }

    public String getSharedFolder(NutsStoreLocation location) {
        return this.sharedFolders[location.ordinal()];
    }

    public NutsId getAppId() {
        return this.appId;
    }

    public NutsVersion getAppVersion() {
        return this.appId == null ? null : this.appId.getVersion();
    }

    public NutsApplicationContext setAppId(NutsId appId) {
        this.appId = appId;
        return this;
    }

    public String[] getArguments() {
        return this.args;
    }

    public NutsApplicationContext setArgs(String[] args) {
        this.args = args;
        return this;
    }

    public NutsCommandLine getCommandLine() {
        return this.workspace.commandLine().setSession(this.getSession()).create(this.getArguments()).setCommandName(this.getAppId().getArtifactId()).setAutoComplete(this.getAutoComplete());
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public NutsApplicationContext setStartTimeMillis(long startTimeMillis) {
        this.startTimeMillis = startTimeMillis;
        return this;
    }

    public NutsVersion getAppPreviousVersion() {
        return this.appPreviousVersion;
    }

    public NutsApplicationContext setAppPreviousVersion(NutsVersion previousVersion) {
        this.appPreviousVersion = previousVersion;
        return this;
    }

    public boolean isExecMode() {
        return this.getAutoComplete() == null;
    }

    public void processCommandLine(NutsCommandLineProcessor commandLineProcessor) {
        this.getCommandLine().process((NutsCommandLineConfigurable)this, commandLineProcessor);
    }

    public void configureLast(NutsCommandLine commandLine) {
        if (!this.configureFirst(commandLine)) {
            commandLine.unexpectedArgument();
        }
    }

    public NutsAppVersionStoreLocationSupplier getAppVersionStoreLocationSupplier() {
        return this.appVersionStoreLocationSupplier;
    }

    public NutsApplicationContext setAppVersionStoreLocationSupplier(NutsAppVersionStoreLocationSupplier appVersionStoreLocationSupplier) {
        this.appVersionStoreLocationSupplier = appVersionStoreLocationSupplier;
        return this;
    }

    private static class AppCommandAutoComplete
    extends NutsCommandAutoCompleteBase {
        private final ArrayList<String> words;
        private int wordIndex;
        private final NutsPrintStream out0;
        private final NutsSession session;

        public AppCommandAutoComplete(NutsSession session, String[] args, int wordIndex, NutsPrintStream out0) {
            this.session = session;
            this.words = new ArrayList<String>(Arrays.asList(args));
            this.wordIndex = wordIndex;
            this.out0 = out0;
        }

        public NutsSession getSession() {
            return this.session;
        }

        protected NutsArgumentCandidate addCandidatesImpl(NutsArgumentCandidate value) {
            NutsArgumentCandidate c = super.addCandidatesImpl(value);
            String v = value.getValue();
            if (v == null) {
                throw new NutsExecutionException(this.session, NutsMessage.cstyle((String)"candidate cannot be null", (Object[])new Object[0]), 2);
            }
            String d = value.getDisplay();
            if (Objects.equals(v, d) || d == null) {
                this.out0.printf("%s%n", new Object[]{"```error Candidate```: " + NutsCommandLineUtils.escapeArgument(v)});
            } else {
                this.out0.printf("%s%n", new Object[]{"```error Candidate```: " + NutsCommandLineUtils.escapeArgument(v) + " " + NutsCommandLineUtils.escapeArgument(d)});
            }
            return c;
        }

        public String getLine() {
            return new DefaultNutsCommandLine(this.getSession()).setArguments(this.getWords()).toString();
        }

        public List<String> getWords() {
            return this.words;
        }

        public int getCurrentWordIndex() {
            return this.wordIndex;
        }
    }
}

