/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashMap;
import net.thevpc.nuts.NutsClassLoaderNode;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsWorkspace;

public class DefaultNutsClassLoader
extends URLClassLoader {
    private String name;
    private NutsWorkspace ws;
    private LinkedHashMap<String, NutsClassLoaderNode> nodes = new LinkedHashMap();
    private LinkedHashMap<String, NutsClassLoaderNode> effective = new LinkedHashMap();

    public DefaultNutsClassLoader(String name, NutsWorkspace ws, ClassLoader parent) {
        super(new URL[0], parent);
        this.name = name;
        this.ws = ws;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean contains(NutsClassLoaderNode node, boolean deep) {
        return this.search(node, deep) != null;
    }

    public NutsClassLoaderNode search(NutsClassLoaderNode node, boolean deep) {
        NutsId ii = this.ws.id().parser().parse(node.getId());
        String sn = ii.getShortName();
        NutsClassLoaderNode o = this.nodes.get(sn);
        if (o != null) {
            return o;
        }
        if (deep && (o = this.effective.get(sn)) != null) {
            return o;
        }
        ClassLoader p = this.getParent();
        if (p instanceof DefaultNutsClassLoader) {
            return ((DefaultNutsClassLoader)p).search(node, deep);
        }
        return null;
    }

    public boolean add(NutsClassLoaderNode node) {
        NutsId ii = this.ws.id().parser().parse(node.getId());
        String sn = ii.getShortName();
        if (!this.nodes.containsKey(sn)) {
            this.nodes.put(sn, node);
            return this.add(node, true);
        }
        return false;
    }

    protected boolean add(NutsClassLoaderNode node, boolean deep) {
        String s = node.getId();
        NutsId ii = this.ws.id().parser().parse(s);
        String sn = ii.getShortName();
        if (!this.effective.containsKey(sn)) {
            this.effective.put(sn, node);
            super.addURL(node.getURL());
            if (deep) {
                for (NutsClassLoaderNode dependency : node.getDependencies()) {
                    this.add(dependency, true);
                }
            }
            return true;
        }
        if (deep) {
            for (NutsClassLoaderNode dependency : node.getDependencies()) {
                this.add(dependency, true);
            }
        }
        return false;
    }

    @Override
    public void addURL(URL url) {
        throw new IllegalArgumentException("unsupported addURL");
    }

    public String toString() {
        return "NutsURLClassLoader{name='" + this.name + '\'' + '}';
    }
}

