/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.string;

import java.util.regex.Pattern;
import net.thevpc.nuts.NutsUtilStrings;

public class GlobUtils {
    private static final Pattern PATTERN_ALL = Pattern.compile(".*");

    public static Pattern ofExact(String pattern) {
        if (NutsUtilStrings.isBlank((CharSequence)pattern)) {
            return PATTERN_ALL;
        }
        return Pattern.compile(GlobUtils.simpexpToRegexp(pattern, false));
    }

    public static Pattern ofContains(String pattern) {
        if (NutsUtilStrings.isBlank((CharSequence)pattern)) {
            return PATTERN_ALL;
        }
        return Pattern.compile(GlobUtils.simpexpToRegexp(pattern, true));
    }

    private static String simpexpToRegexp(String pattern, boolean contains) {
        if (pattern == null) {
            pattern = "*";
        }
        char[] cc = pattern.toCharArray();
        StringBuilder sb = new StringBuilder();
        block4: for (int i = 0; i < cc.length; ++i) {
            char c = cc[i];
            switch (c) {
                case '!': 
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    sb.append('\\').append(c);
                    continue block4;
                }
                case '*': {
                    sb.append(".*");
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (!contains) {
            sb.insert(0, '^');
            sb.append('$');
        }
        return sb.toString();
    }
}

