/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.reflect;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.thevpc.nuts.runtime.bundles.reflect.ClassReflectType;
import net.thevpc.nuts.runtime.bundles.reflect.ReflectConfiguration;
import net.thevpc.nuts.runtime.bundles.reflect.ReflectConfigurationBuilder;
import net.thevpc.nuts.runtime.bundles.reflect.ReflectPropertyAccessStrategy;
import net.thevpc.nuts.runtime.bundles.reflect.ReflectPropertyDefaultValueStrategy;
import net.thevpc.nuts.runtime.bundles.reflect.ReflectRepository;
import net.thevpc.nuts.runtime.bundles.reflect.ReflectType;
import net.thevpc.nuts.runtime.bundles.reflect.ReflectUtils;

public class DefaultReflectRepository
implements ReflectRepository {
    private final Map<Type, ReflectType> beans = new HashMap<Type, ReflectType>();
    private final ReflectConfiguration configuration;

    public DefaultReflectRepository(ReflectConfiguration configurer) {
        this.configuration = configurer == null ? ReflectConfigurationBuilder.create().build() : configurer;
    }

    @Override
    public ReflectConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public ReflectType getType(Type clz) {
        ReflectType v = this.beans.get(clz);
        if (v == null) {
            v = this.create(clz);
            this.beans.put(clz, v);
        }
        return v;
    }

    private ReflectType create(Type clz) {
        Class raw = ReflectUtils.getRawClass(clz);
        ReflectPropertyAccessStrategy a = this.configuration.getAccessStrategy(raw);
        ReflectPropertyDefaultValueStrategy d = this.configuration.getDefaultValueStrategy(raw);
        return new ClassReflectType(clz, a, d, this);
    }
}

